/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.test.auth;

import io.jans.configapi.ConfigServerBaseTest;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class ConfigResourceTest
extends ConfigServerBaseTest {
    @Parameters(value={"test.issuer", "apiConfigtionUrl"})
    @Test
    public void getApiConfigtion(String issuer, String apiConfigtionUrl) {
        this.log.info("getApiConfigtion() - accessToken:{}, issuer:{}, apiConfigtionUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)apiConfigtionUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + apiConfigtionUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getApiConfigtion -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "apiConfigtionUrl", "api_config_patch_1"})
    @Test
    public void patchgetApiConfigtion(String issuer, String apiConfigtionUrl, String json) {
        this.log.info("getApiConfigtion() - accessToken:{}, issuer:{}, apiConfigtionUrl:{}, json:{}", (Object)this.accessToken, (Object)issuer, (Object)apiConfigtionUrl, (Object)json);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + apiConfigtionUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json-patch+json");
        Response response = request.method("PATCH", Entity.entity((Object)json, (String)"application/json-patch+json"));
        this.log.info("Response for patchgetApiConfigtion -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }
}

