/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.test.health;

import io.jans.configapi.ConfigServerBaseTest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class ApiHealthTest
extends ConfigServerBaseTest {
    @Parameters(value={"test.issuer", "healthUrl"})
    @Test
    public void getAppHealth(String issuer, String healthUrl) {
        this.log.info("accessToken:{}, issuer:{}, healthUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)healthUrl);
        Response response = this.getHealthResponse(issuer + healthUrl);
        this.log.info("Response for getAppHealth -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "healthUrl"})
    @Test
    public void getServerStat(String issuer, String healthUrl) {
        this.log.info("accessToken:{}, issuer:{}, healthUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)healthUrl);
        Response response = this.getHealthResponse(issuer + healthUrl + "/server-stat");
        this.log.info("Response for getServerStat -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "healthUrl"})
    @Test
    public void getApplicationVersion(String issuer, String healthUrl) {
        this.log.info("accessToken:{}, issuer:{}, healthUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)healthUrl);
        Response response = this.getHealthResponse(issuer + healthUrl + "/app-version");
        this.log.info("Response for getApplicationVersion -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "healthUrl"})
    @Test
    public void getServiceStatus(String issuer, String healthUrl) {
        this.log.info("accessToken:{}, issuer:{}, healthUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)healthUrl);
        Response response = this.getHealthResponse(issuer + healthUrl + "/service-status");
        this.log.info("Response for getServiceStatus -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    private Response getHealthResponse(String healthUrl) {
        this.log.info("accessToken:{}, healthUrl:{}", (Object)this.accessToken, (Object)healthUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(healthUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json");
        return request.get();
    }
}

