/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.filters;

import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.security.service.AuthorizationService;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;

@Provider
@ProtectedApi
@Priority(value=1000)
public class AuthorizationFilter
implements ContainerRequestFilter {
    private static final String AUTHENTICATION_SCHEME = "Bearer";
    @Inject
    Logger log;
    @Context
    UriInfo info;
    @Context
    HttpServletRequest request;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    AuthorizationService authorizationService;

    public void filter(ContainerRequestContext context) {
        this.log.info("=======================================================================");
        this.log.info("====== context = " + context + " , info.getAbsolutePath() = " + this.info.getAbsolutePath() + " , info.getRequestUri() = " + this.info.getRequestUri() + "\n\n");
        this.log.info("====== info.getBaseUri()=" + this.info.getBaseUri() + " info.getPath()=" + this.info.getPath() + " info.toString()=" + this.info.toString());
        this.log.info("====== request.getContextPath()=" + this.request.getContextPath() + " request.getRequestURI()=" + this.request.getRequestURI() + " request.toString() " + this.request.toString());
        this.log.info("======" + context.getMethod() + " " + this.info.getPath() + " FROM IP " + this.request.getRemoteAddr());
        this.log.info("======PERFORMING AUTHORIZATION=========================================");
        String authorizationHeader = context.getHeaderString("Authorization");
        String issuer = context.getHeaderString("issuer");
        boolean configOauthEnabled = this.authorizationService.isConfigOauthEnabled();
        this.log.info("\n\n\n AuthorizationFilter::filter() - authorizationHeader = " + authorizationHeader + " , issuer = " + issuer + " , configOauthEnabled = " + configOauthEnabled + "\n\n\n");
        if (!configOauthEnabled) {
            this.log.info("====== Authorization Granted...====== ");
            return;
        }
        this.log.info("\n\n\n AuthorizationFilter::filter() - Config Api OAuth Valdation Enabled");
        if (!this.isTokenBasedAuthentication(authorizationHeader)) {
            this.abortWithUnauthorized(context, "ONLY TOKEN BASED AUTHORIZATION IS SUPPORTED!");
            this.log.info("======ONLY TOKEN BASED AUTHORIZATION IS SUPPORTED======================");
            return;
        }
        try {
            authorizationHeader = this.authorizationService.processAuthorization(authorizationHeader, issuer, this.resourceInfo, context.getMethod(), this.request.getRequestURI());
            if (authorizationHeader != null && authorizationHeader.trim().length() > 0) {
                context.getHeaders().remove((Object)"Authorization");
                context.getHeaders().add((Object)"Authorization", (Object)authorizationHeader);
            }
            this.log.info("======AUTHORIZATION  GRANTED===========================================");
        }
        catch (Exception ex) {
            this.log.error("======AUTHORIZATION  FAILED ===========================================", (Throwable)ex);
            this.abortWithUnauthorized(context, ex.getMessage());
        }
    }

    private boolean isTokenBasedAuthentication(String authorizationHeader) {
        return authorizationHeader != null && authorizationHeader.toLowerCase().startsWith(AUTHENTICATION_SCHEME.toLowerCase() + " ");
    }

    private void abortWithUnauthorized(ContainerRequestContext requestContext, String errMsg) {
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errMsg).header("WWW-Authenticate", (Object)AUTHENTICATION_SCHEME).build());
    }
}

