/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.filters;

import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@Provider
@WebFilter(urlPatterns={"*"})
public class MetricFilter
implements Filter {
    private static final String METER = "meter_";
    private static final String COUNTER = "counter_";
    private static final String TIMER = "timer_";
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry metricRegistry;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private Metadata createMetaData(HttpServletRequest request, MetricType type, String prefix) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return new MetadataBuilder().withName(prefix + path).withDisplayName(prefix + path).withType(type).withUnit("seconds").build();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        this.metricRegistry.counter(this.createMetaData((HttpServletRequest)servletRequest, MetricType.COUNTER, COUNTER)).inc();
        Timer timer = this.metricRegistry.timer(this.createMetaData((HttpServletRequest)servletRequest, MetricType.TIMER, TIMER));
        Meter meter = this.metricRegistry.meter(this.createMetaData((HttpServletRequest)servletRequest, MetricType.METERED, METER));
        chain.doFilter(servletRequest, servletResponse);
        meter.mark();
        timer.time().stop();
    }

    public void destroy() {
    }
}

