/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.model.PatchRequest;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AttributeService;
import io.jans.model.JansAttribute;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Path(value="/attributes")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AttributesResource
extends ConfigBaseResource {
    private static final String JANS_ATTRIBUTE = "jans attribute";
    private static final String NAME_CONFLICT = "NAME_CONFLICT";
    private static final String NAME_CONFLICT_MSG = "Attribute with same name `%s` already exists!";
    @Inject
    Logger log;
    @Inject
    AttributeService attributeService;

    @Operation(summary="Gets a list of Jans attributes.", description="Gets a list of Jans attributes.", operationId="get-attributes", tags={"Attribute"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/attributes.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response example", value="example/attribute/attribute-get-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/attributes.readonly"}, groupScopes={"https://jans.io/oauth/config/attributes.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getAttributes(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="Status of the attribute") @DefaultValue(value="all") @QueryParam(value="status") String status, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="adminCanEdit=true,dataType=string")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Search Attribute filters with limit:{}, pattern:{}, status:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)status), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.attributeService.getDnForAttribute(null), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, JansAttribute.class);
        return Response.ok(this.doSearch(searchReq, status)).build();
    }

    @Operation(summary="Gets an attribute based on inum", description="Gets an attribute based on inum", operationId="get-attributes-by-inum", tags={"Attribute"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/attributes.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JansAttribute.class), examples={@ExampleObject(name="Response example", value="example/attribute/attribute-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/attributes.readonly"}, groupScopes={"https://jans.io/oauth/config/attributes.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="{inum}")
    public Response getAttributeByInum(@Parameter(description="Attribute Id") @PathParam(value="inum") @NotNull String inum) {
        JansAttribute attribute = this.attributeService.getAttributeByInum(inum);
        AttributesResource.checkResourceNotNull((Object)attribute, (String)JANS_ATTRIBUTE);
        return Response.ok((Object)attribute).build();
    }

    @Operation(summary="Adds a new attribute", description="Adds a new attribute", operationId="post-attributes", tags={"Attribute"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/attributes.write"})})
    @RequestBody(description="JansAttribute object", content={@Content(mediaType="application/json", schema=@Schema(implementation=JansAttribute.class), examples={@ExampleObject(name="Request example", value="example/attribute/attribute.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=JansAttribute.class), examples={@ExampleObject(name="Response example", value="example/attribute/attribute.json")})}), @ApiResponse(responseCode="400", description="BadRequest"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="406", description="NotAcceptable"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/attributes.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response createAttribute(@Valid JansAttribute attribute) {
        this.log.debug(" JansAttribute details to add - attribute:{}", (Object)attribute);
        AttributesResource.checkNotNull((String)attribute.getName(), (String)"name");
        AttributesResource.checkNotNull((String)attribute.getDisplayName(), (String)"displayName");
        AttributesResource.checkResourceNotNull((Object)attribute.getDataType(), (String)"dataType");
        List<JansAttribute> jansAttributes = this.attributeService.getAttributeWithName(attribute.getName());
        this.log.info("Check if attribute with same name exists - attribute.getName():{}, jansAttributes:{}", (Object)attribute.getName(), jansAttributes);
        if (jansAttributes != null && !jansAttributes.isEmpty()) {
            throw new WebApplicationException(AttributesResource.getNotAcceptableException((String)("Attribute with same name '" + attribute.getName() + "' already exists!")));
        }
        boolean attributeValidation = this.attributeService.validateAttributeDefinition(attribute.getName());
        this.log.info("** Validate attribute while creation - attribute.getName():{}, attributeValidation:{}", (Object)attribute.getName(), (Object)attributeValidation);
        if (!attributeValidation) {
            throw new WebApplicationException(AttributesResource.getNotAcceptableException((String)("The attribute '" + attribute.getName() + "' not defined in DB schema")));
        }
        String inum = this.attributeService.generateInumForNewAttribute();
        attribute.setInum(inum);
        attribute.setDn(this.attributeService.getDnForAttribute(inum));
        this.attributeService.addAttribute(attribute);
        JansAttribute result = this.attributeService.getAttributeByInum(inum);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    @Operation(summary="Updates an existing attribute", description="Updates an existing attribute", operationId="put-attributes", tags={"Attribute"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/attributes.write"})})
    @RequestBody(description="JansAttribute object", content={@Content(mediaType="application/json", schema=@Schema(implementation=JansAttribute.class), examples={@ExampleObject(name="Request example", value="example/attribute/attribute.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JansAttribute.class), examples={@ExampleObject(name="Response example", value="example/attribute/attribute.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="406", description="NotAcceptable"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/attributes.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateAttribute(@Valid JansAttribute attribute) {
        this.log.debug(" JansAttribute details to update - attribute:{}", (Object)attribute);
        String inum = attribute.getInum();
        AttributesResource.checkResourceNotNull((Object)inum, (String)JANS_ATTRIBUTE);
        AttributesResource.checkNotNull((String)attribute.getName(), (String)"name");
        AttributesResource.checkNotNull((String)attribute.getDisplayName(), (String)"displayName");
        AttributesResource.checkResourceNotNull((Object)attribute.getDataType(), (String)"dataType");
        List<JansAttribute> jansAttributes = this.attributeService.getAttributeWithName(attribute.getName());
        this.log.info("Check if attribute with inum different then:{} but with same name exists - attribute.getName():{}, jansAttributes:{}", new Object[]{inum, attribute.getName(), jansAttributes});
        if (jansAttributes != null && !jansAttributes.isEmpty()) {
            List list = jansAttributes.stream().filter(e -> !e.getInum().equalsIgnoreCase(inum)).collect(Collectors.toList());
            this.logger.info("Other JansAttribute's with same name:{} are list:{}", (Object)attribute.getName(), list);
            if (list != null && !list.isEmpty()) {
                AttributesResource.throwBadRequestException((String)NAME_CONFLICT, (String)String.format(NAME_CONFLICT_MSG, attribute.getName()));
            }
        } else {
            boolean attributeValidation = this.attributeService.validateAttributeDefinition(attribute.getName());
            this.log.info(" ** Validate attribute - attribute.getName():{}, attributeValidation:{}", (Object)attribute.getName(), (Object)attributeValidation);
            if (!attributeValidation) {
                throw new WebApplicationException(AttributesResource.getNotAcceptableException((String)("The attribute type '" + attribute.getName() + "' not defined in DB schema")));
            }
        }
        JansAttribute existingAttribute = this.attributeService.getAttributeByInum(inum);
        AttributesResource.checkResourceNotNull((Object)existingAttribute, (String)JANS_ATTRIBUTE);
        attribute.setInum(existingAttribute.getInum());
        attribute.setBaseDn(this.attributeService.getDnForAttribute(inum));
        this.attributeService.updateAttribute(attribute);
        JansAttribute result = this.attributeService.getAttributeByInum(inum);
        return Response.ok((Object)result).build();
    }

    @Operation(summary="Partially modify a JansAttribute", description="Partially modify a JansAttribute", operationId="patch-attributes-by-inum", tags={"Attribute"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/attributes.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=PatchRequest.class)), examples={@ExampleObject(name="Patch request example", value="example/attribute/attribute-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated JansAttribute", content={@Content(mediaType="application/json", schema=@Schema(implementation=JansAttribute.class), examples={@ExampleObject(name="Response example", value="example/attribute/attribute.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/attributes.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    @Path(value="{inum}")
    public Response patchAtribute(@Parameter(description="Attribute Id") @PathParam(value="inum") @NotNull String inum, @NotNull String pathString) throws JsonPatchException, IOException {
        this.log.debug(" JansAttribute details to patch - inum:{}, pathString:{}", (Object)inum, (Object)pathString);
        JansAttribute existingAttribute = this.attributeService.getAttributeByInum(inum);
        AttributesResource.checkResourceNotNull((Object)existingAttribute, (String)JANS_ATTRIBUTE);
        existingAttribute = (JansAttribute)Jackson.applyPatch((String)pathString, (Object)existingAttribute);
        this.attributeService.updateAttribute(existingAttribute);
        return Response.ok((Object)existingAttribute).build();
    }

    @Operation(summary="Deletes an attribute based on inum", description="Deletes an attribute based on inum", operationId="delete-attributes-by-inum", tags={"Attribute"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/attributes.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="{inum}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/attributes.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/delete-all"})
    public Response deleteAttribute(@Parameter(description="Attribute Id") @PathParam(value="inum") @NotNull String inum) {
        this.log.debug(" JansAttribute details to delete - inum:{}", (Object)inum);
        JansAttribute attribute = this.attributeService.getAttributeByInum(inum);
        AttributesResource.checkResourceNotNull((Object)attribute, (String)JANS_ATTRIBUTE);
        this.attributeService.removeAttribute(attribute);
        return Response.noContent().build();
    }

    private PagedResult<JansAttribute> doSearch(SearchRequest searchReq, String status) {
        this.logger.debug("JansAttribute search params - searchReq:{} , status:{} ", (Object)searchReq, (Object)status);
        PagedResult<JansAttribute> pagedResult = this.attributeService.searchJansAttributes(searchReq, status);
        this.logger.debug("PagedResult  - pagedResult:{}", pagedResult);
        if (pagedResult != null) {
            this.logger.debug("JansAttributes fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
        }
        this.logger.debug("JansAttributes pagedResult:{} ", pagedResult);
        return pagedResult;
    }
}

