/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.config.GluuConfiguration;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.InMemoryConfiguration;
import io.jans.service.cache.MemcachedConfiguration;
import io.jans.service.cache.NativePersistenceConfiguration;
import io.jans.service.cache.RedisConfiguration;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.function.Function;

@Path(value="/config/cache")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CacheConfigurationResource
extends ConfigBaseResource {
    private static final String ERROR_MSG = "Unable to apply patch.";
    @Inject
    ConfigurationService configurationService;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceManager;

    private CacheConfiguration loadCacheConfiguration() {
        return this.configurationService.findGluuConfiguration().getCacheConfiguration();
    }

    private CacheConfiguration mergeModifiedCache(Function<CacheConfiguration, CacheConfiguration> function) {
        GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
        CacheConfiguration modifiedCache = function.apply(gluuConfiguration.getCacheConfiguration());
        gluuConfiguration.setCacheConfiguration(modifiedCache);
        this.persistenceManager.merge((Object)gluuConfiguration);
        return modifiedCache;
    }

    @Operation(summary="Returns cache configuration.", description="Returns cache configuration.", operationId="get-config-cache", tags={"Cache Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=CacheConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.readonly"}, groupScopes={"https://jans.io/oauth/config/cache.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getCacheConfiguration() {
        return Response.ok((Object)this.loadCacheConfiguration()).build();
    }

    @Operation(summary="Patch cache configuration.", description="Patch cache configuration", operationId="patch-config-cache", tags={"Cache Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/cache/cache-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=CacheConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchCacheConfiguration(@NotNull String requestString) {
        this.logger.debug(" CACHE details to patch - requestString:{}", (Object)requestString);
        CacheConfiguration modifiedCache = this.mergeModifiedCache(cache -> {
            try {
                return (CacheConfiguration)Jackson.applyPatch((String)requestString, (Object)cache);
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)modifiedCache).build();
    }

    @Operation(summary="Returns Redis cache configuration.", description="Returns Redis cache configuration", operationId="get-config-cache-redis", tags={"Cache Configuration \u2013 Redis"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Redis cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/redis")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.readonly"}, groupScopes={"https://jans.io/oauth/config/cache.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getRedisConfiguration() {
        return Response.ok((Object)this.loadCacheConfiguration().getRedisConfiguration()).build();
    }

    @Operation(summary="Updates Redis cache configuration.", description="Updates Redis cache configuration", operationId="put-config-cache-redis", tags={"Cache Configuration \u2013 Redis"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="RedisConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/cache/cache-redis.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Redis cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Path(value="/redis")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateRedisConfiguration(@NotNull RedisConfiguration redisConfiguration) {
        this.logger.debug("REDIS CACHE details to update - redisConfiguration:{}", (Object)redisConfiguration);
        CacheConfiguration modifiedCache = this.mergeModifiedCache(cache -> {
            cache.setRedisConfiguration(redisConfiguration);
            return cache;
        });
        return Response.ok((Object)modifiedCache.getRedisConfiguration()).build();
    }

    @Operation(summary="Patch Redis cache configuration.", description="Patch Redis cache configuration", operationId="patch-config-cache-redis", tags={"Cache Configuration \u2013 Redis"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/cache/cache-redis-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Redis cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Path(value="/redis")
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchRedisConfiguration(@NotNull String requestString) {
        this.logger.debug("REDIS CACHE details to patch - requestString:{} ", (Object)requestString);
        this.mergeModifiedCache(cache -> {
            try {
                cache.setRedisConfiguration((RedisConfiguration)Jackson.applyPatch((String)requestString, (Object)this.loadCacheConfiguration().getRedisConfiguration()));
                return cache;
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)this.loadCacheConfiguration().getRedisConfiguration()).build();
    }

    @Operation(summary="Returns in-Memory cache configuration.", description="Returns in-Memory cache configuration.", operationId="get-config-cache-in-memory", tags={"Cache Configuration \u2013 in-Memory"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="In-Memory configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=InMemoryConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-in-memory.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/in-memory")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.readonly"}, groupScopes={"https://jans.io/oauth/config/cache.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getInMemoryConfiguration() {
        return Response.ok((Object)this.loadCacheConfiguration().getInMemoryConfiguration()).build();
    }

    @Operation(summary="Updates in-Memory cache configuration.", description="Updates in-Memory cache configuration", operationId="put-config-cache-in-memory", tags={"Cache Configuration \u2013 in-Memory"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="inMemoryConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=InMemoryConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/cache/cache-in-memory.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="In-Memory cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=InMemoryConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-in-memory.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Path(value="/in-memory")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateInMemoryConfiguration(@NotNull InMemoryConfiguration inMemoryConfiguration) {
        this.logger.debug("IN_MEMORY CACHE details to update - inMemoryConfiguration:{}", (Object)inMemoryConfiguration);
        CacheConfiguration modifiedCache = this.mergeModifiedCache(cache -> {
            cache.setInMemoryConfiguration(inMemoryConfiguration);
            return cache;
        });
        return Response.ok((Object)modifiedCache.getInMemoryConfiguration()).build();
    }

    @Operation(summary="Patch In-Memory cache configuration.", description="Patch In-Memory cache configuration", operationId="patch-config-cache-in-memory", tags={"Cache Configuration \u2013 in-Memory"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/cache/cache-in-memory-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="In-Memory cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=InMemoryConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-in-memory.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Path(value="/in-memory")
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchInMemoryConfiguration(@NotNull String requestString) {
        this.logger.debug("IN_MEMORY CACHE details to patch - requestString:{}", (Object)requestString);
        this.mergeModifiedCache(cache -> {
            try {
                cache.setInMemoryConfiguration((InMemoryConfiguration)Jackson.applyPatch((String)requestString, (Object)cache.getInMemoryConfiguration()));
                return cache;
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)this.loadCacheConfiguration().getInMemoryConfiguration()).build();
    }

    @Operation(summary="Returns native persistence cache configuration.", description="Returns native persistence cache configuration.", operationId="get-config-cache-native-persistence", tags={"Cache Configuration \u2013 Native-Persistence"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Native persistence configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=NativePersistenceConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-native-persistence.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/native-persistence")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.readonly"}, groupScopes={"https://jans.io/oauth/config/cache.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getNativePersistenceConfiguration() {
        return Response.ok((Object)this.loadCacheConfiguration().getNativePersistenceConfiguration()).build();
    }

    @Operation(summary="Updates native persistence cache configuration.", description="Updates native persistence cache configuration", operationId="put-config-cache-native-persistence", tags={"Cache Configuration \u2013 Native-Persistence"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="NativePersistenceConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=NativePersistenceConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/cache/cache-native-persistence.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Native persistence cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=NativePersistenceConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-native-persistence.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Path(value="/native-persistence")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateNativePersistenceConfiguration(@NotNull NativePersistenceConfiguration nativePersistenceConfiguration) {
        this.logger.debug("NATIVE_PERSISTENCE CACHE details to update - nativePersistenceConfiguration:{}", (Object)nativePersistenceConfiguration);
        CacheConfiguration modifiedCache = this.mergeModifiedCache(cache -> {
            cache.setNativePersistenceConfiguration(nativePersistenceConfiguration);
            return cache;
        });
        return Response.ok((Object)modifiedCache.getNativePersistenceConfiguration()).build();
    }

    @Operation(summary="Patch native persistence cache configuration.", description="Patch native persistence cache configuration", operationId="patch-config-cache-native-persistence", tags={"Cache Configuration \u2013 Native-Persistence"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/cache/cache-native-persistence-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Native persistence cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=NativePersistenceConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-native-persistence.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Path(value="/native-persistence")
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchNativePersistenceConfiguration(@NotNull String requestString) {
        this.logger.debug("NATIVE_PERSISTENCE CACHE details to patch - requestString:{} ", (Object)requestString);
        this.mergeModifiedCache(cache -> {
            try {
                cache.setNativePersistenceConfiguration((NativePersistenceConfiguration)Jackson.applyPatch((String)requestString, (Object)cache.getNativePersistenceConfiguration()));
                return cache;
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)this.loadCacheConfiguration().getNativePersistenceConfiguration()).build();
    }

    @Operation(summary="Returns memcached cache configuration.", description="Returns memcached cache configuration.", operationId="get-config-cache-memcached", tags={"Cache Configuration \u2013 Memcached"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Memcached configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemcachedConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-memcached.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/memcached")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.readonly"}, groupScopes={"https://jans.io/oauth/config/cache.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getMemcachedConfiguration() {
        return Response.ok((Object)this.loadCacheConfiguration().getMemcachedConfiguration()).build();
    }

    @Operation(summary="Updates memcached cache configuration.", description="Updates memcached cache configuration", operationId="put-config-cache-memcached", tags={"Cache Configuration \u2013 Memcached"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="Memcached Configuration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemcachedConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/cache/cache-memcached.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Native persistence cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemcachedConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-memcached.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Path(value="/memcached")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateMemcachedConfiguration(@NotNull MemcachedConfiguration memcachedConfiguration) {
        this.logger.debug("MEMCACHED CACHE details to update - memcachedConfiguration:{} ", (Object)memcachedConfiguration);
        CacheConfiguration modifiedCache = this.mergeModifiedCache(cache -> {
            cache.setMemcachedConfiguration(memcachedConfiguration);
            return cache;
        });
        return Response.ok((Object)modifiedCache.getMemcachedConfiguration()).build();
    }

    @Operation(summary="Patch memcached cache configuration.", description="Patch memcached cache configuration", operationId="patch-config-cache-memcached", tags={"Cache Configuration \u2013 Memcached"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/cache.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/cache/cache-memcached-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Memcached cache configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=MemcachedConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/cache/cache-memcached.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Path(value="/memcached")
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/cache.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchMemcachedConfiguration(@NotNull String requestString) {
        this.logger.debug("MEMCACHED CACHE details to patch - requestString:{} ", (Object)requestString);
        this.mergeModifiedCache(cache -> {
            try {
                cache.setMemcachedConfiguration((MemcachedConfiguration)Jackson.applyPatch((String)requestString, (Object)cache.getMemcachedConfiguration()));
                return cache;
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)this.loadCacheConfiguration().getMemcachedConfiguration()).build();
    }
}

