/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.LdapConfigurationService;
import io.jans.configapi.util.ConnectionStatus;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;

@Path(value="/config/database/ldap")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LdapConfigurationResource
extends ConfigBaseResource {
    @Inject
    LdapConfigurationService ldapConfigurationService;
    @Inject
    ConnectionStatus connectionStatus;

    @Operation(summary="Gets list of existing LDAP configurations.", description="Gets list of existing LDAP configurations.", operationId="get-config-database-ldap", tags={"Database - LDAP configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database/ldap.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GluuLdapConfiguration.class)), examples={@ExampleObject(name="Response json example", value="example/auth/database/ldap/ldap-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database/ldap.readonly"}, groupScopes={"https://jans.io/oauth/config/database/ldap.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getLdapConfiguration() {
        List<GluuLdapConfiguration> ldapConfigurationList = this.ldapConfigurationService.findLdapConfigurations();
        return Response.ok(ldapConfigurationList).build();
    }

    @Operation(summary="Gets an LDAP configuration by name.", description="Gets an LDAP configuration by name.", operationId="get-config-database-ldap-by-name", tags={"Database - LDAP configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database/ldap.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/database/ldap/ldap.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/{name}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database/ldap.readonly"}, groupScopes={"https://jans.io/oauth/config/database/ldap.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getLdapConfigurationByName(@Parameter(description="Name of LDAP configuration") @PathParam(value="name") String name) {
        GluuLdapConfiguration ldapConfiguration = this.findLdapConfigurationByName(name);
        return Response.ok((Object)ldapConfiguration).build();
    }

    @Operation(summary="Adds a new LDAP configuration", description="Adds a new LDAP configuration", operationId="post-config-database-ldap", tags={"Database - LDAP configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database/ldap.write"})})
    @RequestBody(description="GluuLdapConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/auth/database/ldap/ldap.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/database/ldap/ldap.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="406", description="Not Acceptable"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database/ldap.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response addLdapConfiguration(@Valid @NotNull GluuLdapConfiguration ldapConfiguration) {
        this.logger.debug("LDAP configuration to be added - ldapConfiguration:{} ", (Object)ldapConfiguration);
        try {
            ldapConfiguration = this.findLdapConfigurationByName(ldapConfiguration.getConfigId());
            this.logger.error("Ldap Configuration with same name:{}  already exists!", (Object)ldapConfiguration.getConfigId());
            throw new NotAcceptableException(LdapConfigurationResource.getNotAcceptableException((String)("Ldap Configuration with same name - '" + ldapConfiguration.getConfigId() + "' already exists!")));
        }
        catch (NotFoundException ne) {
            this.ldapConfigurationService.save(ldapConfiguration);
            ldapConfiguration = this.findLdapConfigurationByName(ldapConfiguration.getConfigId());
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ldapConfiguration).build();
        }
    }

    @Operation(summary="Updates LDAP configuration", description="Updates LDAP configuration", operationId="put-config-database-ldap", tags={"Database - LDAP configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database/ldap.write"})})
    @RequestBody(description="GluuLdapConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/auth/database/ldap/ldap.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/database/ldap/ldap.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database/ldap.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateLdapConfiguration(@Valid @NotNull GluuLdapConfiguration ldapConfiguration) {
        this.logger.debug("LDAP configuration to be updated - ldapConfiguration:{}", (Object)ldapConfiguration);
        this.findLdapConfigurationByName(ldapConfiguration.getConfigId());
        this.ldapConfigurationService.update(ldapConfiguration);
        return Response.ok((Object)ldapConfiguration).build();
    }

    @Operation(summary="Deletes an LDAP configuration", description="Deletes an LDAP configuration", operationId="delete-config-database-ldap-by-name", tags={"Database - LDAP configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database/ldap.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="/{name}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database/ldap.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/delete-all"})
    public Response deleteLdapConfigurationByName(@PathParam(value="name") String name) {
        this.logger.debug("LDAP configuration to be deleted - name:{}", (Object)name);
        this.findLdapConfigurationByName(name);
        this.logger.info("Deleting Ldap Configuration by name:{}", (Object)name);
        this.ldapConfigurationService.remove(name);
        return Response.noContent().build();
    }

    @Operation(summary="Patches a LDAP configuration by name", description="Patches a LDAP configuration by name", operationId="patch-config-database-ldap-by-name", tags={"Database - LDAP configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database/ldap.write"})})
    @RequestBody(description="JsonPatch object", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/auth/database/ldap/ldap-patch")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/database/ldap/ldap.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Path(value="/{name}")
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database/ldap.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchLdapConfigurationByName(@Parameter(description="Name of LDAP configuration") @PathParam(value="name") String name, @NotNull String requestString) throws JsonPatchException, IOException {
        this.logger.debug("LDAP configuration to be patched - name:{}, requestString:{} ", (Object)name, (Object)requestString);
        GluuLdapConfiguration ldapConfiguration = this.findLdapConfigurationByName(name);
        this.logger.info("Patch Ldap Configuration by name:{} ", (Object)name);
        ldapConfiguration = (GluuLdapConfiguration)Jackson.applyPatch((String)requestString, (Object)ldapConfiguration);
        this.ldapConfigurationService.update(ldapConfiguration);
        return Response.ok((Object)ldapConfiguration).build();
    }

    @Operation(summary="Tests an LDAP configuration", description="Tests an LDAP configuration", operationId="post-config-database-ldap-test", tags={"Database - LDAP configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/database/ldap.readonly"})})
    @RequestBody(description="GluuLdapConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuLdapConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/auth/database/ldap/ldap-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(name="status", type="boolean", description="boolean value true if successful"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @Path(value="/test")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/database/ldap.readonly"}, groupScopes={"https://jans.io/oauth/config/database/ldap.write"}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response testLdapConfigurationByName(@Valid @NotNull GluuLdapConfiguration ldapConfiguration) {
        this.logger.debug("LDAP configuration to be tested - ldapConfiguration:{}", (Object)ldapConfiguration);
        boolean status = this.connectionStatus.isUp(ldapConfiguration);
        this.logger.info("LdapConfigurationResource:::testLdapConfigurationByName() - status:{}", (Object)status);
        return Response.ok((Object)status).build();
    }

    private GluuLdapConfiguration findLdapConfigurationByName(String name) {
        try {
            return this.ldapConfigurationService.findByName(name);
        }
        catch (NoSuchElementException ex) {
            this.logger.error("Could not find Ldap Configuration by name '" + name + "'", (Throwable)ex);
            throw new NotFoundException(LdapConfigurationResource.getNotFoundError((String)("Ldap Configuration - '" + name + "'")));
        }
    }
}

