/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.config.GluuConfiguration;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.message.model.config.MessageConfiguration;
import io.jans.service.message.model.config.PostgresMessageConfiguration;
import io.jans.service.message.model.config.RedisMessageConfiguration;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.function.Function;

@Path(value="/config/message")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MessageConfigurationResource
extends ConfigBaseResource {
    private static final String ERROR_MSG = "Unable to apply patch.";
    @Inject
    ConfigurationService configurationService;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceManager;

    private MessageConfiguration loadMessageConfiguration() {
        return this.configurationService.findGluuConfiguration().getMessageConfiguration();
    }

    private MessageConfiguration mergeModifiedMessage(Function<MessageConfiguration, MessageConfiguration> function) {
        GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
        MessageConfiguration modifiedMessage = function.apply(gluuConfiguration.getMessageConfiguration());
        gluuConfiguration.setMessageConfiguration(modifiedMessage);
        this.persistenceManager.merge((Object)gluuConfiguration);
        return modifiedMessage;
    }

    @Operation(summary="Returns message configuration.", description="Returns message configuration.", operationId="get-config-message", tags={"Message Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Message configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.readonly"}, groupScopes={"https://jans.io/oauth/config/message.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getMessageConfiguration() {
        return Response.ok((Object)this.loadMessageConfiguration()).build();
    }

    @Operation(summary="Patch message configuration.", description="Patch message configuration", operationId="patch-config-message", tags={"Message Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/message/message-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Message configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchMessageConfiguration(@NotNull String requestString) {
        this.logger.debug(" MESSAGE details to patch - requestString:{}", (Object)requestString);
        MessageConfiguration modifiedMessage = this.mergeModifiedMessage(message -> {
            try {
                return (MessageConfiguration)Jackson.applyPatch((String)requestString, (Object)message);
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)modifiedMessage).build();
    }

    @Operation(summary="Returns Redis message configuration.", description="Returns Redis message configuration", operationId="get-config-message-redis", tags={"Message Configuration \u2013 Redis"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Redis message configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisMessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/redis")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.readonly"}, groupScopes={"https://jans.io/oauth/config/message.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getRedisMessageConfiguration() {
        return Response.ok((Object)this.loadMessageConfiguration().getRedisConfiguration()).build();
    }

    @Operation(summary="Updates Redis message configuration.", description="Updates Redis message configuration", operationId="put-config-message-redis", tags={"Message Configuration \u2013 Redis"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.write"})})
    @RequestBody(description="RedisMessageConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisMessageConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/message/message-redis.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Redis message configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisMessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Path(value="/redis")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateRedisMessageConfiguration(@NotNull RedisMessageConfiguration redisConfiguration) {
        this.logger.debug("REDIS MESSAGE details to update - redisConfiguration:{}", (Object)redisConfiguration);
        MessageConfiguration modifiedMessage = this.mergeModifiedMessage(message -> {
            message.setRedisConfiguration(redisConfiguration);
            return message;
        });
        return Response.ok((Object)modifiedMessage.getRedisConfiguration()).build();
    }

    @Operation(summary="Patch Redis message configuration.", description="Patch Redis message configuration", operationId="patch-config-message-redis", tags={"Message Configuration \u2013 Redis"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/message/message-redis-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Redis message configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedisMessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Path(value="/redis")
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchRedisMessageConfiguration(@NotNull String requestString) {
        this.logger.debug("REDIS MESSAGE details to patch - requestString:{} ", (Object)requestString);
        this.mergeModifiedMessage(message -> {
            try {
                message.setRedisConfiguration((RedisMessageConfiguration)Jackson.applyPatch((String)requestString, (Object)this.loadMessageConfiguration().getRedisConfiguration()));
                return message;
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)this.loadMessageConfiguration().getRedisConfiguration()).build();
    }

    @Operation(summary="Returns Postgres message configuration.", description="Returns Postgres message configuration.", operationId="get-config-message-postgres", tags={"Message Configuration \u2013 Postgres"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Native persistence configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostgresMessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/postgres")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.readonly"}, groupScopes={"https://jans.io/oauth/config/message.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getPostgresConfiguration() {
        return Response.ok((Object)this.loadMessageConfiguration().getPostgresConfiguration()).build();
    }

    @Operation(summary="Updates Postgres message configuration.", description="Updates Postgres message configuration", operationId="put-config-message-postgres", tags={"Message Configuration \u2013 Postgres"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.write"})})
    @RequestBody(description="PostgresMessageConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostgresMessageConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/message/message-redis.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Native persistence message configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostgresMessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Path(value="/postgres")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updatePostgresMessageConfiguration(@NotNull PostgresMessageConfiguration postgresMessageConfiguration) {
        this.logger.debug("POSTGRES_PERSISTENCE MESSAGE details to update - postgresMessageConfiguration:{}", (Object)postgresMessageConfiguration);
        MessageConfiguration modifiedMessage = this.mergeModifiedMessage(message -> {
            message.setPostgresConfiguration(postgresMessageConfiguration);
            return message;
        });
        return Response.ok((Object)modifiedMessage.getPostgresConfiguration()).build();
    }

    @Operation(summary="Patch Postgres message configuration.", description="Patch Postgres message configuration", operationId="patch-config-message-postgres", tags={"Message Configuration \u2013 Postgres"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/message.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/message/message-redis-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Native persistence message configuration details", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostgresMessageConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/message/message-redis.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Path(value="/postgres")
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/message.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchPostgresMessageConfiguration(@NotNull String requestString) {
        this.logger.debug("POSTGRES_PERSISTENCE MESSAGE details to patch - requestString:{} ", (Object)requestString);
        this.mergeModifiedMessage(message -> {
            try {
                message.setPostgresConfiguration((PostgresMessageConfiguration)Jackson.applyPatch((String)requestString, (Object)message.getPostgresConfiguration()));
                return message;
            }
            catch (JsonPatchException | IOException e) {
                throw new InternalServerErrorException(ERROR_MSG, e);
            }
        });
        return Response.ok((Object)this.loadMessageConfiguration().getPostgresConfiguration()).build();
    }
}

