/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AuthService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/stat")
public class StatResource
extends ConfigBaseResource {
    private final String statUrl = "/jans-auth/restv1/internal/stat";
    @Inject
    Logger logger;
    @Inject
    ConfigurationService configurationService;
    @Inject
    AuthService authService;

    @Operation(summary="Provides server with basic statistic", description="Provides server with basic statistic", operationId="get-stat", tags={"Statistics - User"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/stats.readonly", "jans_stat"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Stats", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=JsonNode.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/stats.readonly", "jans_stat"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Produces(value={"application/json"})
    public Response getStatistics(@Parameter(description="Authorization code") @HeaderParam(value="Authorization") String authorization, @Parameter(description="Month for which the stat report is to be fetched. The parameter is mandatory if start_month and end_month parameters are not present.", example="202012 (2020 Dec) 202101 (2021 Jan)") @QueryParam(value="month") String month, @Parameter(description="Start-Month for which the stat report is to be fetched") @QueryParam(value="start_month") String startMonth, @Parameter(description="End-Month for which the stat report is to be fetched") @QueryParam(value="end_month") String endMonth, @Parameter(description="Report format") @QueryParam(value="format") String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = "";
        }
        String url = this.getIssuer() + this.statUrl;
        JsonNode jsonNode = this.authService.getStat(url, authorization, month, startMonth, endMonth, format);
        this.logger.trace("StatResource::getUserStatistics() - jsonNode:{} ", (Object)jsonNode);
        return Response.ok((Object)jsonNode.get("response")).build();
    }

    private String getIssuer() {
        return this.configurationService.find().getIssuer();
    }
}

