/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.model.uma.persistence.UmaResource;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ClientService;
import io.jans.configapi.service.auth.UmaResourceService;
import io.jans.model.SearchRequest;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

@Path(value="/uma/resources")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UmaResourcesResource
extends ConfigBaseResource {
    private static final String UMA_RESOURCE = "Uma resource";
    @Inject
    UmaResourceService umaResourceService;
    @Inject
    ClientService clientService;

    @Operation(summary="Gets list of UMA resources", description="Gets list of UMA resources", operationId="get-oauth-uma-resources", tags={"OAuth - UMA Resources"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/uma/resources.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response json example", value="example/uma/resources/uma-resources-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/uma/resources.readonly"}, groupScopes={"https://jans.io/oauth/config/uma/resources.write", "https://jans.io/oauth/config/uma-read"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response fetchUmaResources(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="deletable=true")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("UMA_RESOURCE to be fetched - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.umaResourceService.getBaseDnForResource(), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, UmaResource.class);
        return Response.ok(this.doSearch(searchReq)).build();
    }

    @Operation(summary="Gets an UMA resource by ID", description="Gets an UMA resource by ID", operationId="get-oauth-uma-resources-by-id", tags={"OAuth - UMA Resources"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/uma/resources.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=UmaResource.class), examples={@ExampleObject(name="Response json example", value="example/uma/resources/uma-resources.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="{id}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/uma/resources.readonly"}, groupScopes={"https://jans.io/oauth/config/uma/resources.write", "https://jans.io/oauth/config/uma-read"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getUmaResourceByInum(@Parameter(description="Resource description ID") @PathParam(value="id") @NotNull String id) {
        this.logger.debug("UMA_RESOURCE to fetch by id:{}", (Object)id);
        return Response.ok((Object)this.findOrThrow(id)).build();
    }

    @Operation(summary="Fetch uma resources by client id", description="Fetch uma resources by client id", operationId="get-oauth-uma-resources-by-clientid", tags={"OAuth - UMA Resources"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/uma/resources.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=UmaResource.class)), examples={@ExampleObject(name="Response json example", value="example/uma/resources/uma-resources-by-client.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/clientId/{clientId}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/uma/resources.readonly"}, groupScopes={"https://jans.io/oauth/config/uma/resources.write", "https://jans.io/oauth/config/uma-read"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getUmaResourceByAssociatedClient(@Parameter(description="Client ID") @PathParam(value="clientId") @NotNull String associatedClientId) {
        this.logger.debug("UMA_RESOURCE to fetch by associatedClientId:{} ", (Object)associatedClientId);
        return Response.ok(this.getUmaResourceByClient(associatedClientId)).build();
    }

    @Operation(summary="Creates an UMA resource", description="Creates an UMA resource", operationId="post-oauth-uma-resources", tags={"OAuth - UMA Resources"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/uma/resources.write"})})
    @RequestBody(description="UmaResource object", content={@Content(mediaType="application/json", schema=@Schema(implementation=UmaResource.class), examples={@ExampleObject(name="Request json example", value="example/uma/resources/uma-resources-post.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=UmaResource.class), examples={@ExampleObject(name="Response json example", value="example/uma/resources/uma-resources.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/uma/resources.write"}, groupScopes={"https://jans.io/oauth/config/uma-write"}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response createUmaResource(@Valid UmaResource umaResource) {
        this.logger.debug("UMA_RESOURCE to be added umaResource:{}", (Object)umaResource);
        UmaResourcesResource.checkNotNull((String)umaResource.getName(), (String)"name");
        UmaResourcesResource.checkNotNull((String)umaResource.getDescription(), (String)"description");
        String id = UUID.randomUUID().toString();
        umaResource.setId(id);
        umaResource.setDn(this.umaResourceService.getDnForResource(id));
        this.umaResourceService.addResource(umaResource);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)umaResource).build();
    }

    private UmaResource findOrThrow(String id) {
        try {
            UmaResource existingResource = this.umaResourceService.getResourceById(id);
            UmaResourcesResource.checkResourceNotNull((Object)existingResource, (String)UMA_RESOURCE);
            return existingResource;
        }
        catch (EntryPersistenceException e) {
            throw new NotFoundException(UmaResourcesResource.getNotFoundError((String)UMA_RESOURCE));
        }
    }

    @Operation(summary="Updates an UMA resource", description="Updates an UMA resource", operationId="put-oauth-uma-resources", tags={"OAuth - UMA Resources"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/uma/resources.write"})})
    @RequestBody(description="UmaResource object", content={@Content(mediaType="application/json", schema=@Schema(implementation=UmaResource.class), examples={@ExampleObject(name="Request json example", value="example/uma/resources/uma-resources.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="UmaResource", content={@Content(mediaType="application/json", schema=@Schema(implementation=UmaResource.class), examples={@ExampleObject(name="Response json example", value="example/uma/resources/uma-resources.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/uma/resources.write"}, groupScopes={"https://jans.io/oauth/config/uma-write"}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateUmaResource(@Valid UmaResource resource) {
        this.logger.debug("UMA_RESOURCE to be upated - umaResource:{}", (Object)resource);
        String id = resource.getId();
        UmaResourcesResource.checkNotNull((String)id, (String)"id");
        UmaResource existingResource = this.findOrThrow(id);
        resource.setId(existingResource.getId());
        resource.setDn(this.umaResourceService.getDnForResource(id));
        this.umaResourceService.updateResource(resource);
        return Response.ok((Object)resource).build();
    }

    @Operation(summary="Patch UMA resource", description="Patch UMA resource", operationId="patch-oauth-uma-resources-by-id", tags={"OAuth - UMA Resources"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/uma/resources.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/uma/resources/uma-resources-patch")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=UmaResource.class), examples={@ExampleObject(name="Response json example", value="example/uma/resources/uma-resources.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/uma/resources.write"}, groupScopes={"https://jans.io/oauth/config/uma-write"}, superScopes={"https://jans.io/oauth/config/write-all"})
    @Path(value="{id}")
    public Response patchResource(@Parameter(description="Resource description ID") @PathParam(value="id") @NotNull String id, @NotNull String pathString) throws JsonPatchException, IOException {
        this.logger.debug("Patch for  id:{} , pathString:{}", (Object)id, (Object)pathString);
        UmaResource existingResource = this.findOrThrow(id);
        existingResource = (UmaResource)Jackson.applyPatch((String)pathString, (Object)existingResource);
        this.umaResourceService.updateResource(existingResource);
        return Response.ok((Object)existingResource).build();
    }

    @Operation(summary="Deletes an UMA resource", description="Deletes an UMA resource", operationId="delete-oauth-uma-resources-by-id", tags={"OAuth - UMA Resources"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/uma/resources.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="{id}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/uma/resources.delete"}, groupScopes={"https://jans.io/oauth/config/uma-delete"}, superScopes={"https://jans.io/oauth/config/delete-all"})
    public Response deleteUmaResource(@Parameter(description="Resource description ID") @PathParam(value="id") @NotNull String id) {
        this.logger.debug("UMA_RESOURCE to delete - id:{}", (Object)id);
        UmaResource umaResource = this.findOrThrow(id);
        this.umaResourceService.remove(umaResource);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private List<UmaResource> getUmaResourceByClient(String associatedClientId) {
        this.logger.debug("UMA RESOURCE to be fetched based on  associatedClientId:{}", (Object)associatedClientId);
        String associatedClientDn = this.clientService.getDnForClient(associatedClientId);
        this.logger.debug("UMA RESOURCE to be fetched based on  associatedClientId:{}", (Object)associatedClientId);
        return this.umaResourceService.getResourcesByClient(associatedClientDn);
    }

    private PagedResult<UmaResource> doSearch(SearchRequest searchReq) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("UmaResource search params - searchReq:{} ", (Object)Util.escapeLog((Object)searchReq));
        }
        PagedResult<UmaResource> pagedResult = this.umaResourceService.searchUmaResource(searchReq);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("UmaResource PagedResult  - pagedResult:{}", pagedResult);
        }
        if (pagedResult != null) {
            this.logger.debug("UmaResource fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
        }
        this.logger.debug("UmaResource  - pagedResult:{}", pagedResult);
        return pagedResult;
    }
}

