/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.jans.as.client.JwkResponse;
import io.jans.as.client.RevokeSessionRequest;
import io.jans.as.client.RevokeSessionResponse;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.client.service.IntrospectionService;
import io.jans.as.client.service.StatService;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.IntrospectionResponse;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.security.client.ClientFactoryUtil;
import io.jans.configapi.security.client.OpenIdClientService;
import io.jans.configapi.security.client.StatClient;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterProviders(value={@RegisterProvider(value=OpenIdClientService.class), @RegisterProvider(value=StatClient.class)})
@ApplicationScoped
public class AuthClientFactory {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AUTHORIZATION = "Authorization";
    private static Logger log = LoggerFactory.getLogger(AuthClientFactory.class);

    public static IntrospectionService getIntrospectionService(String url, boolean followRedirects) {
        return AuthClientFactory.createIntrospectionService(url, followRedirects);
    }

    public static IntrospectionResponse getIntrospectionResponse(String url, String header, String token, boolean followRedirects) {
        log.debug("Introspect Token - url:{}, header:{}, token:{} ,followRedirects:{} ", new Object[]{url, header, token, followRedirects});
        ResteasyWebTarget target = (ResteasyWebTarget)((Client)ClientBuilder.newClient().property(CONTENT_TYPE, (Object)"application/json")).target(url);
        IntrospectionService proxy = (IntrospectionService)target.proxy(IntrospectionService.class);
        return proxy.introspectToken(header, token);
    }

    public static JsonNode getStatResponse(String url, String token, String month, String startMonth, String endMonth, String format) {
        if (log.isDebugEnabled()) {
            log.debug("Stat Response Token - url:{}, token:{}, month:{}, startMonth:{}, endMonth:{}, format:{} ", new Object[]{Util.escapeLog((Object)url), Util.escapeLog((Object)token), Util.escapeLog((Object)month), Util.escapeLog((Object)startMonth), Util.escapeLog((Object)endMonth), Util.escapeLog((Object)format)});
        }
        ResteasyWebTarget webTarget = (ResteasyWebTarget)ClientBuilder.newClient().target(url);
        StatService statService = (StatService)webTarget.proxy(StatService.class);
        return statService.stat(token, month, startMonth, endMonth, format);
    }

    public static JsonNode getHealthCheckResponse(String url) {
        log.debug("HealthCheck - , url:{} ", (Object)url);
        Invocation.Builder clientRequest = AuthClientFactory.getClientBuilder(url);
        clientRequest.header(CONTENT_TYPE, (Object)"application/json");
        Response healthResponse = clientRequest.get();
        if (healthResponse.getStatus() == 200) {
            JsonNode jsonNode = (JsonNode)healthResponse.readEntity(JsonNode.class);
            log.trace("Health Check Response is - jsonNode:{}", (Object)jsonNode);
            return jsonNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenResponse requestAccessToken(String tokenUrl, String clientId, String clientSecret, String scope) {
        log.debug("Request for Access Token -  tokenUrl:{}, clientId:{}, clientSecret:{}, scope:{} ", new Object[]{tokenUrl, clientId, clientSecret, scope});
        try (Response response = null;){
            TokenRequest tokenRequest = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
            tokenRequest.setScope(scope);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setAuthPassword(clientSecret);
            Invocation.Builder request = AuthClientFactory.getClientBuilder(tokenUrl);
            request.header(AUTHORIZATION, (Object)("Basic " + tokenRequest.getEncodedCredentials()));
            request.header(CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
            MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap(tokenRequest.getParameters());
            response = request.post(Entity.form((MultivaluedMap)multivaluedHashMap));
            log.trace("Response for Access Token -  response:{}", (Object)response);
            if (response.getStatus() == 200) {
                String entity = (String)response.readEntity(String.class);
                TokenResponse tokenResponse = new TokenResponse();
                tokenResponse.setEntity(entity);
                tokenResponse.injectDataFromJson(entity);
                TokenResponse tokenResponse2 = tokenResponse;
                return tokenResponse2;
            }
        }
        return null;
    }

    public static Response revokeToken(String revokeUrl, String clientId, String token, String tokenTypeHint) {
        log.debug("Request for Access Token -  revokeUrl:{}, clientId:{}, token:{} , tokenTypeHint:{}", new Object[]{revokeUrl, clientId, token, tokenTypeHint});
        Invocation.Builder request = AuthClientFactory.getClientBuilder(revokeUrl);
        request.header(AUTHORIZATION, (Object)token);
        request.header(CONTENT_TYPE, (Object)"application/json");
        log.debug(" request:{}}", (Object)request);
        MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap();
        multivaluedHashMap.add((Object)"token", (Object)token);
        multivaluedHashMap.add((Object)"token_type_hint", (Object)tokenTypeHint);
        multivaluedHashMap.add((Object)"client_id", (Object)clientId);
        Response response = request.post(Entity.entity((Object)Entity.form((MultivaluedMap)multivaluedHashMap), (String)"application/json"));
        log.debug(" response:{}", (Object)response);
        return response;
    }

    public static String getIntrospectionEndpoint(String issuer) throws JsonProcessingException {
        log.debug(" Get Introspection Endpoint - issuer:{}", (Object)issuer);
        String configurationEndpoint = issuer + "/.well-known/openid-configuration";
        Invocation.Builder introspectionClient = AuthClientFactory.getClientBuilder(configurationEndpoint);
        introspectionClient.header(CONTENT_TYPE, (Object)"application/json");
        Response introspectionResponse = introspectionClient.get();
        log.trace("AuthClientFactory::getIntrospectionEndpoint() - introspectionResponse:{}", (Object)introspectionResponse);
        if (introspectionResponse.getStatus() == 200) {
            String introspectionEntity = (String)introspectionResponse.readEntity(String.class);
            log.trace("AuthClientFactory::getIntrospectionEndpoint() - introspectionEntity:{}", (Object)introspectionEntity);
            return Jackson.getElement((String)introspectionEntity, (String)"introspection_endpoint");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IntrospectionService createIntrospectionService(String url, boolean followRedirects) {
        try (ApacheHttpClient43Engine engine = null;){
            engine = ClientFactoryUtil.createEngine(followRedirects);
            ResteasyWebTarget resteasyWebTarget = (ResteasyWebTarget)ClientBuilder.newClient().target(url);
            IntrospectionService introspectionService = (IntrospectionService)resteasyWebTarget.proxy(IntrospectionService.class);
            return introspectionService;
        }
    }

    public static String getJwksUri(String issuer) throws JsonProcessingException {
        log.trace(" Jwks Uri - issuer:{}", (Object)issuer);
        String configurationEndpoint = issuer + "/.well-known/openid-configuration";
        Invocation.Builder jwksUriClient = AuthClientFactory.getClientBuilder(configurationEndpoint);
        jwksUriClient.header(CONTENT_TYPE, (Object)"application/json");
        Response jwksUriResponse = jwksUriClient.get();
        log.trace("AuthClientFactory::getJwksUri() - jwksUriResponse:{}", (Object)jwksUriResponse);
        if (jwksUriResponse.getStatus() == 200) {
            String jwksEntity = (String)jwksUriResponse.readEntity(String.class);
            log.trace("AuthClientFactory::getJwksUri() - jwksEntity:{}", (Object)jwksEntity);
            return Jackson.getElement((String)jwksEntity, (String)"jwks_uri");
        }
        return null;
    }

    public static JSONWebKeySet getJSONWebKeys(String jwksUri) {
        log.debug("JSONWebKeys - jwksUri:{}", (Object)jwksUri);
        Invocation.Builder clientBuilder = AuthClientFactory.getClientBuilder(jwksUri);
        clientBuilder.header(CONTENT_TYPE, (Object)"application/json");
        Response webKeyResponse = clientBuilder.get();
        log.trace("AuthClientFactory::getJSONWebKeys() - webKeyResponse:{}", (Object)webKeyResponse);
        if (webKeyResponse.getStatus() == 200) {
            String jsonWebKeySetEntity = (String)webKeyResponse.readEntity(String.class);
            log.trace("AuthClientFactory::getJSONWebKeys() - jsonWebKeySetEntity:{}", (Object)jsonWebKeySetEntity);
            JwkResponse jwkResponse = new JwkResponse(200);
            JSONWebKeySet jwks = null;
            if (StringUtils.isNotBlank((CharSequence)jsonWebKeySetEntity)) {
                JSONObject jsonObj = new JSONObject(jsonWebKeySetEntity);
                if (jsonObj.has("keys")) {
                    jwks = JSONWebKeySet.fromJSONObject((JSONObject)jsonObj);
                    jwkResponse.setJwks(jwks);
                }
                log.trace("AuthClientFactory::getJSONWebKeys() - jwkResponse:{}, jwks:{}", (Object)jwkResponse, (Object)jwks);
                return jwks;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevokeSessionResponse revokeSession(String url, String token, String userId) {
        log.debug("Request for Access Token -  url:{}, token:{}, userId:{} ", new Object[]{url, token, userId});
        try (Response response = null;){
            RevokeSessionRequest revokeSessionRequest = new RevokeSessionRequest("uid", "test");
            Invocation.Builder request = AuthClientFactory.getClientBuilder(url);
            request.header(AUTHORIZATION, (Object)("Basic " + token));
            request.header(CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
            MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap(revokeSessionRequest.getParameters());
            response = request.post(Entity.form((MultivaluedMap)multivaluedHashMap));
            log.trace("Response for Access Token -  response:{}", (Object)response);
            if (response.getStatus() == 200) {
                String entity = (String)response.readEntity(String.class);
                RevokeSessionResponse revokeSessionResponse = new RevokeSessionResponse();
                revokeSessionResponse.setEntity(entity);
                revokeSessionResponse.injectDataFromJson(entity);
                RevokeSessionResponse revokeSessionResponse2 = revokeSessionResponse;
                return revokeSessionResponse2;
            }
        }
        return null;
    }

    private static Invocation.Builder getClientBuilder(String url) {
        return ClientBuilder.newClient().target(url).request();
    }
}

