/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.client;

import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public class ClientFactoryUtil {
    private static ConnectionKeepAliveStrategy connectionKeepAliveStrategy = new ConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
            BasicHeaderElementIterator headerElementIterator = new BasicHeaderElementIterator(httpResponse.headerIterator("Keep-Alive"));
            while (headerElementIterator.hasNext()) {
                HeaderElement headerElement = headerElementIterator.nextElement();
                String name = headerElement.getName();
                String value = headerElement.getValue();
                if (value == null || !name.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return 5000L;
        }
    };

    public static ApacheHttpClient43Engine createEngine(boolean followRedirects) {
        return ClientFactoryUtil.createEngine(200, 20, 10, "standard", followRedirects);
    }

    private static ApacheHttpClient43Engine createEngine(int maxTotal, int defaultMaxPerRoute, int validateAfterInactivity, String cookieSpec, boolean followRedirects) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(defaultMaxPerRoute);
        cm.setValidateAfterInactivity(validateAfterInactivity * 1000);
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec(cookieSpec).build()).setKeepAliveStrategy(connectionKeepAliveStrategy).setConnectionManager((HttpClientConnectionManager)cm).build();
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)httpClient);
        engine.setFollowRedirects(followRedirects);
        return engine;
    }
}

