/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.service;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.core.util.ProtectionScopeType;
import io.jans.configapi.util.AuthUtil;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AuthorizationService
implements Serializable {
    private static final long serialVersionUID = 4012335221233316230L;
    @Inject
    transient Logger log;
    @Inject
    transient ConfigurationFactory configurationFactory;
    @Inject
    transient AuthUtil authUtil;

    public abstract String processAuthorization(String var1, String var2, ResourceInfo var3, String var4, String var5) throws WebApplicationException, Exception;

    protected Response getErrorResponse(Response.Status status, String detail) {
        return Response.status((Response.Status)status).entity((Object)detail).build();
    }

    public Map<ProtectionScopeType, List<String>> getRequestedScopes(ResourceInfo resourceInfo) {
        return this.authUtil.getRequestedScopes(resourceInfo);
    }

    public boolean validateScope(List<String> authScopes, List<String> resourceScopes) {
        return this.authUtil.validateScope(authScopes, resourceScopes);
    }

    public List<String> getAllScopeList(Map<ProtectionScopeType, List<String>> scopeMap) {
        return this.authUtil.getAllScopeList(scopeMap);
    }

    public List<String> getApiApprovedIssuer() {
        return this.configurationFactory.getApiApprovedIssuer();
    }

    public boolean isConfigOauthEnabled() {
        return this.configurationFactory.isConfigOauthEnabled();
    }

    public List<String> getAuthSpecificScopeRequired(ResourceInfo resourceInfo) {
        return this.authUtil.getAuthSpecificScopeRequired(resourceInfo);
    }

    public List<String> findMissingElements(List<String> list1, List<String> list2) {
        return this.authUtil.findMissingElements(list1, list2);
    }

    public boolean isEqualCollection(List<String> list1, List<String> list2) {
        return this.authUtil.isEqualCollection(list1, list2);
    }

    public boolean containsAnyElement(List<String> list1, List<String> list2) {
        return this.authUtil.containsAnyElement(list1, list2);
    }
}

