/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.model.configuration.AssetDirMapping;
import io.jans.configapi.model.configuration.AssetMgtConfiguration;
import io.jans.configapi.util.AuthUtil;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.service.document.store.model.Document;
import io.jans.service.document.store.service.DBDocumentService;
import io.jans.service.document.store.service.DocumentStoreService;
import io.jans.util.exception.InvalidAttributeException;
import io.jans.util.exception.InvalidConfigurationException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AssetService {
    private static final String ASSET_DIR_STR = "AssetDirMapping for [";
    private static final String NOT_DEFINED_IN_CONFIG = " is not defined in config!";
    @Inject
    Logger log;
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    AuthUtil authUtil;
    @Inject
    DocumentStoreService documentStoreService;
    @Inject
    DBDocumentService dbDocumentService;
    @Inject
    private ApiAppConfiguration appConfiguration;

    public String getDnForAsset(String inum) throws Exception {
        return this.dbDocumentService.getDnForDocument(inum);
    }

    public PagedResult<Document> searchAsset(SearchRequest searchRequest, String status) throws Exception {
        this.log.info("Search asset with searchRequest:{}, status:{}", (Object)searchRequest, (Object)status);
        Filter activeFilter = null;
        if ("active".equalsIgnoreCase(status)) {
            activeFilter = Filter.createEqualityFilter((String)"jansEnabled", (Object)true);
        } else if ("inactive".equalsIgnoreCase(status)) {
            activeFilter = Filter.createEqualityFilter((String)"jansEnabled", (Object)false);
        }
        this.log.info("Search asset activeFilter:{}", (Object)activeFilter);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                String[] targetArray = new String[]{assertionValue};
                Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
                Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, inumFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.log.info("Asset pattern searchFilter:{}", searchFilter);
        ArrayList<Filter> fieldValueFilters = new ArrayList<Filter>();
        if (searchRequest.getFieldValueMap() != null && !searchRequest.getFieldValueMap().isEmpty()) {
            for (Map.Entry entry : searchRequest.getFieldValueMap().entrySet()) {
                String[] valueArr = new String[]{(String)entry.getValue()};
                Filter dataFilter = Filter.createSubstringFilter((String)((String)entry.getKey()), null, (String[])valueArr, null);
                this.log.info("asset dataFilter:{}", (Object)dataFilter);
                fieldValueFilters.add(Filter.createANDFilter((Filter[])new Filter[]{dataFilter}));
            }
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        }
        this.log.debug("Asset pattern and field searchFilter:{}", (Object)searchFilter);
        if (activeFilter != null) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, activeFilter});
        }
        this.log.info("Asset final searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForAsset(null), Document.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public Document getAssetByInum(String inum) throws Exception {
        this.log.info("Get asset by inum:{}", (Object)inum);
        Document asset = this.dbDocumentService.getDocumentByInum(inum);
        this.log.info("Asset by inum:{} is asset:{}", (Object)inum, (Object)asset);
        return asset;
    }

    public List<Document> getAssetByName(String name) throws Exception {
        this.log.info("Get asset by name:{}", (Object)name);
        Filter nameFilter = Filter.createEqualityFilter((String)"displayName", (Object)name);
        List documents = this.persistenceEntryManager.findEntries(this.getDnForAsset(null), Document.class, nameFilter);
        this.log.trace("Asset by name:{} are documents:{}", (Object)name, (Object)documents);
        return documents;
    }

    public PagedResult<Document> searchAssetByName(SearchRequest searchRequest) throws Exception {
        this.log.info("Search asset with searchRequest:{}", (Object)searchRequest);
        Filter nameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])new String[]{searchRequest.getFilter()}, null);
        this.log.debug("Asset Search nameFilter:{}", (Object)nameFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForAsset(null), Document.class, nameFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public Document saveAsset(Document asset, InputStream documentStream, boolean isUpdate) throws Exception {
        this.log.info("Save asset - asset:{}, documentStream:{}, isUpdate:{}", new Object[]{asset, documentStream, isUpdate});
        if (asset == null) {
            throw new InvalidAttributeException("Asset object is null!!!");
        }
        if (!isUpdate && documentStream == null) {
            throw new InvalidAttributeException(" Document data stream object is null!!!");
        }
        this.validateModules(asset);
        this.validateAssetMetadata(asset);
        ByteArrayOutputStream bos = null;
        if (documentStream != null) {
            this.validateFileExtension(asset);
            bos = this.getByteArrayOutputStream(documentStream);
            this.log.trace("Asset ByteArrayOutputStream :{}", (Object)bos);
            try (Base64InputStream is = new Base64InputStream(this.getInputStream(bos), true);){
                asset = this.setAssetContent(asset, (InputStream)is);
            }
        }
        if (isUpdate && documentStream == null) {
            Document existingDoc = this.getAssetByInum(asset.getInum());
            if (existingDoc == null) {
                throw new InvalidAttributeException("Asset with inum '" + asset.getInum() + "' does not exist!!!");
            }
            asset.setDocument(existingDoc.getDocument());
        }
        this.updateRevision(asset, isUpdate);
        String inum = asset.getInum();
        this.log.trace("inum of asset to be saved is:{}", (Object)inum);
        if (StringUtils.isBlank((CharSequence)inum)) {
            inum = this.dbDocumentService.generateInumForNewDocument();
            asset.setInum(inum);
            String dn = "inum=" + asset.getInum() + ",ou=document,o=jans";
            asset.setDn(dn);
            this.log.info("As inum is blank create new asset with inum:{}", (Object)inum);
            this.dbDocumentService.addDocument(asset);
        } else {
            this.log.info("Inum is not blank hence update existing asset with inum :{}", (Object)inum);
            this.dbDocumentService.updateDocument(asset);
        }
        asset = this.getAssetByInum(asset.getInum());
        this.log.info("** Asset successfully saved :{}", (Object)asset);
        return asset;
    }

    public String loadServiceAsset(String serviceName) throws Exception {
        this.log.info("Fetch and load asset for serviceName:{}", (Object)serviceName);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new InvalidAttributeException("Service name is null!!!");
        }
        Filter serviceNameFilter = Filter.createEqualityFilter((String)"jansService", (Object)serviceName);
        List assets = this.persistenceEntryManager.findEntries(this.getDnForAsset(null), Document.class, serviceNameFilter);
        this.log.info(" serviceNameFilter:{}, assets:{}", (Object)serviceNameFilter, (Object)assets);
        if (assets == null || assets.isEmpty()) {
            sb.append(" No asset found for service{" + serviceName + "}");
            this.log.info(" No asset found for service:{}", (Object)serviceName);
            return sb.toString();
        }
        for (Document asset : assets) {
            InputStream in = this.readDocumentAsStream(asset.getFileName(), asset.getDocument());
            if (in != null) continue;
            sb.append("Asset file for service{" + serviceName + "} is blank");
        }
        return sb.toString();
    }

    public boolean removeAsset(String inum) throws Exception {
        this.log.info("Remove asset - inum:{}", (Object)inum);
        Document asset = this.getAssetByInum(inum);
        this.log.info("asset{} identified by inum:{}", (Object)asset, (Object)inum);
        if (asset == null) {
            throw new NotFoundException("Cannot find asset identified by - " + inum);
        }
        this.dbDocumentService.removeDocument(asset);
        this.log.info("Deleted asset identified by inum {}", (Object)inum);
        asset = this.getAssetByInum(inum);
        this.log.info("Checking if asset is deleted properly - asset :{}", (Object)asset);
        if (asset != null) {
            this.log.error("Could not remove asset from server identified by inum:{}", (Object)inum);
            throw new WebApplicationException("Could not delete asset identified by inum - " + inum);
        }
        return true;
    }

    public List<String> getValidModuleName() {
        ArrayList<String> serviceModules = null;
        AssetMgtConfiguration assetMgtConfiguration = this.getAssetMgtConfiguration();
        this.log.info("assetMgtConfiguration:{} ", (Object)assetMgtConfiguration);
        if (assetMgtConfiguration == null || assetMgtConfiguration.getAssetDirMapping() == null) {
            return serviceModules;
        }
        List<AssetDirMapping> assetDirMappingList = this.getAssetDirMapping();
        if (assetDirMappingList == null || assetDirMappingList.isEmpty()) {
            return serviceModules;
        }
        HashSet dirSet = new HashSet();
        for (AssetDirMapping mapping : assetDirMappingList) {
            dirSet.addAll(mapping.getJansServiceModule());
        }
        serviceModules = new ArrayList<String>(dirSet);
        this.log.info(" ServiceModuleName  serviceModules:{}- ", serviceModules);
        return serviceModules;
    }

    public List<String> getValidFileExtension() {
        ArrayList<String> validFileExtension = new ArrayList<String>();
        List<AssetDirMapping> assetDirList = this.getAssetDirMapping();
        if (assetDirList == null || assetDirList.isEmpty()) {
            return validFileExtension;
        }
        for (AssetDirMapping dir : assetDirList) {
            validFileExtension.addAll(dir.getType());
        }
        this.log.info("validFileExtension:{}  - ", validFileExtension);
        HashSet<String> dataSet = new HashSet<String>(validFileExtension);
        validFileExtension = new ArrayList<String>(dataSet);
        this.log.info("unique validFileExtension:{}  - ", validFileExtension);
        return validFileExtension;
    }

    public AssetMgtConfiguration getAssetMgtConfiguration() {
        return this.appConfiguration.getAssetMgtConfiguration();
    }

    public List<AssetDirMapping> getAssetDirMapping() {
        List<AssetDirMapping> assetDirMapping = null;
        if (this.getAssetMgtConfiguration() == null) {
            return assetDirMapping;
        }
        return this.getAssetMgtConfiguration().getAssetDirMapping();
    }

    public InputStream readDocumentAsStream(Document asset) {
        this.log.info(" Asset to fetch file - asset:{}", (Object)asset);
        if (asset == null) {
            throw new InvalidAttributeException(" Asset object is null!!!");
        }
        return this.readDocumentAsStream(asset.getFileName(), asset.getDocument());
    }

    private Document setAssetContent(Document asset, InputStream documentStream) throws IOException {
        this.log.info(" Set asset content - asset:{}, documentStream:{}", (Object)asset, (Object)documentStream);
        if (asset == null) {
            throw new InvalidAttributeException(" Asset object is null!!!");
        }
        if (documentStream == null) {
            throw new InvalidAttributeException(" Asset data stream is null!!!");
        }
        String documentContent = new String(documentStream.readAllBytes(), StandardCharsets.UTF_8);
        asset.setDocument(documentContent);
        this.log.info("Successfully updated asset");
        return asset;
    }

    private Document updateRevision(Document asset, boolean isUpdate) {
        this.log.debug("Update asset revision - asset:{}, isUpdate:{}", (Object)asset, (Object)isUpdate);
        try {
            if (asset == null) {
                return asset;
            }
            int intRevision = asset.getRevision() == null ? 0 : asset.getRevision();
            this.log.debug(" Current asset intRevision is:{}", (Object)intRevision);
            if (isUpdate) {
                intRevision += intRevision;
            }
            asset.setRevision(Integer.valueOf(intRevision));
            this.log.info("Updated asset revision to asset.getJansRevision():{}", (Object)asset.getRevision());
        }
        catch (Exception ex) {
            this.log.error("Exception while updating asset revision is - ", (Throwable)ex);
            return asset;
        }
        return asset;
    }

    private Document validateAssetMetadata(Document asset) {
        this.log.info("Validate Asset File type - asset:{}", (Object)asset);
        if (asset == null) {
            throw new InvalidConfigurationException("Asset is null!");
        }
        String assetFileName = asset.getFileName();
        this.log.info("assetFileName:{}", (Object)assetFileName);
        if (StringUtils.isBlank((CharSequence)assetFileName)) {
            throw new InvalidConfigurationException("Asset name is null!");
        }
        String assetDir = this.getAssetDir(asset);
        asset.setFilePath(assetDir);
        this.log.info("For saving assetFileName:{} assetDir:{}, asset.getFileName():{}", new Object[]{assetFileName, assetDir, asset.getFileName()});
        return asset;
    }

    private ByteArrayOutputStream getByteArrayOutputStream(InputStream input) throws IOException {
        return this.authUtil.getByteArrayOutputStream(input);
    }

    private InputStream getInputStream(ByteArrayOutputStream bos) {
        return this.authUtil.getInputStream(bos);
    }

    private String getFileExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    private String getAssetDir(Document asset) {
        this.log.info("Get asset directory asset:{}", (Object)asset);
        if (asset == null) {
            throw new InvalidConfigurationException("Asset details is empty!");
        }
        String assetFileName = asset.getFileName();
        String serviceModule = asset.getService();
        if (StringUtils.isBlank((CharSequence)assetFileName)) {
            throw new InvalidConfigurationException("Asset FileName is null!");
        }
        if (serviceModule == null || serviceModule.isEmpty()) {
            throw new InvalidConfigurationException("Service module for asset to be upload is null!");
        }
        if (this.appConfiguration == null || this.getAssetMgtConfiguration() == null) {
            throw new InvalidConfigurationException("Application setup issue as config is null!");
        }
        String assetDir = this.getAssetDirectory(asset);
        this.log.info("assetDir:{} for assetFileName:{}", (Object)assetDir, (Object)assetFileName);
        if (StringUtils.isBlank((CharSequence)assetDir)) {
            throw new InvalidConfigurationException("Directory to save asset [" + assetFileName + "] is not defined in config!");
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)assetDir)) {
            sb.append(File.separator);
            sb.append(assetDir);
        }
        return sb.toString();
    }

    private String getAssetDirectory(Document asset) {
        this.log.info("Get asset Directory for asset:{}", (Object)asset);
        String serviceDir = null;
        String assetFileName = asset.getFileName();
        String filePath = asset.getFilePath();
        String serviceModule = asset.getService();
        List<AssetDirMapping> assetDirMapping = this.getAssetDirMapping();
        this.log.info("Get asset directory - assetDirMapping:{}", assetDirMapping);
        if (assetDirMapping == null || assetDirMapping.isEmpty()) {
            return serviceDir;
        }
        String fileExtension = this.getFileExtension(assetFileName);
        this.log.info("Get asset directory for fileExtension:{}, serviceModule:{}", (Object)fileExtension, (Object)serviceModule);
        List<AssetDirMapping> assetDirMappingList = assetDirMapping.stream().filter(e -> e.getType().contains(fileExtension)).collect(Collectors.toList());
        this.log.debug(" AssetDirMapping based on fileExtension:{} and serviceModule:{} is assetDirMappingList:{}", new Object[]{fileExtension, serviceModule, assetDirMappingList});
        if (assetDirMappingList == null || assetDirMappingList.isEmpty()) {
            throw new InvalidConfigurationException(ASSET_DIR_STR + fileExtension + "] asset type is not defined in config!");
        }
        String dirMapping = this.getServiceDir(serviceModule, assetDirMappingList);
        this.log.info("Asset dirMapping :{}", (Object)dirMapping);
        if (StringUtils.isBlank((CharSequence)dirMapping)) {
            throw new InvalidConfigurationException(ASSET_DIR_STR + serviceModule + "] for asset type [" + fileExtension + "] is not defined in config!");
        }
        serviceDir = String.format(dirMapping, serviceModule);
        this.log.debug("Derived service directory for - serviceModule:{}, dirMapping:{} is serviceDir:{}", new Object[]{serviceModule, dirMapping, serviceDir});
        if (StringUtils.isNotBlank((CharSequence)filePath) && !filePath.equals(serviceDir)) {
            throw new InvalidConfigurationException("Provided filePath [" + filePath + "] does not match the one defined in config [" + serviceDir + "] !");
        }
        return serviceDir;
    }

    private String getServiceDir(String serviceModule, List<AssetDirMapping> assetDirMappingList) {
        this.log.debug("Get service directory mapping for serviceModule:{}, assetDirMappingList:{}", (Object)serviceModule, assetDirMappingList);
        String serviceDir = null;
        for (AssetDirMapping mapping : assetDirMappingList) {
            this.log.debug("mapping:{}", (Object)mapping);
            if (mapping.getJansServiceModule() == null || !mapping.getJansServiceModule().contains(serviceModule)) continue;
            serviceDir = mapping.getDirectory();
        }
        this.log.info("Service directory mapping for serviceModule:{}, assetDirMappingList:{} is serviceDir:{}", new Object[]{serviceModule, assetDirMappingList, serviceDir});
        return serviceDir;
    }

    private boolean isFileExtensionValidationEnabled() {
        return this.appConfiguration.getAssetMgtConfiguration().isFileExtensionValidationEnabled();
    }

    private boolean isModuleNameValidationEnabled() {
        return this.appConfiguration.getAssetMgtConfiguration().isModuleNameValidationEnabled();
    }

    private void validateFileExtension(Document asset) {
        if (asset == null || this.appConfiguration.getAssetMgtConfiguration() == null || this.appConfiguration.getAssetMgtConfiguration().getAssetDirMapping() == null || this.appConfiguration.getAssetMgtConfiguration().getAssetDirMapping().isEmpty() || !this.isFileExtensionValidationEnabled()) {
            return;
        }
        String fileName = asset.getFileName();
        String fileExtension = this.getFileExtension(fileName);
        List<String> validFileExtensions = this.getValidFileExtension();
        this.log.debug("Checking valid file extention - fileName:{}, fileExtension:{}, validFileExtensions:{}", new Object[]{fileName, fileExtension, validFileExtensions});
        if (StringUtils.isBlank((CharSequence)fileName) || StringUtils.isBlank((CharSequence)fileExtension)) {
            throw new InvalidConfigurationException("Valid file name not provided!");
        }
        if (validFileExtensions.isEmpty()) {
            return;
        }
        boolean isValidExtension = validFileExtensions.contains(fileExtension);
        if (!isValidExtension) {
            throw new InvalidConfigurationException("Valid file type are '{" + validFileExtensions + "}', '{" + fileExtension + "}' name not supported!");
        }
    }

    private void validateModules(Document asset) {
        if (asset == null || asset.getService() == null || asset.getService().isEmpty()) {
            throw new InvalidConfigurationException("Service module to save asset is not provided in request!");
        }
        List<String> validModules = this.getValidModuleName();
        this.log.debug("validModules:{} ", validModules);
        if (validModules == null || validModules.isEmpty() || !this.isModuleNameValidationEnabled()) {
            throw new InvalidConfigurationException("Service module not configured in system! ");
        }
        boolean containsModule = validModules.contains(asset.getService());
        this.log.debug("containsModule:{}", (Object)containsModule);
        if (!containsModule) {
            throw new InvalidConfigurationException("Valid modules are '{" + validModules + "}', '{" + asset.getService() + "}' not defined!");
        }
    }

    private InputStream readDocumentAsStream(String name, String assetContent) {
        this.log.debug("Asset name:{} assetContent: '{}'", (Object)name, (Object)assetContent);
        if (StringUtils.isBlank((CharSequence)assetContent)) {
            this.log.error("Asset file name '{}' is empty", (Object)name);
            return null;
        }
        return new ByteArrayInputStream(assetContent.getBytes());
    }
}

