/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.OrganizationService;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.ClientAuthorization;
import io.jans.as.persistence.model.Scope;
import io.jans.configapi.core.model.Token;
import io.jans.configapi.service.auth.ClientService;
import io.jans.configapi.service.auth.ScopeService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ClientAuthService {
    @Inject
    private Logger logger;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    StaticConfiguration staticConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    ScopeService scopeService;
    @Inject
    private OrganizationService organizationService;

    public Map<Client, Set<Scope>> getUserAuthorizations(String userId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Authorizations details to be fetched for userId:{}", (Object)Util.escapeLog((Object)userId));
        }
        ClientAuthorization clientAuth = new ClientAuthorization();
        clientAuth.setDn(this.getClientAuthorizationDn(null));
        clientAuth.setUserId(userId);
        List authorizations = this.persistenceEntryManager.findEntries((Object)clientAuth);
        this.logger.debug("{} client-authorization entries found", (Object)authorizations);
        if (authorizations == null || authorizations.isEmpty()) {
            return Collections.emptyMap();
        }
        Set clientIds = authorizations.stream().map(ClientAuthorization::getClientId).collect(Collectors.toSet());
        this.logger.debug("clientIds:{}", clientIds);
        Filter[] filters = clientIds.stream().map(id -> Filter.createEqualityFilter((String)"inum", (Object)id)).collect(Collectors.toList()).toArray(new Filter[0]);
        List clients = this.persistenceEntryManager.findEntries(this.clientService.getDnForClient(null), Client.class, Filter.createORFilter((Filter[])filters));
        Set scopeIds = authorizations.stream().map(ClientAuthorization::getScopes).flatMap(Arrays::stream).collect(Collectors.toSet());
        this.logger.debug("scopeIds:{}", scopeIds);
        filters = scopeIds.stream().map(id -> Filter.createEqualityFilter((String)"jansId", (Object)id)).collect(Collectors.toList()).toArray(new Filter[0]);
        List scopes = this.persistenceEntryManager.findEntries(this.scopeService.getDnForScope(null), Scope.class, Filter.createORFilter((Filter[])filters));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Found {} client authorizations for user:{}", (Object)clients.size(), (Object)Util.escapeLog((Object)userId));
        }
        HashMap<Client, Set<Scope>> perms = new HashMap<Client, Set<Scope>>();
        for (Client client : clients) {
            HashSet clientScopes = new HashSet();
            this.logger.debug("client:{}", (Object)client);
            for (ClientAuthorization auth : authorizations) {
                this.logger.trace("auth:{}", (Object)auth);
                if (!auth.getClientId().equals(client.getClientId())) continue;
                for (String scopeName : auth.getScopes()) {
                    scopes.stream().filter(sc -> sc.getId().equals(scopeName)).findAny().ifPresent(clientScopes::add);
                }
            }
            perms.put(client, clientScopes);
        }
        this.logger.info("perms {}", perms);
        return perms;
    }

    public void removeClientAuthorizations(String userId, String clientId, String userName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Removing client authorizations for userId:{}, clientId:{}, userName:{}", new Object[]{Util.escapeLog((Object)userId), Util.escapeLog((Object)clientId), Util.escapeLog((Object)userName)});
        }
        ClientAuthorization clientAuth = new ClientAuthorization();
        clientAuth.setDn(this.getClientAuthorizationDn(null));
        clientAuth.setUserId(userId);
        clientAuth.setClientId(clientId);
        this.logger.debug("clientAuth:{} ", (Object)clientAuth);
        List authorizations = this.persistenceEntryManager.findEntries((Object)clientAuth);
        this.logger.debug("{} client-authorization entries found", (Object)authorizations);
        if (authorizations == null || authorizations.isEmpty()) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Removing client authorizations for userName:{}", (Object)Util.escapeLog((Object)userName));
        }
        authorizations.forEach(authorization -> {
            this.logger.debug("Deleting ClientAuthorization for id:{}, clientId:{}", (Object)authorization.getId(), (Object)authorization.getClientId());
            this.persistenceEntryManager.remove(authorization);
        });
        Token sampleToken = new Token();
        sampleToken.setBaseDn(this.geTokenDn(null));
        sampleToken.setClientId(clientId);
        sampleToken.setTokenType("refresh_token");
        sampleToken.setUserId(userName);
        this.logger.info("Removing refresh tokens associated to this user/client pair");
        List tokens = this.persistenceEntryManager.findEntries((Object)sampleToken);
        this.logger.debug("Client tokens:{}", (Object)tokens);
        tokens.forEach(token -> {
            this.logger.trace("Deleting token {}", (Object)token.getTokenCode());
            this.persistenceEntryManager.remove(token);
        });
    }

    public String getClientAuthorizationDn(String id) {
        String baseDn = this.staticConfiguration.getBaseDn().getAuthorizations();
        if (id == null || StringUtils.isEmpty((CharSequence)id)) {
            return baseDn;
        }
        return String.format("jansId=%s,%s", id, baseDn);
    }

    public String geTokenDn(String id) {
        this.logger.debug("Get Token Dn for id:{}", (Object)id);
        String baseDn = this.staticConfiguration.getBaseDn().getTokens();
        if (id == null || StringUtils.isEmpty((CharSequence)id)) {
            return baseDn;
        }
        return String.format("tknCde=%s,%s", id, baseDn);
    }

    public String getDnForClient(String inum) {
        this.logger.debug("Get Client Dn for inum:{}", (Object)inum);
        String orgDn = this.organizationService.getDnForOrganization();
        if (inum == null || StringHelper.isEmpty((String)inum)) {
            return String.format("ou=clients,%s", orgDn);
        }
        return String.format("inum=%s,ou=clients,%s", inum, orgDn);
    }

    public List<Scope> getScopeList(List<ClientAuthorization> clientAuthorizations) {
        this.logger.info("Client authorizations for clientAuthorizations {}", clientAuthorizations);
        HashSet<String> scopeIds = new HashSet<String>();
        for (ClientAuthorization auth : clientAuthorizations) {
            this.logger.debug("Client authorizations for auth.getClientId():{}, auth.getScopes():{}", (Object)auth.getClientId(), (Object)auth.getScopes());
            if (auth.getScopes() == null || auth.getScopes().length <= 0) continue;
            Arrays.asList(auth.getScopes()).stream().filter(scopeIds::add);
        }
        this.logger.info("scopeIds:{}", scopeIds);
        return this.scopeService.searchScopesById(scopeIds);
    }
}

