/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.util;

import com.unboundid.ldap.sdk.DN;
import io.jans.as.client.RevokeSessionResponse;
import io.jans.as.client.TokenResponse;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.uma.wrapper.Token;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.service.ConfService;
import io.jans.configapi.core.util.ProtectionScopeType;
import io.jans.configapi.model.configuration.AgamaConfiguration;
import io.jans.configapi.model.configuration.AuditLogConf;
import io.jans.configapi.model.configuration.DataFormatConversionConf;
import io.jans.configapi.model.configuration.PluginConf;
import io.jans.configapi.security.api.ApiProtectionCache;
import io.jans.configapi.security.client.AuthClientFactory;
import io.jans.configapi.service.auth.ClientService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.service.auth.ScopeService;
import io.jans.service.EncryptionService;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ResourceInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AuthUtil {
    @Inject
    Logger log;
    @Inject
    ConfigurationFactory configurationFactory;
    @Inject
    ConfigurationService configurationService;
    @Inject
    ClientService clientService;
    @Inject
    ScopeService scopeService;
    @Inject
    EncryptionService encryptionService;
    @Inject
    ConfService confService;

    public String getOpenIdConfigurationEndpoint() {
        return this.configurationService.find().getOpenIdConfigurationEndpoint();
    }

    public String getAuthOpenidConfigurationUrl() {
        return this.configurationFactory.getApiAppConfiguration().getAuthOpenidConfigurationUrl();
    }

    public AuditLogConf getAuditLogConf() {
        return this.configurationFactory.getApiAppConfiguration().getAuditLogConf();
    }

    public DataFormatConversionConf getDataFormatConversionConf() {
        return this.configurationFactory.getApiAppConfiguration().getDataFormatConversionConf();
    }

    public List<PluginConf> getPluginConf() {
        return this.configurationFactory.getApiAppConfiguration().getPlugins();
    }

    public String getIssuer() {
        return this.configurationService.find().getIssuer();
    }

    public String getIntrospectionEndpoint() {
        return this.configurationService.find().getIntrospectionEndpoint();
    }

    public String getTokenEndpoint() {
        return this.configurationService.find().getTokenEndpoint();
    }

    public String getEndSessionEndpoint() {
        return this.configurationService.find().getEndSessionEndpoint();
    }

    public String getServiceUrl(String url) {
        return this.getIssuer() + url;
    }

    public String getClientId() {
        return this.configurationFactory.getApiClientId();
    }

    public List<String> getUserExclusionAttributes() {
        return this.configurationFactory.getApiAppConfiguration().getUserExclusionAttributes();
    }

    public String getUserExclusionAttributesAsString() {
        List<String> excludedAttributes = this.getUserExclusionAttributes();
        return excludedAttributes == null ? null : excludedAttributes.stream().collect(Collectors.joining(","));
    }

    public List<String> getUserMandatoryAttributes() {
        return this.configurationFactory.getApiAppConfiguration().getUserMandatoryAttributes();
    }

    public AgamaConfiguration getAgamaConfiguration() {
        return this.configurationFactory.getApiAppConfiguration().getAgamaConfiguration();
    }

    public String getTokenUrl() {
        return this.configurationService.find().getTokenEndpoint();
    }

    public String getTokenRevocationEndpoint() {
        return this.configurationService.find().getTokenRevocationEndpoint();
    }

    public Client getClient(String clientId) {
        return this.clientService.getClientByInum(clientId);
    }

    public String getClientPassword(String clientId) {
        return this.getClient(clientId).getClientSecret();
    }

    public String getClientDecryptPassword(String clientId) {
        return this.decryptPassword(this.getClientPassword(clientId));
    }

    public String decryptPassword(String clientPassword) {
        String decryptedPassword = null;
        if (clientPassword != null) {
            try {
                decryptedPassword = this.encryptionService.decrypt(clientPassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt password", (Throwable)ex);
            }
        }
        return decryptedPassword;
    }

    public String encryptPassword(String clientPassword) {
        String encryptedPassword = null;
        if (clientPassword != null) {
            try {
                encryptedPassword = this.encryptionService.encrypt(clientPassword);
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt password", (Throwable)ex);
            }
        }
        return encryptedPassword;
    }

    public Map<ProtectionScopeType, List<String>> getRequestedScopes(ResourceInfo resourceInfo) {
        this.log.info("Requested scopes for resourceInfo:{} ", (Object)resourceInfo);
        Class resourceClass = resourceInfo.getResourceClass();
        ProtectedApi typeAnnotation = resourceClass.getAnnotation(ProtectedApi.class);
        HashMap<ProtectionScopeType, List<String>> scopes = new HashMap<ProtectionScopeType, List<String>>();
        this.log.debug("Requested scopes for resourceClass:{}, typeAnnotation:{} ", (Object)resourceClass, (Object)typeAnnotation);
        if (typeAnnotation == null) {
            this.log.debug("Requested scopes for resourceClass:{}, typeAnnotation == null ", (Object)resourceClass);
            this.addMethodScopes(resourceInfo, scopes);
        } else {
            this.log.debug("Requested scopes for resourceClass:{}, typeAnnotation is not null ", (Object)resourceClass);
            scopes.put(ProtectionScopeType.SCOPE, Stream.of(typeAnnotation.scopes()).collect(Collectors.toList()));
            scopes.put(ProtectionScopeType.GROUP, Stream.of(typeAnnotation.groupScopes()).collect(Collectors.toList()));
            scopes.put(ProtectionScopeType.SUPER, Stream.of(typeAnnotation.superScopes()).collect(Collectors.toList()));
            this.log.trace("ProtectionScopeType.SCOPE:{}, ProtectionScopeType.GROUP:{} ,  ProtectionScopeType.SUPER:{} ", new Object[]{Stream.of(typeAnnotation.scopes()).collect(Collectors.toList()), Stream.of(typeAnnotation.groupScopes()).collect(Collectors.toList()), Stream.of(typeAnnotation.superScopes()).collect(Collectors.toList())});
            this.log.debug("All scopes:{} ", scopes);
            this.addMethodScopes(resourceInfo, scopes);
        }
        this.log.info("*** Final Requested scopes:{} for resourceInfo:{} ", scopes, (Object)resourceInfo);
        return scopes;
    }

    public boolean validateScope(List<String> authScopes, List<String> resourceScopes) {
        this.log.info("Validate Scopes for authScopes:{}, resourceScopes:{} ", authScopes, resourceScopes);
        HashSet<String> authScopeSet = new HashSet<String>(authScopes);
        HashSet<String> resourceScopeSet = new HashSet<String>(resourceScopes);
        return authScopeSet.containsAll(resourceScopeSet);
    }

    private void addMethodScopes(ResourceInfo resourceInfo, Map<ProtectionScopeType, List<String>> scopes) {
        this.log.info("Method Scopes for resourceInfo:{}, scopes:{} ", (Object)resourceInfo, scopes);
        Method resourceMethod = resourceInfo.getResourceMethod();
        ProtectedApi methodAnnotation = resourceMethod.getAnnotation(ProtectedApi.class);
        if (methodAnnotation != null) {
            scopes.put(ProtectionScopeType.SCOPE, Stream.of(methodAnnotation.scopes()).collect(Collectors.toList()));
            scopes.put(ProtectionScopeType.GROUP, Stream.of(methodAnnotation.groupScopes()).collect(Collectors.toList()));
            scopes.put(ProtectionScopeType.SUPER, Stream.of(methodAnnotation.superScopes()).collect(Collectors.toList()));
        }
        this.log.info("Final Method Scopes for resourceInfo:{}, scopes:{} ", (Object)resourceInfo, scopes);
    }

    public String requestAccessToken(String clientId, List<String> scope) {
        this.log.info("Request for AccessToken - clientId:{}, scope:{} ", (Object)clientId, scope);
        String tokenUrl = this.getTokenEndpoint();
        Token token = this.getAccessToken(tokenUrl, clientId, scope);
        this.log.debug("oAuth AccessToken response - token:{}", (Object)token);
        if (token != null) {
            return token.getAccessToken();
        }
        return null;
    }

    public Token getAccessToken(String tokenUrl, String clientId, List<String> scopes) {
        this.log.info("Access Token Request - tokenUrl:{}, clientId:{}, scopes:{}", new Object[]{tokenUrl, clientId, scopes});
        String clientSecret = this.getClientDecryptPassword(clientId);
        HashSet<String> scopesSet = new HashSet<String>(scopes);
        StringBuilder scope = new StringBuilder(ScopeType.OPENID.getValue());
        for (String s : scopesSet) {
            scope.append(" ").append(s);
        }
        this.log.debug("Scope required  - {}", (Object)scope);
        TokenResponse tokenResponse = AuthClientFactory.requestAccessToken(tokenUrl, clientId, clientSecret, scope.toString());
        if (tokenResponse != null) {
            this.log.debug("Token Response - tokenScope: {}, tokenAccessToken: {} ", (Object)tokenResponse.getScope(), (Object)tokenResponse.getAccessToken());
            String accessToken = tokenResponse.getAccessToken();
            Integer expiresIn = tokenResponse.getExpiresIn();
            if (Util.allNotBlank((String[])new String[]{accessToken})) {
                return new Token(null, null, accessToken, ScopeType.OPENID.getValue(), expiresIn);
            }
        }
        return null;
    }

    public void assignAllScope(String clientId) {
        this.log.info("Client to be assigned all scope - {} ", (Object)clientId);
        Client client = this.clientService.getClientByInum(clientId);
        if (client == null) {
            return;
        }
        List<String> scopes = this.getScopeWithDn(this.getAllScopes());
        String[] scopeArray = this.getAllScopesArray(scopes);
        this.log.debug(" scope to be assigned - {} ", Arrays.asList(scopeArray));
        client.setScopes(scopeArray);
        this.clientService.updateClient(client);
        client = this.clientService.getClientByInum(clientId);
        this.log.debug(" Verify scopes post assignment, clientId: {} , scopes: {}", (Object)clientId, Arrays.asList(client.getScopes()));
    }

    public List<String> getAllScopes() {
        ArrayList<String> scopes = new ArrayList<String>();
        Map<String, Scope> scopeMap = ApiProtectionCache.getAllTypesOfScopes();
        Set<String> keys = scopeMap.keySet();
        for (String id : keys) {
            Scope scope = ApiProtectionCache.getScope(id);
            scopes.add(scope.getInum());
        }
        return scopes;
    }

    public String[] getAllScopesArray(List<String> scopes) {
        String[] scopeArray = null;
        if (scopes != null && !scopes.isEmpty()) {
            scopeArray = new String[scopes.size()];
            for (int i = 0; i < scopes.size(); ++i) {
                scopeArray[i] = scopes.get(i);
            }
        }
        return scopeArray;
    }

    public List<String> getScopeWithDn(List<String> scopes) {
        ArrayList<String> scopeList = null;
        if (scopes != null && !scopes.isEmpty()) {
            scopeList = new ArrayList<String>();
            for (String id : scopes) {
                scopeList.add(this.scopeService.getDnForScope(id));
            }
        }
        return scopeList;
    }

    public boolean isValidIssuer(String issuer) {
        this.log.info("Is issuer:{} present in approvedIssuer list ? {} ", (Object)issuer, (Object)this.configurationFactory.getApiApprovedIssuer().contains(issuer));
        return this.configurationFactory.getApiApprovedIssuer().contains(issuer);
    }

    public List<String> getAuthSpecificScopeRequired(ResourceInfo resourceInfo) {
        this.log.info("Fetch Auth server specific scope for resourceInfo:{} ", (Object)resourceInfo);
        List<String> resourceScopes = this.getAllScopeList(this.getRequestedScopes(resourceInfo));
        this.log.debug(" resource:{} has these scopes:{} and configured exclusiveAuthScopes are {}", new Object[]{resourceInfo, resourceScopes, this.configurationFactory.getApiAppConfiguration().getExclusiveAuthScopes()});
        List<String> exclusiveAuthScopesToReq = new ArrayList<String>();
        if (resourceScopes != null && !resourceScopes.isEmpty() && this.configurationFactory.getApiAppConfiguration().getExclusiveAuthScopes() != null && !this.configurationFactory.getApiAppConfiguration().getExclusiveAuthScopes().isEmpty()) {
            exclusiveAuthScopesToReq = resourceScopes.stream().filter(ele -> this.configurationFactory.getApiAppConfiguration().getExclusiveAuthScopes().contains(ele)).collect(Collectors.toList());
        }
        this.log.info("Applicable exclusiveAuthScopes for resourceInfo:{} are {} ", (Object)resourceInfo, exclusiveAuthScopesToReq);
        return exclusiveAuthScopesToReq;
    }

    public List<String> findMissingElements(List<String> list1, List<String> list2) {
        if (list1 == null || list1.isEmpty()) {
            return Collections.emptyList();
        }
        if (list2 == null || list2.isEmpty()) {
            return list1;
        }
        return list1.stream().filter(e -> !list2.contains(e)).collect(Collectors.toList());
    }

    public boolean containsAnyElement(List<String> list1, List<String> list2) {
        if (list1 == null || list1.isEmpty() || list2 == null || list2.isEmpty()) {
            return false;
        }
        return list1.stream().anyMatch(list2::contains);
    }

    public boolean isEqualCollection(List<String> list1, List<String> list2) {
        if (list1 == null || list1.isEmpty() || list2 == null || list2.isEmpty()) {
            return false;
        }
        return CollectionUtils.isEqualCollection(list1, list2);
    }

    public boolean containsField(List<Field> allFields, String attribute) {
        this.log.debug("allFields:{},  attribute:{}, allFields.contains(attribute):{} ", new Object[]{allFields, attribute, allFields.stream().anyMatch(f -> f.getName().equals(attribute))});
        return allFields.stream().anyMatch(f -> f.getName().equals(attribute));
    }

    public List<Field> getAllFields(Class<?> type) {
        List<Field> allFields = new ArrayList<Field>();
        allFields = this.getAllFields(allFields, type);
        this.log.debug("Fields:{} of type:{}  ", allFields, type);
        return allFields;
    }

    public List<Field> getAllFields(List<Field> fields, Class<?> type) {
        this.log.debug("fields:{} of type:{} ", fields, type);
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            this.getAllFields(fields, type.getSuperclass());
        }
        this.log.debug("Final fields:{} of type:{} ", fields, type);
        return fields;
    }

    public boolean isValidDn(String dn) {
        return this.isValidDn(dn, false);
    }

    public boolean isValidDn(String dn, boolean strictNameChecking) {
        return DN.isValidDN((String)dn, (boolean)strictNameChecking);
    }

    public RevokeSessionResponse revokeSession(String url, String token, String userId) {
        this.log.debug("Revoke session Request - url:{}, token:{}, userId:{}", new Object[]{url, token, userId});
        RevokeSessionResponse revokeSessionResponse = AuthClientFactory.revokeSession(url, token, userId);
        this.log.debug("revokeSessionResponse:{}", (Object)revokeSessionResponse);
        if (revokeSessionResponse != null) {
            this.log.debug("revokeSessionResponse.getEntity():{}, revokeSessionResponse.getStatus():{} ", (Object)revokeSessionResponse.getEntity(), (Object)revokeSessionResponse.getStatus());
        }
        return revokeSessionResponse;
    }

    public List<String> getAllScopeList(Map<ProtectionScopeType, List<String>> scopeMap) {
        List<String> scopeList = new ArrayList<String>();
        this.log.debug("Get all scopeMap:{} ", scopeMap);
        if (scopeMap == null || scopeMap.isEmpty()) {
            return scopeList;
        }
        scopeList = scopeMap.get(ProtectionScopeType.SCOPE);
        this.log.debug("Get all scopeList:{} ", scopeList);
        return scopeList;
    }

    public Date parseStringToDateObj(String dateString) {
        String datePattern = "yyyy-MM-dd";
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        this.log.debug("parseStringToDateObj:{} ", (Object)dateString);
        Date date = null;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            this.log.error("Error in parsing string to date. Allowed Date Format : {},  Date-String : {} ", (Object)datePattern, (Object)dateString);
        }
        return date;
    }

    public ByteArrayOutputStream getByteArrayOutputStream(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (input == null) {
            return baos;
        }
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos;
    }

    public InputStream getInputStream(ByteArrayOutputStream output) {
        InputStream input = null;
        if (output == null) {
            return input;
        }
        return new ByteArrayInputStream(output.toByteArray());
    }
}

