/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.util;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import io.jans.as.model.crypto.PublicKey;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.ECDSAPublicKey;
import io.jans.as.model.crypto.signature.RSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jws.ECDSASigner;
import io.jans.as.model.jws.RSASigner;
import io.jans.as.model.jwt.Jwt;
import io.jans.configapi.security.client.AuthClientFactory;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.util.AuthUtil;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class JwtUtil {
    @Inject
    Logger log;
    @Inject
    ConfigurationService configurationService;
    @Inject
    AuthUtil authUtil;

    public boolean isJwt(String token) throws Exception {
        this.log.trace("\n\n JwtUtil::isJwt()  token = " + token);
        boolean isJwt = false;
        try {
            this.parse(token);
            isJwt = true;
        }
        catch (Exception ex) {
            this.log.error("Not jwt token " + token);
        }
        return isJwt;
    }

    public Jwt parse(String encodedJwt) throws InvalidJwtException {
        this.log.trace("\n\n JwtUtil::parse()  encodedJwt = " + encodedJwt);
        if (StringHelper.isNotEmpty((String)encodedJwt)) {
            return Jwt.parse((String)encodedJwt);
        }
        return null;
    }

    public List<String> validateToken(String token) throws InvalidJwtException, Exception {
        try {
            Jwt jwt = this.parse(token);
            this.log.trace("JwtUtil::validateToken() -JWT details :  jwt.getSigningInput() = " + jwt.getSigningInput() + " ,jwt.getEncodedSignature() = " + jwt.getEncodedSignature() + " ,jwt.getHeader().getKeyId() = " + jwt.getHeader().getKeyId() + " ,jwt.getHeader().getSignatureAlgorithm() = " + jwt.getHeader().getSignatureAlgorithm() + " ,jwt.getClaims().getClaimAsString(JwtHeaderName.ALGORITHM) = " + jwt.getClaims().getClaimAsString("alg") + " ,jwt.getClaims().getClaimAsString(JwtHeaderName.ENCRYPTION_METHOD) = " + jwt.getClaims().getClaimAsString("enc") + ".");
            Date expiresAt = jwt.getClaims().getClaimAsDate("exp");
            String issuer = jwt.getClaims().getClaimAsString("iss");
            List scopes = jwt.getClaims().getClaimAsStringList("scope");
            this.log.debug("\n\n JwtUtil::validateToken() - expiresAt = " + expiresAt + " , issuer =" + issuer + " , scopes = " + scopes + "\n");
            this.log.info("Validate JWT");
            Date now = new Date();
            if (now.after(expiresAt)) {
                this.log.error("ID Token is expired. (It is after " + now + ").");
                throw new WebApplicationException("ID Token is expired", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            this.log.info("Validate JWT Issuer");
            if (!this.authUtil.isValidIssuer(issuer)) {
                throw new WebApplicationException("Jwt Issuer is Invalid.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            this.log.info("Retrieve JSON Web Key Set URI");
            String jwksUri = this.getJwksUri(issuer);
            this.log.trace("\n\n JwtUtil::validateToken() - jwksUri = " + jwksUri);
            this.log.info("Retrieve JSON Web Key Set");
            JSONWebKeySet jsonWebKeySet = this.getJSONWebKeys(jwksUri);
            this.log.trace("\n\n JwtUtil::validateToken() - jsonWebKeySet = " + jsonWebKeySet);
            this.log.info("Verify JWT signature");
            boolean isJwtSignatureValid = this.validateSignature(jwt, jsonWebKeySet);
            this.log.debug("\n\n JwtUtil::validateToken() - isJwtSignatureValid = " + isJwtSignatureValid + "\n\n");
            if (!isJwtSignatureValid) {
                throw new WebApplicationException("Jwt Signature is Invalid.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            return scopes;
        }
        catch (InvalidJwtException exp) {
            this.log.error("Not a valid Jwt token = " + exp);
            throw exp;
        }
    }

    public void validateToken(String token, List<String> resourceScopes) throws InvalidJwtException, Exception {
        this.log.trace("Validate Jwt Token - token = " + token + " ,resourceScopes = " + resourceScopes + "\n");
        try {
            Jwt jwt = this.parse(token);
            this.log.trace("JwtUtil::validateToken() -JWT details :  jwt.getSigningInput() = " + jwt.getSigningInput() + " ,jwt.getEncodedSignature() = " + jwt.getEncodedSignature() + " ,jwt.getHeader().getKeyId() = " + jwt.getHeader().getKeyId() + " ,jwt.getHeader().getSignatureAlgorithm() = " + jwt.getHeader().getSignatureAlgorithm() + " ,jwt.getClaims().getClaimAsString(JwtHeaderName.ALGORITHM) = " + jwt.getClaims().getClaimAsString("alg") + " ,jwt.getClaims().getClaimAsString(JwtHeaderName.ENCRYPTION_METHOD) = " + jwt.getClaims().getClaimAsString("enc") + ".");
            Date expiresAt = jwt.getClaims().getClaimAsDate("exp");
            String issuer = jwt.getClaims().getClaimAsString("iss");
            List scopes = jwt.getClaims().getClaimAsStringList("scope");
            this.log.debug("\n\n JwtUtil::validateToken() - expiresAt = " + expiresAt + " , issuer =" + issuer + " , scopes = " + scopes + "\n");
            this.log.info("Validate JWT");
            Date now = new Date();
            if (now.after(expiresAt)) {
                this.log.error("ID Token is expired. (It is after " + now + ").");
                throw new WebApplicationException("ID Token is expired", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            this.log.info("Validate JWT Issuer");
            if (!this.authUtil.isValidIssuer(issuer)) {
                throw new WebApplicationException("Jwt Issuer is Invalid.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            this.log.info("Retrieve JSON Web Key Set URI");
            String jwksUri = this.getJwksUri(issuer);
            this.log.trace("\n\n JwtUtil::validateToken() - jwksUri = " + jwksUri);
            this.log.info("Retrieve JSON Web Key Set");
            JSONWebKeySet jsonWebKeySet = this.getJSONWebKeys(jwksUri);
            this.log.trace("\n\n JwtUtil::validateToken() - jsonWebKeySet = " + jsonWebKeySet);
            this.log.info("Verify JWT signature");
            boolean isJwtSignatureValid = this.validateSignature(jwt, jsonWebKeySet);
            this.log.debug("\n\n JwtUtil::validateToken() - isJwtSignatureValid = " + isJwtSignatureValid + "\n\n");
            if (!isJwtSignatureValid) {
                throw new WebApplicationException("Jwt Signature is Invalid.", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
            this.log.info("Validate token scopes");
            if (!this.authUtil.validateScope(scopes, resourceScopes)) {
                this.log.error("Insufficient scopes. Required scope: " + resourceScopes + ", token scopes: " + scopes);
                throw new WebApplicationException("Insufficient scopes. Required scope", Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
        catch (InvalidJwtException exp) {
            this.log.error("Not a valid Jwt token = " + exp);
            throw exp;
        }
    }

    public boolean validateSignature(Jwt jwt, JSONWebKeySet jsonWebKeySet) {
        this.log.trace("\n\n JwtUtil::validateSignature() - jwt = " + jwt + " , jsonWebKeySet =" + jsonWebKeySet + "\n");
        try {
            String kid = jwt.getHeader().getClaimAsString("kid");
            String algorithm = jwt.getHeader().getClaimAsString("alg");
            SignatureAlgorithm signatureAlgorithm = jwt.getHeader().getSignatureAlgorithm();
            this.log.trace("\n\n JwtUtil::validateSignature() - kid = " + kid + " , algorithm =" + algorithm + " signatureAlgorithm = " + signatureAlgorithm + "\n");
            PublicKey publicKey = this.getPublicKey(kid, jsonWebKeySet, signatureAlgorithm);
            this.log.trace("\n\n JwtUtil::validateSignature() - publicKey = " + publicKey + "\n");
            if (publicKey == null) {
                this.log.error("Failed to get RSA public key.");
                return false;
            }
            RSASigner signer = null;
            if (AlgorithmFamily.RSA.equals((Object)signatureAlgorithm.getFamily())) {
                signer = new RSASigner(SignatureAlgorithm.fromString((String)algorithm), (RSAPublicKey)publicKey);
            } else if (AlgorithmFamily.EC.equals((Object)signatureAlgorithm.getFamily())) {
                signer = new ECDSASigner(SignatureAlgorithm.fromString((String)algorithm), (ECDSAPublicKey)publicKey);
            }
            if (signer == null) {
                this.log.error("ID Token signer is not found!");
                return false;
            }
            boolean signature = signer.validate(jwt);
            if (signature) {
                this.log.debug("ID Token is successfully validated.");
                return true;
            }
            this.log.error("ID Token signature invalid.");
            return false;
        }
        catch (Exception e) {
            this.log.error("Failed to validate id_token. Message: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public PublicKey getPublicKey(String kid, JSONWebKeySet jsonWebKeySet, SignatureAlgorithm signatureAlgorithm) {
        this.log.trace("\n\n JwtUtil::getPublicKey() - kid = " + kid + " , jsonWebKeySet =" + jsonWebKeySet + " , signatureAlgorithm =  " + signatureAlgorithm + "\n");
        JSONWebKey key = jsonWebKeySet.getKey(kid);
        if (key != null) {
            switch (key.getKty()) {
                case RSA: {
                    return new RSAPublicKey(key.getN(), key.getE());
                }
                case EC: {
                    return new ECDSAPublicKey(SignatureAlgorithm.fromString((String)key.getAlg().getParamName()), key.getX(), key.getY());
                }
            }
            return null;
        }
        return null;
    }

    public JSONObject fromJson(String json) throws IOException {
        this.log.trace("\n\n JwtUtil::fromJson() - json = " + json + " \n");
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return (JSONObject)mapper.readValue(json, JSONObject.class);
    }

    public String getJwksUri(String issuer) throws Exception {
        this.log.debug("JwtUtil::getJSONWebKeys() - issuer = " + issuer);
        if (StringHelper.isNotEmpty((String)issuer) && issuer.equals(this.configurationService.find().getIssuer())) {
            return this.configurationService.find().getJwksUri();
        }
        return AuthClientFactory.getJwksUri(issuer);
    }

    public JSONWebKeySet getJSONWebKeys(String jwksUri) throws Exception {
        this.log.debug("\n\n JwtUtil::getJSONWebKeys() - jwksUri = " + jwksUri + " \n");
        JSONWebKeySet jsonWebKeySet = AuthClientFactory.getJSONWebKeys(jwksUri);
        this.log.trace("\n\n JwtUtil::getJSONWebKeys() - jsonWebKeySet = " + jsonWebKeySet + " \n");
        return jsonWebKeySet;
    }
}

