/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.ads.model.Deployment;
import io.jans.agama.model.Flow;
import io.jans.as.model.util.Pair;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AgamaDeploymentsService;
import io.jans.configapi.service.auth.AgamaFlowService;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Path(value="/agama-deployment")
@Produces(value={"application/json"})
public class AgamaDeploymentsResource
extends ConfigBaseResource {
    @Inject
    private AgamaDeploymentsService ads;
    @Inject
    private AgamaFlowService flowService;
    private ObjectMapper mapper;

    @Operation(summary="Retrieve the list of projects deployed currently.", description="Retrieve the list of projects deployed currently.", operationId="get-agama-prj", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Agama projects", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response json example", value="example/agama/agama-prj-get-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama.readonly"}, groupScopes={"https://jans.io/oauth/config/agama.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Produces(value={"application/json"})
    public Response getDeployments(@Parameter(description="Start index for the result") @QueryParam(value="start") int start, @Parameter(description="Search size - count of the results to return") @QueryParam(value="count") int count) {
        int maxcount = this.getMaxCount();
        PagedResult<Deployment> res = this.ads.list(start < 0 ? 0 : start, count > 0 ? count : maxcount, maxcount);
        res.getEntries().forEach(this::minimize);
        return Response.ok(res).build();
    }

    @Operation(summary="Retrieve details of a single deployment by name.", description="Retrieve details of a single deployment by name.", operationId="get-agama-prj-by-name", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Agama project", content={@Content(mediaType="application/json", schema=@Schema(implementation=Deployment.class), examples={@ExampleObject(name="Response json example", value="example/agama/agama-prj-get.json")})}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama.readonly"}, groupScopes={"https://jans.io/oauth/config/agama.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Produces(value={"application/json"})
    @Path(value="/{name}")
    public Response getDeployment(@Parameter(description="Agama project name") @PathParam(value="name") String projectName) {
        Pair<Boolean, Deployment> p;
        Deployment d;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Get projectName:{}", (Object)Util.escapeLog((Object)projectName));
        }
        if ((d = (Deployment)(p = this.getDeploymentP(projectName)).getSecond()) == null) {
            return this.errorResponse((Boolean)p.getFirst(), projectName);
        }
        this.logger.debug("deployment:{}", (Object)d);
        return Response.ok((Object)d).build();
    }

    @Operation(summary="Add or replace an Agama project to the server.", description="Add or replace an Agama project to the server.", operationId="post-agama-prj", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.write"})})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Agama project accepted", content={@Content(mediaType="application/zip", schema=@Schema(implementation=String.class), examples={@ExampleObject(name="Response json example", value="example/agama/agama-prj-post.json")})}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @Consumes(value={"application/zip"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    @Path(value="/{name}")
    public Response deploy(@Parameter(description="Agama project name") @PathParam(value="name") String projectName, @Parameter(description="Boolean value to indicating to auto configure the project ") @QueryParam(value="autoconfigure") String autoconfigure, @Parameter(description="Agama gama file") byte[] gamaBinary) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Deploy projectName:{}, autoconfigure:{}, gamaBinary:{}", new Object[]{Util.escapeLog((Object)projectName), Util.escapeLog((Object)autoconfigure), Util.escapeLog((Object)gamaBinary)});
        }
        if (gamaBinary == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Project name or binary data missing").build();
        }
        if (this.ads.createDeploymentTask(projectName, gamaBinary, Boolean.parseBoolean(autoconfigure))) {
            return Response.accepted().entity((Object)("A deployment task for project " + projectName + " has been queued. Use the GET endpoint to poll status")).build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("There is an active deployment task for " + projectName + ". Wait for an OK response from the GET endpoint")).build();
    }

    @Operation(summary="Undeploy an Agama project from the server.", description="Undeploy an Agama project from the server.", operationId="delete-agama-prj", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/delete-all"})
    @Path(value="/{name}")
    public Response undeploy(@Parameter(description="Agama project name") @PathParam(value="name") String projectName) {
        Boolean result;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Undeploy projectName:{}", (Object)Util.escapeLog((Object)projectName));
        }
        if ((result = this.ads.createUndeploymentTask(projectName)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Unknown project " + projectName)).build();
        }
        if (!result.booleanValue()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Cannot undeploy project " + projectName + ": it is currently being deployed")).build();
        }
        return Response.noContent().build();
    }

    @Operation(summary="Retrieve the configurations associated to flows that belong to the project of interest. The project must have been already processed fully.", description="Retrieve the configurations associated to flows that belong to the project of interest. The project must have been already processed fully.", operationId="get-agama-prj-configs", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Agama projects configs", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class), examples={@ExampleObject(name="Response json example", value="example/agama/agama-prj-get-configs-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama.readonly"}, groupScopes={"https://jans.io/oauth/config/agama.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/configs/{name}")
    public Response getConfigs(@Parameter(description="Agama project name") @PathParam(value="name") String projectName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("getConfigs projectName:{}", (Object)Util.escapeLog((Object)projectName));
        }
        Pair<Boolean, Deployment> p = this.getDeploymentP(projectName);
        Deployment d = (Deployment)p.getSecond();
        this.logger.debug("Deployment:{}", (Object)d);
        if (d == null) {
            return this.errorResponse((Boolean)p.getFirst(), projectName);
        }
        HashMap<String, Map> configs = new HashMap<String, Map>();
        Set flowIds = Optional.ofNullable(d.getDetails().getFlowsError()).map(Map::keySet).orElse(Collections.emptySet());
        this.logger.debug("flowIds:{}", flowIds);
        for (String qname : flowIds) {
            Map config = Optional.ofNullable(this.flowService.getFlowByName(qname)).map(f -> f.getMetadata().getProperties()).orElse(null);
            if (config == null) {
                this.logger.warn("Flow {} does not exist or has no configuration properties defined", (Object)qname);
                continue;
            }
            this.logger.debug("Adding flow properties of {}", (Object)qname);
            configs.put(qname, config);
        }
        this.logger.debug("configs:{}", configs);
        try {
            return Response.ok((Object)this.mapper.writeValueAsString(configs)).build();
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Operation(summary="Set or replace the configurations associated to flows that belong to the project. The project must have been already processed fully.", description="Set or replace the configurations associated to flows that belong to the project. The project must have been already processed fully.", operationId="put-agama-prj", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.write"})})
    @RequestBody(description="JSON object with configurations associated to flows ", content={@Content(mediaType="application/json", schema=@Schema(implementation=HashMap.class), examples={@ExampleObject(name="Request example", value="example/agama/put-agama-prj-config.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="JSON object with properties values correspond to a boolean indicating the success of the update for the given flow.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class), examples={@ExampleObject(name="Response json example", value="example/agama/put-agama-prj-config-response.json")})}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Consumes(value={"application/json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    @Path(value="/configs/{name}")
    public Response setConfigs(@Parameter(description="Agama project name") @PathParam(value="name") String projectName, @Parameter(description="Agama flow config, key is `name` of config property and `value` is the property value. ") Map<String, Map<String, Object>> flowsConfigs) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Set Agama project configs projectName:{}, flowsConfigs:{}", (Object)Util.escapeLog((Object)projectName), (Object)Util.escapeLog(flowsConfigs));
        }
        if (flowsConfigs == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Mapping of flows vs. configs not provided").build();
        }
        Pair<Boolean, Deployment> p = this.getDeploymentP(projectName);
        Deployment d = (Deployment)p.getSecond();
        this.logger.debug("Set Agama project configs Deployment:{}", (Object)d);
        if (d == null) {
            return this.errorResponse((Boolean)p.getFirst(), projectName);
        }
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        Set flowIds = Optional.ofNullable(d.getDetails().getFlowsError()).map(Map::keySet).orElse(Collections.emptySet());
        this.logger.debug("Set Agama project configs  flowIds:{}", flowIds);
        for (String qname : flowsConfigs.keySet()) {
            if (qname != null && flowIds.contains(qname)) {
                Flow flow = this.flowService.getFlowByName(qname);
                boolean success = false;
                if (flow == null) {
                    this.logger.warn("Unable to retrieve flow {}", (Object)qname);
                } else {
                    try {
                        flow.getMetadata().setProperties(flowsConfigs.get(qname));
                        this.flowService.updateFlow(flow);
                        success = true;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                results.put(qname, success);
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Flow {} is not part of project {}, config ignored", (Object)qname, (Object)projectName.replaceAll("[\n\r]", "_"));
        }
        this.logger.debug("Final Agama project configs results:{}", results);
        return Response.ok(results).build();
    }

    private Pair<Boolean, Deployment> getDeploymentP(String projectName) {
        Deployment d = this.ads.getDeployment(projectName);
        if (d == null) {
            return new Pair((Object)false, null);
        }
        if (d.getFinishedAt() == null) {
            return new Pair((Object)true, null);
        }
        return new Pair((Object)true, (Object)this.minimize(d));
    }

    private Response errorResponse(boolean flag, String projectName) {
        if (flag) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Unknown project " + projectName)).build();
    }

    private Deployment minimize(Deployment d) {
        d.getDetails().setFolders(null);
        return d;
    }

    @PostConstruct
    private void init() {
        this.mapper = new ObjectMapper();
    }
}

