/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.model.configuration.AuditLogConf;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.util.AuthUtil;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/audit")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AuditLogResource
extends ConfigBaseResource {
    public static final String AUDIT_FILE_PATH = "/opt/jans/jetty/jans-config-api/logs/";
    public static final String AUDIT_FILE_NAME = "configapi-audit.log";
    public static final String AUDIT_FILE_DATE_FORMAT = "dd-MM-yyyy";
    static final String AUDIT = "/audit";
    @Inject
    Logger log;
    @Inject
    AuthUtil authUtil;

    @Operation(summary="Get audit details.", description="Get audit details.", operationId="get-audit-data", tags={"Logs"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/logging.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=LogPagedResult.class), examples={@ExampleObject(name="Response example")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/logging.readonly"}, groupScopes={"https://jans.io/oauth/config/logging.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getLogsEnteries(@Parameter(description="Search pattern") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(schema=@Schema(type="string", format="date", description="Start-Date for which the log entries report is to be fetched in `dd-MM-yyyy` format")) @QueryParam(value="start_date") String startDate, @Parameter(schema=@Schema(type="string", format="date", description="End-Date for which the log entries is to be fetched in `dd-MM-yyyy` format")) @QueryParam(value="end_date") String endDate) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Search Attribute filters with pattern:{}, startIndex:{}, limit:{}, startDate:{}, endDate:{}", new Object[]{Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)limit), Util.escapeLog((Object)startDate), Util.escapeLog((Object)endDate)});
        }
        return Response.ok((Object)((Object)this.doSearch(this.getPattern(pattern), startIndex, limit, startDate, endDate))).build();
    }

    private LogPagedResult doSearch(String pattern, int startIndex, int limit, String startDate, String endDate) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Search Attribute filters with pattern:{}, startIndex:{}, limit:{}, startDate:{}, endDate:{}", new Object[]{Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)limit), Util.escapeLog((Object)startDate), Util.escapeLog((Object)endDate)});
        }
        List<String> logEntriesList = this.getLogEntries(this.getAuditLogFile(), pattern);
        this.log.debug("Log fetched  - logEntriesList:{}", logEntriesList);
        logEntriesList = this.filterLogByDate(logEntriesList, startDate, endDate);
        this.log.debug("Log fetched  - logEntriesList:{}", logEntriesList);
        LogPagedResult logPagedResult = this.getLogPagedResult(logEntriesList, startIndex, limit);
        this.log.debug("Audit Log PagedResult:{}", (Object)logPagedResult);
        return logPagedResult;
    }

    private List<String> getLogEntries(String file, String pattern) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Fetch log file:{}, pattern:{}", (Object)file, (Object)pattern);
        }
        List<String> logEntries = new ArrayList<String>();
        try (Stream<String> stream = Files.lines(java.nio.file.Path.of(file, new String[0]));){
            logEntries = stream.filter(s -> s.matches(pattern)).collect(Collectors.toList());
        }
        catch (IOException ex) {
            AuditLogResource.throwInternalServerException((String)" Error while fetching logs", (Throwable)ex);
        }
        return logEntries;
    }

    private String getPattern(String pattern) {
        String searchPattern = "^.*$";
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("^.*");
            stringBuilder.append(pattern);
            stringBuilder.append(".*$");
            searchPattern = stringBuilder.toString();
        }
        return searchPattern;
    }

    private LogPagedResult getLogPagedResult(List<String> logEntriesList, int startIndex, int limit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Audit logEntriesList:{}, startIndex:{}, limit:{}", new Object[]{logEntriesList, Util.escapeLog((Object)startIndex), Util.escapeLog((Object)limit)});
        }
        LogPagedResult logPagedResult = new LogPagedResult();
        if (logEntriesList != null && !logEntriesList.isEmpty()) {
            try {
                this.getStartIndex(logEntriesList, startIndex);
                int toIndex = startIndex + limit <= logEntriesList.size() ? startIndex + limit : logEntriesList.size();
                this.log.info("Final startIndex:{}, limit:{}, toIndex:{}", new Object[]{startIndex, limit, toIndex});
                List<String> sublist = logEntriesList.subList(startIndex, toIndex);
                logPagedResult.setStart(startIndex);
                logPagedResult.setEntriesCount(limit);
                logPagedResult.setTotalEntriesCount(logEntriesList.size());
                logPagedResult.setEntries(sublist);
            }
            catch (IndexOutOfBoundsException ioe) {
                this.log.error("Error while getting log data is - ", (Throwable)ioe);
                AuditLogResource.throwBadRequestException((String)("Index may be incorrect, total entries:{" + logEntriesList.size() + "}, startIndex provided:{" + startIndex + "} , endtIndex provided:{" + limit + "} "));
            }
        }
        this.log.info("Audit logPagedResult:{}", (Object)logPagedResult);
        return logPagedResult;
    }

    private AuditLogConf getAuditLogConf() {
        return this.authUtil.getAuditLogConf();
    }

    private String getAuditDateFormat() {
        return this.authUtil.getAuditLogConf().getAuditLogDateFormat();
    }

    private String getAuditLogFile() {
        String filePath = this.getAuditLogConf().getAuditLogFilePath() != null ? this.getAuditLogConf().getAuditLogFilePath() : AUDIT_FILE_PATH;
        String fileName = this.getAuditLogConf().getAuditLogFileName() != null ? this.getAuditLogConf().getAuditLogFileName() : AUDIT_FILE_NAME;
        StringBuilder stringBuilder = new StringBuilder(filePath);
        stringBuilder.append(fileName);
        return stringBuilder.toString();
    }

    private int getStartIndex(List<String> logEntriesList, int startIndex) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Get startIndex logEntriesList:{}, startIndex:{}", logEntriesList, (Object)Util.escapeLog((Object)startIndex));
        }
        if (logEntriesList != null && !logEntriesList.isEmpty()) {
            try {
                logEntriesList.get(startIndex);
            }
            catch (IndexOutOfBoundsException ioe) {
                this.log.error("Error while getting data startIndex:{}", (Object)startIndex, (Object)ioe);
                AuditLogResource.throwBadRequestException((String)("Page start index incorrect, total entries:{" + logEntriesList.size() + "}, but provided:{" + startIndex + "} "));
            }
        }
        return startIndex;
    }

    private List<String> filterLogByDate(List<String> logEntries, String startDate, String endDate) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(" logEntries:{}, startDate:{}, endDate:{} ", new Object[]{logEntries, Util.escapeLog((Object)startDate), Util.escapeLog((Object)endDate)});
        }
        if (logEntries == null || logEntries.isEmpty() || StringUtils.isBlank((CharSequence)startDate) && StringUtils.isBlank((CharSequence)endDate)) {
            return logEntries;
        }
        ArrayList<String> filteredLogEntries = new ArrayList<String>();
        try {
            String datePattern = StringUtils.isNotBlank((CharSequence)this.getAuditDateFormat()) ? this.getAuditDateFormat() : AUDIT_FILE_DATE_FORMAT;
            this.log.debug("datePattern:{}", (Object)datePattern);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
            for (int i = 0; i < logEntries.size(); ++i) {
                String timestampPart;
                LocalDate logEntryLocalDate;
                String line = logEntries.get(i);
                if (!StringUtils.isNotBlank((CharSequence)line) || line.length() <= datePattern.length() || !this.isValidlogEntry(formatter, startDate, endDate, logEntryLocalDate = this.getDate(timestampPart = line.substring(0, datePattern.length()), formatter))) continue;
                filteredLogEntries.add(line);
            }
        }
        catch (Exception ex) {
            this.log.error("Error while filtering log file with startDate:{} and endDate:{} is:{}", new Object[]{startDate, endDate, ex});
            return logEntries;
        }
        return filteredLogEntries;
    }

    private void validateDate(String startDate, String endDate, DateTimeFormatter formatter) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Validate Date startDate:{}, endDate:{}, formatter:{}", new Object[]{Util.escapeLog((Object)startDate), Util.escapeLog((Object)endDate), formatter});
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            try {
                this.parseDate(startDate, formatter);
            }
            catch (DateTimeParseException dtpe) {
                sb.append("Start date is not valid, date:{" + startDate + "} whereas valid format is:{" + formatter.toString() + "}");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            try {
                this.parseDate(endDate, formatter);
            }
            catch (DateTimeParseException dtpe) {
                sb.append("End date is not valid, date:{" + startDate + "} whereas valid format is:{" + formatter.toString() + "}");
            }
        }
        if (sb.toString().length() > 0) {
            AuditLogResource.throwBadRequestException((String)sb.toString(), (String)"INVALID_DATE");
        }
    }

    private boolean isValidlogEntry(DateTimeFormatter formatter, String startDate, String endDate, LocalDate logEntryLocalDate) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(" formatter:{}, startDate:{}, endDate:{}, logEntryLocalDate:{}", new Object[]{formatter, Util.escapeLog((Object)startDate), Util.escapeLog((Object)endDate), logEntryLocalDate});
        }
        boolean isValid = false;
        this.validateDate(startDate, endDate, formatter);
        LocalDate startLocalDate = null;
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            startLocalDate = this.parseDate(startDate, formatter);
        }
        LocalDate endLocalDate = null;
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            endLocalDate = this.parseDate(endDate, formatter);
        }
        if (logEntryLocalDate != null) {
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate) && (logEntryLocalDate.isEqual(startLocalDate) || logEntryLocalDate.isAfter(startLocalDate)) && (logEntryLocalDate.isEqual(endLocalDate) || logEntryLocalDate.isBefore(endLocalDate))) {
                isValid = true;
            } else if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isBlank((CharSequence)endDate) && (logEntryLocalDate.isEqual(startLocalDate) || logEntryLocalDate.isAfter(startLocalDate)) || StringUtils.isBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate) && (logEntryLocalDate.isEqual(endLocalDate) || logEntryLocalDate.isBefore(endLocalDate))) {
                isValid = true;
            }
        }
        return isValid;
    }

    private LocalDate getDate(String strDate, DateTimeFormatter formatter) throws DateTimeParseException {
        this.log.debug(" Get Date strDate:{}, formatter:{}", (Object)strDate, (Object)formatter);
        LocalDate logDate = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)strDate)) {
                logDate = this.parseDate(strDate, formatter);
            }
        }
        catch (DateTimeParseException ex) {
            this.log.error("Error while parsing logDate:{} is:{}", (Object)logDate, (Object)ex);
            return logDate;
        }
        return logDate;
    }

    private LocalDate parseDate(String date, DateTimeFormatter formatter) throws DateTimeParseException {
        this.log.debug(" Parse Date date:{}, formatter:{}", (Object)date, (Object)formatter);
        return LocalDate.parse(date, formatter);
    }

    private class LogPagedResult
    extends PagedResult<String> {
        private LogPagedResult() {
        }
    }
}

