/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.agama.model.EngineConfig;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.config.Conf;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.configapi.core.model.PersistenceConfiguration;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.EnumSet;
import org.slf4j.Logger;

@Path(value="/jans-auth-server/config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AuthConfigResource
extends ConfigBaseResource {
    private static final String AGAMACONFIGURATION = "agamaConfiguration";
    @Inject
    Logger log;
    @Inject
    ConfigurationService configurationService;

    @Operation(summary="Gets all Jans authorization server configuration properties.", description="Gets all Jans authorization server configuration properties.", operationId="get-properties", tags={"Configuration \u2013 Properties"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/properties.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/properties.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/properties.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getAppConfiguration() {
        AppConfiguration appConfiguration = this.configurationService.find();
        this.log.debug("AuthConfigResource::getAppConfiguration() appConfiguration:{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }

    @Operation(summary="Partially modifies Jans authorization server Application configuration properties.", description="Partially modifies Jans authorization server AppConfiguration properties.", operationId="patch-properties", tags={"Configuration \u2013 Properties"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/properties.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/auth/config/auth-config-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/properties.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response patchAppConfigurationProperty(@NotNull String jsonPatchString) throws JsonPatchException, IOException {
        this.log.debug("AUTH CONF details to patch - jsonPatchString:{} ", (Object)jsonPatchString);
        Conf conf = this.configurationService.findConf();
        AppConfiguration appConfiguration = this.configurationService.find();
        this.log.debug("AUTH CONF details BEFORE patch - appConfiguration :{}", (Object)appConfiguration);
        appConfiguration = (AppConfiguration)Jackson.applyPatch((String)jsonPatchString, (Object)conf.getDynamic());
        this.log.debug("AUTH CONF details BEFORE patch merge - appConfiguration:{}", (Object)appConfiguration);
        conf.setDynamic(appConfiguration);
        if (jsonPatchString.contains(AGAMACONFIGURATION)) {
            this.validateAgamaConfiguration(appConfiguration.getAgamaConfiguration());
        }
        this.configurationService.merge(conf);
        appConfiguration = this.configurationService.find();
        this.log.debug("AUTH CONF details AFTER patch merge - appConfiguration:{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }

    @Operation(summary="Returns persistence type configured for Jans authorization server.", description="Returns persistence type configured for Jans authorization server.", operationId="get-properties-persistence", tags={"Configuration \u2013 Properties"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/properties.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Jans Authorization Server persistence type", content={@Content(mediaType="application/json", schema=@Schema(implementation=PersistenceConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/config/auth-config-persistence.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/properties.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/properties.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/persistence")
    public Response getPersistenceDetails() {
        PersistenceConfiguration persistenceConfiguration = this.configurationService.getPersistenceMetadata();
        this.log.debug("AuthConfigResource::getPersistenceDetails() - persistenceConfiguration:{}", (Object)persistenceConfiguration);
        return Response.ok((Object)persistenceConfiguration).build();
    }

    @Operation(summary="Returns feature flags type configured for Jans authorization server.", description="Returns feature flags type configured for Jans authorization server.", operationId="get-feature-flag-type", tags={"Configuration \u2013 Properties"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/config/properties.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class, type="enum")))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/config/properties.readonly"}, groupScopes={"https://jans.io/oauth/jans-auth-server/config/properties.write"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/feature-flags")
    public Response getFeatureFlagType() {
        EnumSet<FeatureFlagType> set = EnumSet.allOf(FeatureFlagType.class);
        set.remove(FeatureFlagType.UNKNOWN);
        this.log.debug("set:{}", set);
        return Response.ok(set).build();
    }

    private void validateAgamaConfiguration(EngineConfig engineConfig) {
        this.log.debug("engineConfig:{}", (Object)engineConfig);
        if (engineConfig == null) {
            return;
        }
        if (engineConfig.getMaxItemsLoggedInCollections() < 1) {
            AuthConfigResource.throwBadRequestException((String)("maxItemsLoggedInCollections should be greater than zero -> " + engineConfig.getMaxItemsLoggedInCollections()));
        }
    }
}

