/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.common.InumService;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.configapi.core.annotation.Ignore;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AttributeService;
import io.jans.configapi.service.auth.ClientService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.service.auth.ScopeService;
import io.jans.configapi.util.AuthUtil;
import io.jans.model.JansAttribute;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.PagedResult;
import io.jans.service.EncryptionService;
import io.jans.util.StringHelper;
import io.jans.util.security.StringEncrypter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

@Path(value="/openid/clients")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ApplicationScoped
public class ClientsResource
extends ConfigBaseResource {
    private static final String OPENID_CONNECT_CLIENT = "openid connect client";
    private static final String CLIENT_SECRET = "clientSecret";
    @Inject
    private ApiAppConfiguration appConfiguration;
    @Inject
    ClientService clientService;
    @Inject
    ConfigurationService configurationService;
    @Inject
    private InumService inumService;
    @Inject
    EncryptionService encryptionService;
    @Inject
    AuthUtil authUtil;
    @Inject
    ScopeService scopeService;
    @Inject
    AttributeService attributeService;

    @Operation(summary="Gets list of OpenID Connect clients", description="Gets list of OpenID Connect clients", operationId="get-oauth-openid-clients", tags={"OAuth - OpenID Connect - Clients"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/openid/clients.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response json example", value="example/openid-clients/clients/openid-clients-get-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/openid/clients.readonly"}, groupScopes={"https://jans.io/oauth/config/openid-read"}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getOpenIdConnectClients(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for searching", examples={@ExampleObject(name="Field value example", value="applicationType=web,persistClientAuthorizations=true")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) throws StringEncrypter.EncryptionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Client search param - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.clientService.getDnForClient(null), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, Client.class);
        return Response.ok(this.doSearch(searchReq)).build();
    }

    @Operation(summary="Get OpenId Connect Client by Inum", description="Get OpenId Connect Client by Inum", operationId="get-oauth-openid-clients-by-inum", tags={"OAuth - OpenID Connect - Clients"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/openid/clients.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Client.class), examples={@ExampleObject(name="Response json example", value="example/openid-clients/clients/openid-clients-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/openid/clients.readonly"}, groupScopes={"https://jans.io/oauth/config/openid-read"}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="{inum}")
    public Response getOpenIdClientByInum(@Parameter(description="Client identifier") @PathParam(value="inum") @NotNull String inum) throws StringEncrypter.EncryptionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Client search by inum:{}", (Object)Util.escapeLog((Object)inum));
        }
        Client client = this.clientService.getClientByInum(inum);
        ClientsResource.checkResourceNotNull((Object)client, (String)OPENID_CONNECT_CLIENT);
        return Response.ok((Object)this.applyResponsePolicy(client)).build();
    }

    @Operation(summary="Create new OpenId Connect client", description="Create new OpenId Connect client", operationId="post-oauth-openid-client", tags={"OAuth - OpenID Connect - Clients"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/openid/clients.write"})})
    @RequestBody(description="OpenID Connect Client object", content={@Content(mediaType="application/json", schema=@Schema(implementation=Client.class), examples={@ExampleObject(name="Request json example", value="example/openid-clients/clients/openid-clients-post.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=Client.class), examples={@ExampleObject(name="Response json example", value="example/openid-clients/clients/openid-clients-get.json")})}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/openid/clients.write"}, groupScopes={"https://jans.io/oauth/config/openid/openid-write"}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response createOpenIdConnect(@Valid Client client) throws StringEncrypter.EncryptionException {
        String clientSecret;
        String inum;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Client to be added - client:{}, client.getAttributes():{}, client.getCustomAttributes():{}", new Object[]{Util.escapeLog((Object)client), Util.escapeLog((Object)client.getAttributes()), Util.escapeLog((Object)client.getCustomAttributes())});
        }
        if ((inum = client.getClientId()) == null || inum.isEmpty() || inum.isBlank()) {
            inum = this.inumService.generateClientInum();
            client.setClientId(inum);
        }
        ClientsResource.checkNotNull((String[])client.getRedirectUris(), (String)"redirectUris");
        this.checkScopeFormat(client);
        String[] claims = client.getClaims();
        if (client.getClaims() != null && client.getClaims().length > 0) {
            this.validateClaim(client);
        }
        if (StringHelper.isEmpty((String)(clientSecret = client.getClientSecret()))) {
            clientSecret = this.generatePassword();
        }
        client.setClientSecret(this.encryptionService.encrypt(clientSecret));
        client.setDn(this.clientService.getDnForClient(inum));
        client.setDeletable(Boolean.valueOf(client.getClientSecretExpiresAt() != null));
        this.ignoreCustomObjectClassesForNonLDAP(client);
        this.logger.trace("Final Client details to be added - client:{}, client.getAttributes():{}, client.getCustomAttributes():{}", new Object[]{client, client.getAttributes(), client.getCustomAttributes()});
        this.clientService.addClient(client);
        Client result = this.clientService.getClientByInum(inum);
        result.setClaims(claims);
        this.applyResponsePolicy(result);
        this.logger.debug("Claim post creation - result.getClaims():{} ", (Object[])result.getClaims());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    @Operation(summary="Update OpenId Connect client", description="Update OpenId Connect client", operationId="put-oauth-openid-client", tags={"OAuth - OpenID Connect - Clients"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/openid/clients.write"})})
    @RequestBody(description="OpenID Connect Client object", content={@Content(mediaType="application/json", schema=@Schema(implementation=Client.class), examples={@ExampleObject(name="Request json example", value="example/openid-clients/clients/openid-clients-put.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Client.class), examples={@ExampleObject(name="Response json example", value="example/openid-clients/clients/openid-clients-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @Ignore
    @ProtectedApi(scopes={"https://jans.io/oauth/config/openid/clients.write"}, groupScopes={"https://jans.io/oauth/config/openid/openid-write"}, superScopes={"https://jans.io/oauth/config/write-all"})
    public Response updateClient(@Valid Client client) throws StringEncrypter.EncryptionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Client details to be updated - client:{}", (Object)Util.escapeLog((Object)client));
        }
        String inum = client.getClientId();
        ClientsResource.checkNotNull((String)inum, (String)"inum");
        ClientsResource.checkNotNull((String[])client.getRedirectUris(), (String)"redirectUris");
        Client existingClient = this.clientService.getClientByInum(inum);
        ClientsResource.checkResourceNotNull((Object)existingClient, (String)OPENID_CONNECT_CLIENT);
        this.checkScopeFormat(client);
        String[] claims = client.getClaims();
        if (client.getClaims() != null && client.getClaims().length > 0) {
            this.validateClaim(client);
        }
        client.setClientId(existingClient.getClientId());
        client.setBaseDn(this.clientService.getDnForClient(inum));
        client.setDeletable(Boolean.valueOf(client.getExpirationDate() != null));
        if (client.getClientSecret() != null) {
            client.setClientSecret(this.encryptionService.encrypt(client.getClientSecret()));
        }
        this.ignoreCustomObjectClassesForNonLDAP(client);
        this.logger.debug("Final Client details to be updated - client:{}", (Object)client);
        this.clientService.updateClient(client);
        Client result = this.clientService.getClientByInum(existingClient.getClientId());
        result.setClaims(claims);
        this.applyResponsePolicy(result);
        this.logger.debug("Claim post updation - result.getClaims():{} ", (Object[])result.getClaims());
        return Response.ok((Object)result).build();
    }

    @Operation(summary="Patch OpenId Connect client", description="Patch OpenId Connect client", operationId="patch-oauth-openid-client-by-inum", tags={"OAuth - OpenID Connect - Clients"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/openid/clients.write"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/openid-clients/clients/openid-clients-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Client.class), examples={@ExampleObject(name="Response json example", value="example/openid-clients/clients/openid-clients-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/openid/clients.write"}, groupScopes={"https://jans.io/oauth/config/openid/openid-write"}, superScopes={"https://jans.io/oauth/config/write-all"})
    @Path(value="{inum}")
    public Response patchClient(@Parameter(description="Client identifier") @PathParam(value="inum") @NotNull String inum, @NotNull String jsonPatchString) throws StringEncrypter.EncryptionException, JsonPatchException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Client details to be patched - inum:{}, jsonPatchString:{}", (Object)Util.escapeLog((Object)inum), (Object)Util.escapeLog((Object)jsonPatchString));
        }
        Client existingClient = this.clientService.getClientByInum(inum);
        ClientsResource.checkResourceNotNull((Object)existingClient, (String)OPENID_CONNECT_CLIENT);
        existingClient = (Client)Jackson.applyPatch((String)jsonPatchString, (Object)existingClient);
        boolean isClientSecretPresent = Jackson.isFieldPresent((String)jsonPatchString, (String)CLIENT_SECRET);
        this.logger.debug(" isFieldPresent - CLIENT_SECRET - isClientSecretPresent:{}", (Object)isClientSecretPresent);
        if (isClientSecretPresent && StringUtils.isNotBlank((CharSequence)existingClient.getClientSecret())) {
            existingClient.setClientSecret(this.encryptionService.encrypt(existingClient.getClientSecret()));
        }
        this.clientService.updateClient(existingClient);
        this.applyResponsePolicy(existingClient);
        return Response.ok((Object)existingClient).build();
    }

    @Operation(summary="Delete OpenId Connect client", description="Delete OpenId Connect client", operationId="delete-oauth-openid-client-by-inum", tags={"OAuth - OpenID Connect - Clients"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/openid/clients.delete"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="{inum}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/openid/clients.delete"}, groupScopes={"https://jans.io/oauth/config/openid/openid-delete"}, superScopes={"https://jans.io/oauth/config/delete-all"})
    public Response deleteClient(@Parameter(description="Client identifier") @PathParam(value="inum") @NotNull String inum) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Client to be deleted - inum:{} ", (Object)Util.escapeLog((Object)inum));
        }
        Client client = this.clientService.getClientByInum(inum);
        ClientsResource.checkResourceNotNull((Object)client, (String)OPENID_CONNECT_CLIENT);
        this.clientService.removeClient(client);
        return Response.noContent().build();
    }

    private List<Client> applyResponsePolicy(List<Client> clients) {
        this.logger.debug("isReturnClientSecretInResponse():{}, isReturnEncryptedClientSecretInResponse():{}, clients:{}", new Object[]{this.isReturnClientSecretInResponse(), this.isReturnEncryptedClientSecretInResponse(), clients});
        if (clients == null || clients.isEmpty()) {
            return clients;
        }
        for (Client client : clients) {
            this.applyResponsePolicy(client);
        }
        return clients;
    }

    private Client applyResponsePolicy(Client client) {
        this.logger.debug(" ApplyResponsePolicy - isReturnClientSecretInResponse():{}, isReturnEncryptedClientSecretInResponse():{}, client:{}", new Object[]{this.isReturnClientSecretInResponse(), this.isReturnEncryptedClientSecretInResponse(), client});
        if (client == null) {
            return client;
        }
        if (this.isReturnClientSecretInResponse()) {
            if (!this.isReturnEncryptedClientSecretInResponse()) {
                this.getDecryptedClientSecret(client);
            }
        } else {
            client.setClientSecret(null);
        }
        return client;
    }

    private Client getDecryptedClientSecret(Client client) {
        if (client != null) {
            try {
                client.setClientSecret(this.encryptionService.decrypt(client.getClientSecret()));
            }
            catch (Exception ex) {
                this.logger.error(" Error while decrypting ClientSecret for '{}', exception is - ", (Object)client.getClientId(), (Object)ex);
                client.setClientSecret(null);
            }
        }
        return client;
    }

    private String generatePassword() {
        return UUID.randomUUID().toString();
    }

    private PagedResult<Client> doSearch(SearchRequest searchReq) throws StringEncrypter.EncryptionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Client search params - searchReq:{} ", (Object)Util.escapeLog((Object)searchReq));
        }
        PagedResult<Client> pagedResult = this.clientService.getClients(searchReq);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("PagedResult  - pagedResult:{}", pagedResult);
        }
        if (pagedResult != null) {
            this.logger.debug("Client fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
            List clients = pagedResult.getEntries();
            this.applyResponsePolicy(clients);
            this.logger.debug("Clients fetched  - clients:{}", (Object)clients);
            pagedResult.setEntries(clients);
        }
        this.logger.debug("Clients pagedResult:{}", pagedResult);
        return pagedResult;
    }

    private Client ignoreCustomObjectClassesForNonLDAP(Client client) {
        String persistenceType = this.configurationService.getPersistenceType();
        this.logger.debug("persistenceType: {}", (Object)persistenceType);
        if (!PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(persistenceType)) {
            this.logger.debug("Setting CustomObjectClasses :{} to null as its used only for LDAP and current persistenceType is {} ", (Object)client.getCustomObjectClasses(), (Object)persistenceType);
            client.setCustomObjectClasses(null);
        }
        return client;
    }

    private Client checkScopeFormat(Client client) {
        if (client == null) {
            return client;
        }
        this.logger.debug("Checking client.getScopes():{}", (Object[])client.getScopes());
        if (client.getScopes() == null || client.getScopes().length == 0) {
            return client;
        }
        ArrayList<String> validScopes = new ArrayList<String>();
        ArrayList<String> invalidScopes = new ArrayList<String>();
        for (String scope : client.getScopes()) {
            this.logger.debug("Is scope:{} valid:{}", (Object)scope, (Object)this.authUtil.isValidDn(scope));
            List<Object> scopes = new ArrayList();
            if (this.authUtil.isValidDn(scope)) {
                Scope scp = this.findScopeByDn(scope);
                if (scp != null) {
                    scopes.add(scp);
                }
            } else {
                scopes = this.scopeService.searchScopesById(scope);
            }
            this.logger.debug("Scopes from DB - {}'", scopes);
            if (!scopes.isEmpty()) {
                validScopes.add(((Scope)scopes.get(0)).getDn());
                continue;
            }
            invalidScopes.add(scope);
        }
        this.logger.debug("Scope validation result - validScopes:{}, invalidScopes:{} ", validScopes, invalidScopes);
        if (!invalidScopes.isEmpty()) {
            ClientsResource.throwBadRequestException((String)("Invalid scope in request -> " + ((Object)invalidScopes).toString()));
        }
        if (!validScopes.isEmpty()) {
            String[] scopeArr = (String[])validScopes.stream().toArray(String[]::new);
            client.setScopes(scopeArr);
        }
        return client;
    }

    private Scope findScopeByDn(String scopeDn) {
        try {
            return this.scopeService.getScopeByDn(scopeDn);
        }
        catch (EntryPersistenceException e) {
            return null;
        }
    }

    private Client validateClaim(Client client) {
        if (client == null) {
            return client;
        }
        this.logger.debug("client.getClaims():{}", (Object[])client.getClaims());
        List<String> claims = client.getClaims() != null ? Arrays.asList(client.getClaims()) : null;
        this.logger.debug("Client claims:{}", claims);
        ArrayList<String> validClaims = new ArrayList<String>();
        ArrayList<String> invalidClaims = new ArrayList<String>();
        for (String claim : claims) {
            this.logger.debug("Is claim:{} valid-DN?:{}", (Object)claim, (Object)this.authUtil.isValidDn(claim));
            JansAttribute jansAttribute = null;
            jansAttribute = this.authUtil.isValidDn(claim) ? this.attributeService.getAttributeUsingDn(claim) : this.attributeService.getAttributeUsingName(claim);
            this.logger.debug("Attribute from DB - {}'", (Object)jansAttribute);
            if (jansAttribute != null) {
                validClaims.add(jansAttribute.getDn());
                continue;
            }
            invalidClaims.add(claim);
        }
        this.logger.debug("Claim validation result - validClaims:{}, invalidClaims:{} ", validClaims, invalidClaims);
        if (!invalidClaims.isEmpty()) {
            ClientsResource.throwBadRequestException((String)("Invalid claim in request -> " + ((Object)invalidClaims).toString()));
        }
        if (!validClaims.isEmpty()) {
            String[] scopeArr = (String[])validClaims.stream().toArray(String[]::new);
            client.setClaims(scopeArr);
        }
        return client;
    }

    private boolean isReturnEncryptedClientSecretInResponse() {
        this.logger.debug("appConfiguration.isReturnEncryptedClientSecretInResponse():{} ", (Object)this.appConfiguration.isReturnEncryptedClientSecretInResponse());
        return this.appConfiguration.isReturnEncryptedClientSecretInResponse();
    }

    private boolean isReturnClientSecretInResponse() {
        this.logger.debug("appConfiguration.isReturnClientSecretInResponse():{} ", (Object)this.appConfiguration.isReturnClientSecretInResponse());
        return this.appConfiguration.isReturnClientSecretInResponse();
    }
}

