/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.model.configuration.PluginConf;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.util.AuthUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/plugin")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PluginResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    AuthUtil authUtil;

    @Operation(summary="Gets list of Plugins", description="Gets list of Plugins", operationId="get-plugins", tags={"Plugins"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/plugin.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PluginConf.class)), examples={@ExampleObject(name="Response example", value="example/plugins/plugin-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/plugin.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getPlugins() {
        return Response.ok(this.getPluginNames()).build();
    }

    @Operation(summary="Get plugin by name", description="Get plugin by name", operationId="get-plugin-by-name", tags={"Plugins"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/plugin.readonly"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="{pluginName}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/plugin.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response isPluginDeployed(@Parameter(description="Plugin name") @NotNull @PathParam(value="pluginName") String pluginName) {
        List<PluginConf> plugins = this.getPluginNames();
        Boolean deployed = false;
        this.logger.info("All plugins:{} ", plugins);
        if (StringUtils.isNotBlank((CharSequence)pluginName) && !plugins.isEmpty()) {
            Optional<PluginConf> pluginNameOptional = plugins.stream().filter(plugin -> pluginName.equalsIgnoreCase(plugin.getName())).findAny();
            this.logger.debug("pluginNameOptional:{} ", pluginNameOptional);
            if (pluginNameOptional.isPresent()) {
                deployed = true;
            }
        }
        this.logger.info("deployed:{} ", (Object)deployed);
        return Response.ok((Object)deployed).build();
    }

    private List<PluginConf> getPluginNames() {
        List<PluginConf> plugins = this.authUtil.getPluginConf();
        this.logger.info("Config plugins:{} ", plugins);
        ArrayList<PluginConf> pluginInfo = new ArrayList<PluginConf>();
        if (plugins != null && !plugins.isEmpty()) {
            for (PluginConf pluginConf : plugins) {
                this.logger.debug("pluginConf:{} ", (Object)pluginConf);
                if (!StringUtils.isNotBlank((CharSequence)pluginConf.getClassName())) continue;
                try {
                    this.logger.debug("pluginConf.getClassName():{} ", (Object)pluginConf.getClassName());
                    Class.forName(pluginConf.getClassName());
                    PluginConf conf = new PluginConf();
                    conf.setName(pluginConf.getName());
                    conf.setDescription(pluginConf.getDescription());
                    pluginInfo.add(conf);
                }
                catch (ClassNotFoundException ex) {
                    this.logger.error("'{}' plugin not deployed", (Object)pluginConf.getName());
                }
            }
        }
        this.logger.info("pluginInfo:{} ", pluginInfo);
        return pluginInfo;
    }
}

