/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.SessionService;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;

@Path(value="/jans-auth-server/session")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SessionResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    SessionService sessionService;

    @Operation(summary="Return all session", description="Return all session", operationId="get-sessions", tags={"Auth - Session Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/session.readonly", "revoke_session"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SessionPagedResult.class), examples={@ExampleObject(name="Response json example", value="example/session/get-session.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/session.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    public Response getAllSessions() {
        SearchRequest searchReq = this.createSearchRequest(this.sessionService.getDnForSession(null), null, "jansId", "ascending", Integer.parseInt("0"), Integer.parseInt("50"), null, null, this.getMaxCount(), null, SessionId.class);
        SessionPagedResult sessionPagedResult = this.searchSession(searchReq);
        this.logger.info("Session fetched sessionPagedResult:{}", (Object)sessionPagedResult);
        return Response.ok((Object)((Object)sessionPagedResult)).build();
    }

    @Operation(summary="Search session", description="Search session", operationId="search-session", tags={"Auth - Session Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/session.readonly", "revoke_session"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SessionPagedResult.class), examples={@ExampleObject(name="Response json example", value="example/session/search-session.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/session.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/search")
    public Response searchSessionEntries(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="jansId") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="userDn=d5552516-4436-4908-ab36-3e9725246304,expirationDate>2025-09-25,expirationDate<2026-10-15")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Session serach param - limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.sessionService.getDnForSession(null), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, SessionId.class);
        SessionPagedResult sessionPagedResult = this.searchSession(searchReq);
        this.logger.info("Session fetched based on name are:{}", (Object)sessionPagedResult);
        return Response.ok((Object)((Object)sessionPagedResult)).build();
    }

    @Operation(summary="Get session by id.", description="Get session by id.", operationId="get-session-by-id", tags={"Auth - Session Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/session.readonly", "revoke_session"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SessionId.class), examples={@ExampleObject(name="Response example", value="example/token/get-session-by-id.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/session.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/read-all"})
    @Path(value="/sid/{sid}")
    public Response getSessionById(@Parameter(description="Session identifier.") @PathParam(value="sid") @NotNull String sid) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Delete session identified by sid:{}", (Object)Util.escapeLog((Object)sid));
        }
        SessionResource.checkResourceNotNull((Object)sid, (String)"sid");
        SessionId session = this.sessionService.getSessionBySid(sid);
        this.logger.debug("session:{}", (Object)session);
        return Response.ok((Object)session).build();
    }

    @Operation(summary="Revoke all sessions by userDn", description="Revoke all sessions by userDn", operationId="revoke-user-session", tags={"Auth - Session Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/session.delete", "revoke_session"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/session.delete", "revoke_session"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/delete-all"})
    @Path(value="/user/{userDn}")
    public Response deleteUsersSession(@Parameter(description="User domain name") @PathParam(value="userDn") @NotNull String userDn) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Delete session by userDn:{}", (Object)Util.escapeLog((Object)userDn));
        }
        SessionResource.checkResourceNotNull((Object)userDn, (String)"userDn");
        this.sessionService.revokeUserSession(userDn);
        return Response.ok().build();
    }

    @Operation(summary="Delete a session.", description="Delete a session.", operationId="delete-session", tags={"Auth - Session Management"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/jans-auth-server/session.delete", "revoke_session"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/jans-auth-server/session.delete", "revoke_session"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/delete-all"})
    @Path(value="/sid/{sid}")
    public Response deleteSessionBySid(@Parameter(description="Session identifier.") @PathParam(value="sid") @NotNull String sid) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Delete session identified by sid:{}", (Object)Util.escapeLog((Object)sid));
        }
        SessionResource.checkResourceNotNull((Object)sid, (String)"sid");
        this.sessionService.revokeSessionBySid(sid);
        return Response.ok().build();
    }

    private SessionPagedResult searchSession(SearchRequest searchReq) {
        this.logger.debug("Search Token by name params - searchReq:{} ", (Object)searchReq);
        SessionPagedResult sessionPagedResult = null;
        PagedResult<SessionId> pagedResult = this.sessionService.searchSession(searchReq);
        this.logger.debug("PagedResult  - pagedResult:{}", pagedResult);
        if (pagedResult != null) {
            this.logger.debug("Token fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
            sessionPagedResult = this.getSessionPagedResult(pagedResult);
        }
        this.logger.debug("sessionPagedResult:{} ", sessionPagedResult);
        return sessionPagedResult;
    }

    private SessionPagedResult getSessionPagedResult(PagedResult<SessionId> pagedResult) {
        SessionPagedResult sessionPagedResult = null;
        if (pagedResult != null) {
            List sessionList = pagedResult.getEntries();
            sessionPagedResult = new SessionPagedResult();
            sessionPagedResult.setStart(pagedResult.getStart());
            sessionPagedResult.setEntriesCount(pagedResult.getEntriesCount());
            sessionPagedResult.setTotalEntriesCount(pagedResult.getTotalEntriesCount());
            sessionPagedResult.setEntries(sessionList);
        }
        return sessionPagedResult;
    }

    private class SessionPagedResult
    extends PagedResult<SessionId> {
        private SessionPagedResult() {
        }
    }
}

