/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import io.jans.as.persistence.model.Scope;
import io.jans.configapi.core.util.ProtectionScopeType;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@ApplicationScoped
@Named
public class ApiProtectionCache {
    public static final int CACHE_LIFETIME = 60;
    private static final Cache<String, Scope> scopeCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private static final Cache<String, Scope> groupScopeCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private static final Cache<String, Scope> superScopeCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private static final Cache<String, Map<ProtectionScopeType, List<Scope>>> resourceCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();

    ApiProtectionCache() {
    }

    public static void removeAllScopes() {
        scopeCache.invalidateAll();
    }

    public static Scope getScope(String scopeName) {
        Preconditions.checkNotNull((Object)scopeName);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)scopeName) ? 1 : 0) != 0);
        return (Scope)scopeCache.getIfPresent((Object)scopeName);
    }

    public static void putScope(Scope scope) {
        Preconditions.checkNotNull((Object)scope);
        if (scopeCache.getIfPresent((Object)scope.getInum()) == null) {
            scopeCache.put((Object)scope.getInum(), (Object)scope);
        }
    }

    public static Map<String, Scope> getScopes() {
        return Maps.newHashMap((Map)scopeCache.asMap());
    }

    public static Scope getGroupScope(String scopeName) {
        Preconditions.checkNotNull((Object)scopeName);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)scopeName) ? 1 : 0) != 0);
        return (Scope)groupScopeCache.getIfPresent((Object)scopeName);
    }

    public static void putGroupScope(Scope scope) {
        Preconditions.checkNotNull((Object)scope);
        if (groupScopeCache.getIfPresent((Object)scope.getInum()) == null) {
            groupScopeCache.put((Object)scope.getInum(), (Object)scope);
        }
    }

    public static void removeGroupScopes() {
        groupScopeCache.invalidateAll();
    }

    public static Map<String, Scope> getGroupScopes() {
        return Maps.newHashMap((Map)groupScopeCache.asMap());
    }

    public static Scope getSuperScope(String scopeName) {
        Preconditions.checkNotNull((Object)scopeName);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)scopeName) ? 1 : 0) != 0);
        return (Scope)superScopeCache.getIfPresent((Object)scopeName);
    }

    public static void putSuperScope(Scope scope) {
        Preconditions.checkNotNull((Object)scope);
        if (superScopeCache.getIfPresent((Object)scope.getInum()) == null) {
            superScopeCache.put((Object)scope.getInum(), (Object)scope);
        }
    }

    public static void removeSuperScopes() {
        superScopeCache.invalidateAll();
    }

    public static Map<String, Scope> getSuperScopes() {
        return Maps.newHashMap((Map)superScopeCache.asMap());
    }

    public static Map<String, Scope> getAllTypesOfScopes() {
        HashMap scopes = Maps.newHashMap((Map)scopeCache.asMap());
        scopes.putAll(Maps.newHashMap((Map)groupScopeCache.asMap()));
        scopes.putAll(Maps.newHashMap((Map)superScopeCache.asMap()));
        return scopes;
    }

    public static void raemoveAllResources() {
        resourceCache.invalidateAll();
    }

    public static void putResource(String resourceName, Map<ProtectionScopeType, List<Scope>> scopeMap) {
        Preconditions.checkNotNull((Object)resourceName);
        resourceCache.put((Object)resourceName, scopeMap);
    }

    public static void putResourceScopeByType(String resourceName, ProtectionScopeType protectionScopeType, List<Scope> scopes) {
        Preconditions.checkNotNull((Object)resourceName);
        Preconditions.checkNotNull((Object)protectionScopeType);
        HashMap<ProtectionScopeType, List<Scope>> scopeMap = (HashMap<ProtectionScopeType, List<Scope>>)resourceCache.getIfPresent((Object)resourceName);
        if (scopeMap == null) {
            scopeMap = new HashMap<ProtectionScopeType, List<Scope>>();
        }
        scopeMap.put(protectionScopeType, scopes);
        resourceCache.put((Object)resourceName, scopeMap);
    }

    public static Map<String, Map<ProtectionScopeType, List<Scope>>> getAllResources() {
        return Maps.newHashMap((Map)resourceCache.asMap());
    }

    public static Map<ProtectionScopeType, List<Scope>> getResourceScopes(String resourceName) {
        Preconditions.checkNotNull((Object)resourceName);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)resourceName) ? 1 : 0) != 0);
        return (Map)resourceCache.getIfPresent((Object)resourceName);
    }

    public static List<Scope> getResourceScopeByType(String resourceName, ProtectionScopeType protectionScopeType) {
        Preconditions.checkNotNull((Object)resourceName);
        Preconditions.checkNotNull((Object)protectionScopeType);
        Map scopeMap = (Map)resourceCache.getIfPresent((Object)resourceName);
        if (scopeMap == null) {
            return Collections.emptyList();
        }
        return (List)scopeMap.get(protectionScopeType);
    }

    public static void addScope(String resourceName, ProtectionScopeType protectionScopeType, Scope scope) {
        Preconditions.checkNotNull((Object)resourceName);
        Preconditions.checkNotNull((Object)protectionScopeType);
        Preconditions.checkNotNull((Object)scope);
        switch (protectionScopeType) {
            case GROUP: {
                ApiProtectionCache.putGroupScope(scope);
                break;
            }
            case SUPER: {
                ApiProtectionCache.putSuperScope(scope);
                break;
            }
            default: {
                ApiProtectionCache.putScope(scope);
            }
        }
    }
}

