/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.jans.as.client.service.IntrospectionService;
import io.jans.as.model.common.IntrospectionResponse;
import io.jans.configapi.security.client.AuthClientFactory;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.util.AuthUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="openIdService")
public class OpenIdService
implements Serializable {
    private static final long serialVersionUID = 4564959567069741194L;
    @Inject
    transient Logger log;
    @Inject
    transient AuthUtil authUtil;
    @Inject
    transient ConfigurationService configurationService;
    private transient IntrospectionService introspectionService;

    public IntrospectionService getIntrospectionService() {
        return this.introspectionService;
    }

    public IntrospectionResponse getIntrospectionResponse(String header, String token, String issuer) throws JsonProcessingException {
        this.log.debug("oAuth Introspection request , header:{}, token:{}, issuer:{}", new Object[]{header, token, issuer});
        String introspectionUrl = this.authUtil.getIntrospectionEndpoint();
        if (StringUtils.isNotBlank((CharSequence)issuer)) {
            introspectionUrl = AuthClientFactory.getIntrospectionEndpoint(issuer);
            this.log.trace("oAuth Issuer's introspectionUrl:{}", (Object)introspectionUrl);
        }
        this.log.info("oAuth Final introspectionUrl:{} ", (Object)introspectionUrl);
        return AuthClientFactory.getIntrospectionResponse(introspectionUrl, header, token, false);
    }

    public String requestAccessToken(String clientId, List<String> scope) {
        String accessToken = this.authUtil.requestAccessToken(clientId, scope);
        this.log.info("oAuth AccessToken response - accessToken:{}", (Object)accessToken);
        return accessToken;
    }
}

