/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.ads.model.Deployment;
import io.jans.ads.model.DeploymentDetails;
import io.jans.as.model.util.Util;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.search.filter.Filter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;

@ApplicationScoped
public class AgamaDeploymentsService {
    private static final String BASE_DN = "ou=deployments,ou=agama,o=jans";
    @Inject
    private Logger logger;
    @Inject
    private PersistenceEntryManager entryManager;

    public PagedResult<Deployment> list(int start, int count, int maxCount) {
        String[] attrs = new String[]{"jansId", "jansStartDate", "jansActive", "jansEndDate", "adsPrjDeplDetails"};
        Filter filter = Filter.createPresenceFilter((String)"jansId");
        return this.entryManager.findPagedEntries(BASE_DN, Deployment.class, filter, attrs, "jansStartDate", null, start, count, maxCount);
    }

    public Deployment getDeployment(String name) {
        String[] attrs = new String[]{"jansId", "jansStartDate", "jansEndDate", "adsPrjDeplDetails"};
        this.logger.info("Looking up project named {}", (Object)name);
        Deployment d = null;
        try {
            d = (Deployment)this.entryManager.find((Object)AgamaDeploymentsService.dnOfProject(AgamaDeploymentsService.idFromName(name)), Deployment.class, attrs);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        return d;
    }

    public boolean createDeploymentTask(String name, byte[] gamaBinary, boolean autoconfigure) {
        boolean existing;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AgamaDeploymentsService::createDeploymentTask() - name:{}, gamaBinary:{}, autoconfigure:{}", new Object[]{Util.escapeLog((Object)name), Util.escapeLog((Object)gamaBinary), Util.escapeLog((Object)autoconfigure)});
        }
        Deployment d = null;
        String id = AgamaDeploymentsService.idFromName(name);
        try {
            String[] attrs = new String[]{"jansActive", "jansEndDate", "dn"};
            d = (Deployment)this.entryManager.find((Object)AgamaDeploymentsService.dnOfProject(id), Deployment.class, attrs);
        }
        catch (Exception e) {
            this.logger.debug("No already existing deployment for project {}", (Object)name);
        }
        boolean bl = existing = d != null;
        if (existing && d.getFinishedAt() == null) {
            this.logger.info("A deployment is still in course for this project!");
            if (!d.isTaskActive()) {
                this.logger.info("No node is in charge of this task yet");
            }
            return false;
        }
        DeploymentDetails dd = new DeploymentDetails();
        dd.setAutoconfigure(autoconfigure);
        dd.getProjectMetadata().setProjectName(name);
        if (!existing) {
            d = new Deployment();
            d.setDn(AgamaDeploymentsService.dnOfProject(id));
        }
        d.setId(id);
        d.setCreatedAt(new Date());
        d.setTaskActive(false);
        d.setFinishedAt(null);
        d.setDetails(dd);
        byte[] encoded = Base64.getEncoder().encode(gamaBinary);
        d.setAssets(new String(encoded, StandardCharsets.UTF_8));
        this.logger.info("Persisting deployment task for project {}", (Object)name);
        if (existing) {
            this.entryManager.merge((Object)d);
        } else {
            this.entryManager.persist((Object)d);
        }
        return true;
    }

    public Boolean createUndeploymentTask(String name) {
        String dn = AgamaDeploymentsService.dnOfProject(AgamaDeploymentsService.idFromName(name));
        String[] attrs = new String[]{"jansActive", "dn"};
        Deployment d = null;
        try {
            d = (Deployment)this.entryManager.find((Object)dn, Deployment.class, attrs);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        if (d == null) {
            return null;
        }
        boolean deploymentInProcess = d.isTaskActive();
        if (!deploymentInProcess) {
            this.logger.info("Removing deployment of project {}", (Object)name);
            this.entryManager.remove(dn, Deployment.class);
        }
        return !deploymentInProcess;
    }

    private static String dnOfProject(String prjId) {
        return String.format("jansId=%s,%s", prjId, BASE_DN);
    }

    private static String idFromName(String name) {
        return UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8)).toString();
    }
}

