/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.as.model.util.Util;
import io.jans.configapi.service.status.StatusCheckerTimer;
import io.jans.util.exception.InvalidAttributeException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AgamaRepoService {
    @Inject
    private Logger logger;
    @Inject
    private StatusCheckerTimer statusCheckerTimer;

    public JsonNode getAllAgamaRepositories() {
        return this.statusCheckerTimer.getAllAgamaRepositories();
    }

    public byte[] getAgamaProject(String downloadLink) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fetch Agama Project File from :{}", (Object)Util.escapeLog((Object)downloadLink));
        }
        if (StringUtils.isBlank((CharSequence)downloadLink)) {
            throw new InvalidAttributeException("Agama Project url is null!!!");
        }
        String url = URLDecoder.decode(downloadLink, "UTF-8");
        this.logger.info("Decoded Agama Project url :{}", (Object)url);
        return Base64.encodeBase64((byte[])IOUtils.toByteArray((InputStream)new URL(url).openStream()), (boolean)true);
    }
}

