/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.util.DataUtil;
import io.jans.configapi.service.auth.TokenService;
import io.jans.model.FieldFilterData;
import io.jans.model.SearchRequest;
import io.jans.model.token.TokenEntity;
import io.jans.model.token.TokenType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.service.CacheService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class SessionService {
    private static final String SID_MSG = "Get Session by sid:{}";
    private static final String SID_ERROR = "Failed to load session entry with sid ";
    private static final List<String> SESSION_ATTR = Arrays.asList("acr", "scope", "auth_user", "client_id", "acr_values", "redirect_uri", "response_type");
    @Inject
    private Logger logger;
    @Inject
    PersistenceEntryManager persistenceEntryManager;
    @Inject
    StaticConfiguration staticConfiguration;
    @Inject
    CacheService cacheService;
    @Inject
    TokenService tokenService;

    public String getDnForSession(String sessionId) {
        if (StringHelper.isEmpty((String)sessionId)) {
            return this.staticConfiguration.getBaseDn().getSessions();
        }
        return String.format("jansId=%s,%s", sessionId, this.staticConfiguration.getBaseDn().getSessions());
    }

    public String getDnForUser(String userInum) {
        String peopleDn = this.staticConfiguration.getBaseDn().getPeople();
        if (StringHelper.isEmpty((String)userInum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", userInum, peopleDn);
    }

    public SessionId getSessionBySid(String sid) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SID_MSG, (Object)Util.escapeLog((Object)sid));
        }
        SessionId sessionId = null;
        try {
            sessionId = this.getSession(sid);
            this.modifySession(sessionId);
        }
        catch (Exception ex) {
            this.logger.error(SID_ERROR + sid, (Throwable)ex);
        }
        return sessionId;
    }

    public List<SessionId> getAllSessions(int sizeLimit) {
        this.logger.debug("Get All Session sizeLimit:{}", (Object)sizeLimit);
        List sessionList = this.persistenceEntryManager.findEntries(this.getDnForSession(null), SessionId.class, null, sizeLimit);
        this.modifySessionList(sessionList);
        return sessionList;
    }

    public List<SessionId> getAllSessions() {
        List sessionList = this.persistenceEntryManager.findEntries(this.getDnForSession(null), SessionId.class, null);
        this.modifySessionList(sessionList);
        return sessionList;
    }

    public List<SessionId> getSessions() {
        List sessionList = this.persistenceEntryManager.findEntries(this.getDnForSession(null), SessionId.class, Filter.createGreaterOrEqualFilter((String)"exp", (Object)this.persistenceEntryManager.encodeTime(this.getDnForSession(null), new Date(System.currentTimeMillis()))), 0);
        this.logger.debug("All sessionList:{}", (Object)sessionList);
        sessionList.sort((s1, s2) -> s2.getCreationDate().compareTo(s1.getCreationDate()));
        this.logger.debug("Sorted Session sessionList:{}", (Object)sessionList);
        this.modifySessionList(sessionList);
        return sessionList;
    }

    public PagedResult<SessionId> searchSession(SearchRequest searchRequest) {
        this.logger.info("Search Session with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                this.logger.info("Session Search with assertionValue:{}", (Object)assertionValue);
                String[] targetArray = new String[]{assertionValue};
                Filter userFilter = Filter.createSubstringFilter((String)"jansUsrDN", null, (String[])targetArray, null);
                Filter sidFilter = Filter.createSubstringFilter((String)"sid", null, (String[])targetArray, null);
                Filter sessAttrFilter = Filter.createSubstringFilter((String)"jansSessAttr", null, (String[])targetArray, null);
                Filter permissionFilter = Filter.createSubstringFilter((String)"jansPermissionGrantedMap", null, (String[])targetArray, null);
                Filter idFilter = Filter.createSubstringFilter((String)"jansId", null, (String[])targetArray, null);
                filters.add(Filter.createORFilter((Filter[])new Filter[]{userFilter, sidFilter, sessAttrFilter, permissionFilter, idFilter}));
            }
            searchFilter = Filter.createORFilter(filters);
        }
        this.logger.debug("Session pattern searchFilter:{}", searchFilter);
        List fieldValueFilters = new ArrayList();
        if (searchRequest.getFieldFilterData() != null && !searchRequest.getFieldFilterData().isEmpty()) {
            List<FieldFilterData> fieldFilterDataList = this.modifyFilter(searchRequest.getFieldFilterData());
            fieldValueFilters = DataUtil.createFilter(fieldFilterDataList, (String)this.getDnForSession(null), (PersistenceEntryManager)this.persistenceEntryManager);
        }
        searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        this.logger.info("Session searchFilter:{}", (Object)searchFilter);
        PagedResult pagedSessionList = this.persistenceEntryManager.findPagedEntries(this.getDnForSession(null), SessionId.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
        if (pagedSessionList != null) {
            List<SessionId> sessionList = this.modifySessionList(pagedSessionList.getEntries());
            pagedSessionList.setEntries(sessionList);
        }
        return pagedSessionList;
    }

    public void revokeSessionTokens(String id, String sessionDn) {
        this.logger.info("Revoke session tokens for id:{}, sessionDn:{}", (Object)id, (Object)sessionDn);
        try {
            String[] tokenTypeList = new String[]{TokenType.ACCESS_TOKEN.getValue(), TokenType.ID_TOKEN.getValue()};
            List<TokenEntity> tokenList = this.tokenService.getTokenEntityBySessionDn(sessionDn, tokenTypeList);
            this.logger.info("Revoke tokens for id:{}, sessionDn:{}, tokenList:{}", new Object[]{id, sessionDn, tokenList});
            for (TokenEntity token : tokenList) {
                this.tokenService.revokeTokenEntity(token.getTokenCode());
            }
        }
        catch (Exception ex) {
            this.logger.error(" Error while revoking session token is - ", (Throwable)ex);
        }
    }

    public void revokeSessionBySid(String sid) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Delete session by sid:{}", (Object)Util.escapeLog((Object)sid));
        }
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            SessionId sessionToDelete = this.getSession(sid);
            this.logger.debug("User sessionToDelete:{}", (Object)sessionToDelete);
            if (sessionToDelete == null) {
                throw new NotFoundException("No " + SessionIdState.AUTHENTICATED + " session exists for sid '" + sid + "'!!!");
            }
            this.persistenceEntryManager.remove(sessionToDelete.getDn(), SessionId.class);
            this.cacheService.remove(sessionToDelete.getDn());
            this.revokeSessionTokens(sessionToDelete.getId(), sessionToDelete.getDn());
        }
    }

    public void revokeUserSession(String userDn) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Delete session of userDn:{}", (Object)Util.escapeLog((Object)userDn));
        }
        this.logger.info("Revoke session userDn:{}, cacheService:{}", (Object)userDn, (Object)this.cacheService);
        if (StringUtils.isNotBlank((CharSequence)userDn)) {
            Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"jansUsrDN", (Object)userDn), Filter.createEqualityFilter((String)"jansState", (Object)SessionIdState.AUTHENTICATED)});
            List sessionList = this.persistenceEntryManager.findEntries(this.getDnForSession(null), SessionId.class, filter);
            this.logger.debug("User sessionList:{}", (Object)sessionList);
            if (sessionList == null || sessionList.isEmpty()) {
                throw new NotFoundException("No " + SessionIdState.AUTHENTICATED + " session exists for user '" + userDn + "'!!!");
            }
            sessionList.stream().forEach(session -> {
                this.persistenceEntryManager.remove(session.getDn(), SessionId.class);
                this.cacheService.remove(session.getDn());
                this.revokeSessionTokens(userDn, session.getDn());
            });
        }
    }

    private SessionId modifySession(SessionId session) {
        this.logger.debug("Modify session:{}", (Object)session);
        if (session == null) {
            return session;
        }
        ArrayList<SessionId> sessionList = new ArrayList<SessionId>();
        sessionList.add(session);
        this.modifySessionList(sessionList);
        this.logger.debug("After modify session:{}", (Object)session);
        return session;
    }

    private List<SessionId> modifySessionList(List<SessionId> sessionList) {
        this.logger.debug("Modify sessionList:{}", sessionList);
        if (sessionList == null || sessionList.isEmpty()) {
            return sessionList;
        }
        for (SessionId session : sessionList) {
            this.excludeAttribute(session);
        }
        this.logger.debug("After modification sessionList:{}", sessionList);
        return sessionList;
    }

    private SessionId getSession(String sid) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SID_MSG, (Object)Util.escapeLog((Object)sid));
        }
        SessionId sessionId = null;
        try {
            List sessionList = this.persistenceEntryManager.findEntries(this.getDnForSession(null), SessionId.class, Filter.createEqualityFilter((String)"sid", (Object)sid));
            if (sessionList != null && !sessionList.isEmpty()) {
                sessionId = (SessionId)sessionList.get(0);
            }
        }
        catch (Exception ex) {
            this.logger.error(SID_ERROR + sid, (Throwable)ex);
        }
        return sessionId;
    }

    private SessionId excludeAttribute(SessionId session) {
        if (session == null) {
            return session;
        }
        session.setId(null);
        session.setDn(null);
        session.getSessionAttributes().put("session_id", null);
        session.getSessionAttributes().put("old_session_id", null);
        return session;
    }

    private List<FieldFilterData> modifyFilter(List<FieldFilterData> fieldFilterDataList) {
        this.logger.debug("Modify filter - fieldFilterDataList:{}", fieldFilterDataList);
        if (fieldFilterDataList == null || fieldFilterDataList.isEmpty()) {
            return fieldFilterDataList;
        }
        for (FieldFilterData fieldFilterData : fieldFilterDataList) {
            String field;
            if (fieldFilterData == null || !StringUtils.isNotBlank((CharSequence)fieldFilterData.getField()) || StringUtils.isBlank((CharSequence)(field = fieldFilterData.getField()))) continue;
            if ("jansUsrDN".equalsIgnoreCase(field)) {
                fieldFilterData.setValue(this.getDnForUser(fieldFilterData.getValue()));
                continue;
            }
            if (!SESSION_ATTR.contains(field)) continue;
            fieldFilterData.setField("jansSessAttr." + field);
        }
        this.logger.info("After modification of session filter - fieldFilterDataList:{}", fieldFilterDataList);
        return fieldFilterDataList;
    }
}

