/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.conf;

import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.model.configuration.ApiConf;
import io.jans.orm.PersistenceEntryManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@ApplicationScoped
public class ConfigApiService {
    @Inject
    @Named(value="persistenceEntryManager")
    PersistenceEntryManager persistenceManager;
    @Inject
    ConfigurationFactory configurationFactory;

    public ApiConf findApiConf() {
        String dn = this.configurationFactory.getApiAppConfigurationDn();
        return (ApiConf)this.persistenceManager.find((Object)dn, ApiConf.class, null);
    }

    public void merge(ApiConf apiConf) {
        apiConf.setRevision(apiConf.getRevision() + 1L);
        this.persistenceManager.merge((Object)apiConf);
    }

    public ApiAppConfiguration find() {
        ApiConf apiConf = this.findApiConf();
        return apiConf.getDynamicConf();
    }
}

