/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.test.auth;

import io.jans.configapi.ConfigServerBaseTest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class AssetResourceTest
extends ConfigServerBaseTest {
    private static final String INVALID_SCOPE = "https://jans.io/oauth/config/attributes.readonly";
    private static final String ASSET_READ_ACCESS_SCOPE = "https://jans.io/oauth/config/asset.readonly";
    private static final String ASSET_ADMIN_SCOPE = "https://jans.io/oauth/config/asset.admin";

    @Parameters(value={"test.issuer", "assetUrl"})
    @Test
    public void getAssetsUsingInvalidToken(String issuer, String assetUrl) {
        this.log.info("getAssetsUsingInvalidToken() - accessToken:{}, issuer:{}, assetUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)assetUrl);
        String invalidToken = this.getAccessTokenForGivenScope(INVALID_SCOPE);
        this.log.info("getAssetsUsingInvalidToken() - invalidToken:{}, issuer:{}, assetUrl:{}", (Object)invalidToken, (Object)issuer, (Object)assetUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + assetUrl);
        request.header("Authorization", (Object)("Bearer " + invalidToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getAssetsUsingInvalidToken() -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode());
    }

    @Parameters(value={"test.issuer", "assetUrl"})
    @Test
    public void getAssetsUsingReadScope(String issuer, String assetUrl) {
        this.log.info("getAssetsUsingReadScope() - accessToken:{}, issuer:{}, assetUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)assetUrl);
        String readToken = this.getAccessTokenForGivenScope(ASSET_READ_ACCESS_SCOPE);
        this.log.info("getAssetsUsingReadScope() - readToken:{}, issuer:{}, assetUrl:{}", (Object)readToken, (Object)issuer, (Object)assetUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + assetUrl);
        request.header("Authorization", (Object)("Bearer " + readToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getAssetsUsingReadScope() -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "assetUrl"})
    @Test
    public void getAssets(String issuer, String assetUrl) {
        this.log.info("getAssets() - accessToken:{}, issuer:{}, assetUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)assetUrl);
        String adminToken = this.getAccessTokenForGivenScope(ASSET_ADMIN_SCOPE);
        this.log.info("getAssets() - adminToken:{}, issuer:{}, assetUrl:{}", (Object)adminToken, (Object)issuer, (Object)assetUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + assetUrl);
        request.header("Authorization", (Object)("Bearer " + adminToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getAssets() -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }
}

