/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.test.auth;

import io.jans.configapi.ConfigServerBaseTest;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class ClientResourceTest
extends ConfigServerBaseTest {
    @Parameters(value={"test.issuer", "openidClientsUrl"})
    @Test
    public void getAllClient(String issuer, String openidClientsUrl) {
        this.log.info("getAllClient() - accessToken:{}, issuer:{}, openidClientsUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)openidClientsUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + openidClientsUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getAllClient -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }

    @Parameters(value={"test.issuer", "openidClientsUrl"})
    @Test
    public void getClientsWithInvalidToken(String issuer, String openidClientsUrl) {
        this.log.info("getAllClient() - issuer:{}, openidClientsUrl:{}", (Object)issuer, (Object)openidClientsUrl);
        String invalidToken = this.getAccessTokenForGivenScope("https://jans.io/oauth/config/attributes.readonly");
        this.log.info("getAllClient() - invalidToken:{}, issuer:{}, openidClientsUrl:{}", (Object)invalidToken, (Object)issuer, (Object)openidClientsUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + openidClientsUrl);
        request.header("Authorization", (Object)("Bearer " + invalidToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getClientsWithInvalidToken -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode());
    }

    @Parameters(value={"test.issuer", "openidClientsUrl", "openid_client_1"})
    @Test
    public void postClient(String issuer, String openidClientsUrl, String json) {
        this.log.info("\n\n\n postClient2 - accessToken:{}, issuer:{}, openidClientsUrl:{}, json:{}", (Object)this.accessToken, (Object)issuer, (Object)openidClientsUrl, (Object)json);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + openidClientsUrl);
        request.header("Authorization", (Object)("Bearer " + this.accessToken));
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.post(Entity.entity((Object)json, (String)"application/json"));
        this.log.info("post client -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        if (response.getStatus() == 201) {
            this.log.trace("Response for postClient -  response.getEntity():{}, response.getClass():{}", response.getEntity(), response.getClass());
        }
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode());
    }
}

