/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.test.auth;

import io.jans.configapi.ConfigServerBaseTest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class StatResourceTest
extends ConfigServerBaseTest {
    private static final String INVALID_SCOPE = "https://jans.io/oauth/config/attributes.readonly";
    private static final String SUPER_ADMIN_SCOPE = "https://jans.io/oauth/config/stats.admin";

    @Parameters(value={"test.issuer", "statUrl"})
    @Test
    public void getStatsInvalidToken(String issuer, String statUrl) {
        this.log.info("getStatsInvalidToken() - accessToken:{}, issuer:{}, statUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)statUrl);
        String invalidToken = this.getAccessTokenForGivenScope(INVALID_SCOPE);
        this.log.info("getStatsInvalidToken() - invalidToken:{}, issuer:{}, statUrl:{}", (Object)invalidToken, (Object)issuer, (Object)statUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + statUrl);
        request.header("Authorization", (Object)("Bearer " + invalidToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getStatsInvalidToken() - response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode());
    }

    @Parameters(value={"test.issuer", "statUrl"})
    @Test
    public void getStats(String issuer, String statUrl) {
        this.log.info("getStats() - accessToken:{}, issuer:{}, statUrl:{}", (Object)this.accessToken, (Object)issuer, (Object)statUrl);
        String adminToken = this.getAccessTokenForGivenScope(SUPER_ADMIN_SCOPE);
        this.log.info("getStats() - adminToken:{}, issuer:{}, statUrl:{}", (Object)adminToken, (Object)issuer, (Object)statUrl);
        Invocation.Builder request = this.getResteasyService().getClientBuilder(issuer + statUrl);
        request.header("Authorization", (Object)("Bearer " + adminToken));
        request.header("Content-Type", (Object)"application/json");
        Response response = request.get();
        this.log.info("Response for getStats() -  response:{}, response.getStatus():{}", (Object)response, (Object)response.getStatus());
        Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
    }
}

