/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.configuration;

import io.jans.as.model.config.Conf;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.configuration.Configuration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.model.configuration.ApiConf;
import io.jans.configapi.model.configuration.CorsConfiguration;
import io.jans.configapi.model.configuration.CorsConfigurationFilter;
import io.jans.exception.ConfigurationException;
import io.jans.exception.OxIntializationException;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.orm.util.properties.FileConfiguration;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.BaseConfigurationReload;
import io.jans.service.cdi.event.ConfigurationEvent;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import io.jans.util.security.PropertiesDecrypter;
import io.jans.util.security.SecurityProviderUtility;
import io.jans.util.security.StringEncrypter;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class ConfigurationFactory {
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private Event<AppConfiguration> authConfigurationUpdateEvent;
    @Inject
    private Event<ApiAppConfiguration> apiConfigurationUpdateEvent;
    @Inject
    private Event<String> event;
    @Inject
    @Named(value="persistenceEntryManager")
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private Instance<Configuration> configurationInstance;
    public static final String PERSISTENCE_CONFIGUARION_RELOAD_EVENT_TYPE = "persistenceConfigurationReloadEvent";
    public static final String BASE_CONFIGURATION_RELOAD_EVENT_TYPE = "baseConfigurationReloadEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private AtomicBoolean isActive;
    private long baseConfigurationFileLastModifiedTime;
    private static final String BASE_DIR = System.getProperty("jans.base") != null ? System.getProperty("jans.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String BASE_PROPERTIES_FILE = DIR + "jans.properties";
    private static final String APP_PROPERTIES_FILE = DIR + "jans-auth.properties";
    private static final String SALT_FILE_NAME = "salt";
    private AppConfiguration appConfiguration;
    private StaticConfiguration staticConf;
    private WebKeysConfiguration jwks;
    private ErrorResponseFactory errorResponseFactory;
    private PersistenceConfiguration persistenceConfiguration;
    private FileConfiguration baseConfiguration;
    private String cryptoConfigurationSalt;
    private String saltFilePath;
    private boolean authConfigloaded = false;
    private long authLoadedRevision = -1L;
    public static final String CONFIGAPI_CONFIGURATION_ENTRY = "configApi_ConfigurationEntryDN";
    private ApiAppConfiguration apiAppConfiguration;
    private CorsConfigurationFilter corsConfigurationFilter;
    private boolean apiConfigloaded = false;
    private long apiLoadedRevision = -1L;
    private String apiProtectionType;
    private String apiClientId;
    private String apiClientPassword;
    private List<String> apiApprovedIssuer;
    private boolean configOauthEnabled;

    @Produces
    @ApplicationScoped
    public AppConfiguration getAppConfiguration() {
        return this.appConfiguration;
    }

    @Produces
    @ApplicationScoped
    public ApiAppConfiguration getApiAppConfiguration() {
        return this.apiAppConfiguration;
    }

    @Produces
    @ApplicationScoped
    public CorsConfigurationFilter getCorsConfigurationFilters() {
        return this.corsConfigurationFilter;
    }

    @Produces
    @ApplicationScoped
    public CorsConfiguration getCorsConfiguration() {
        try {
            if (this.corsConfigurationFilter != null) {
                CorsConfiguration corsConfiguration = new CorsConfiguration();
                corsConfiguration.parseAndStore(this.corsConfigurationFilter.getCorsEnabled().toString(), this.corsConfigurationFilter.getCorsAllowedOrigins(), this.corsConfigurationFilter.getCorsAllowedMethods(), this.corsConfigurationFilter.getCorsAllowedHeaders(), this.corsConfigurationFilter.getCorsExposedHeaders(), this.corsConfigurationFilter.getCorsSupportCredentials().toString(), Long.toString(this.corsConfigurationFilter.getCorsPreflightMaxAge().intValue()), this.corsConfigurationFilter.getCorsRequestDecorate().toString());
                this.log.debug("Initializing CorsConfiguration:{} ", (Object)corsConfiguration);
                return corsConfiguration;
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to initialize  CorsConfiguration" + this.corsConfigurationFilter);
        }
        return null;
    }

    @Produces
    @ApplicationScoped
    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    @Produces
    @ApplicationScoped
    public StaticConfiguration getStaticConf() {
        return this.staticConf;
    }

    @Produces
    @ApplicationScoped
    public WebKeysConfiguration getJwks() {
        return this.jwks;
    }

    @Produces
    @ApplicationScoped
    public ErrorResponseFactory getErrorResponseFactory() {
        return this.errorResponseFactory;
    }

    @Produces
    @ApplicationScoped
    public StringEncrypter getStringEncrypter() throws OxIntializationException {
        if (StringHelper.isEmpty((String)this.cryptoConfigurationSalt)) {
            throw new OxIntializationException("Encode salt isn't defined");
        }
        try {
            return StringEncrypter.instance((String)this.cryptoConfigurationSalt);
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new OxIntializationException("Failed to create StringEncrypter instance", (Throwable)ex);
        }
    }

    public FileConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    public static String getAppPropertiesFile() {
        return APP_PROPERTIES_FILE;
    }

    public String getApiProtectionType() {
        return this.apiProtectionType;
    }

    public String getApiClientId() {
        return this.apiClientId;
    }

    public String getApiClientPassword() {
        return this.apiClientPassword;
    }

    public List<String> getApiApprovedIssuer() {
        return this.apiApprovedIssuer;
    }

    public boolean isConfigOauthEnabled() {
        return this.configOauthEnabled;
    }

    public void setConfigOauthEnabled(boolean configOauthEnabled) {
        this.configOauthEnabled = configOauthEnabled;
    }

    @PostConstruct
    public void init() {
        this.log.info("Initializing ConfigurationFactory ");
        this.isActive = new AtomicBoolean(true);
        try {
            this.persistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(APP_PROPERTIES_FILE);
            this.loadBaseConfiguration();
            this.saltFilePath = this.confDir() + SALT_FILE_NAME;
            this.loadCryptoConfigurationSalt();
            this.installSecurityProvider();
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void create() {
        this.log.info("Loading Configuration");
        if (!this.loadApiConfigFromDb()) {
            this.log.error("Failed to load api configuration from persistence. Please fix it!!!.");
            throw new ConfigurationException("Failed to load api configuration from persistence.");
        }
        this.log.info("Api Configuration loaded successfully - apiLoadedRevision:{}, ApiAppConfiguration:{}", (Object)this.apiLoadedRevision, (Object)this.getApiAppConfiguration());
        if (!this.loadAuthConfigFromDb()) {
            this.log.error("Failed to load auth configuration from persistence. Please fix it!!!.");
            throw new ConfigurationException("Failed to load auth configuration from persistence.");
        }
        this.log.info("Auth Configuration loaded successfully - authLoadedRevision:{}", (Object)this.authLoadedRevision);
    }

    public String getAuthConfigurationDn() {
        return this.baseConfiguration.getString("jansAuth_ConfigurationEntryDN");
    }

    public String getApiAppConfigurationDn() {
        return this.baseConfiguration.getString(CONFIGAPI_CONFIGURATION_ENTRY);
    }

    public String getConfigurationDn(String key) {
        return this.baseConfiguration.getString(key);
    }

    private void loadBaseConfiguration() {
        this.log.info("Loading base configuration - BASE_PROPERTIES_FILE:{}", (Object)BASE_PROPERTIES_FILE);
        this.baseConfiguration = this.createFileConfiguration(BASE_PROPERTIES_FILE);
        this.baseConfigurationFileLastModifiedTime = new File(BASE_PROPERTIES_FILE).lastModified();
        this.log.debug("Loaded base configuration:{}", (Object)this.baseConfiguration.getProperties());
    }

    private String confDir() {
        String confDir = this.baseConfiguration.getString("confDir", null);
        if (StringUtils.isNotBlank((CharSequence)confDir)) {
            return confDir;
        }
        return DIR;
    }

    private FileConfiguration createFileConfiguration(String fileName) {
        try {
            return new FileConfiguration(fileName);
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
            }
            throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
        }
    }

    private boolean loadAuthConfigFromDb() {
        this.log.debug("Loading Auth configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            Conf c = this.loadConfigurationFromDb(this.getConfigurationDn("jansAuth_ConfigurationEntryDN"), new Conf(), new String[0]);
            this.log.trace("Auth configuration '{}' DB...", (Object)c);
            if (c != null) {
                this.initAuthConf(c);
                if (this.authConfigloaded) {
                    this.destroy(AppConfiguration.class);
                }
                this.authConfigloaded = true;
                this.authConfigurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)this.appConfiguration);
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to find auth configuration in DB " + ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private boolean loadApiConfigFromDb() {
        this.log.debug("Loading Api configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            ApiConf apiConf = this.loadConfigurationFromDb(this.getConfigurationDn(CONFIGAPI_CONFIGURATION_ENTRY), new ApiConf(), new String[0]);
            this.log.trace("ApiConf configuration '{}' DB...", (Object)apiConf);
            if (apiConf != null) {
                this.initApiAuthConf(apiConf);
                if (this.apiConfigloaded) {
                    this.destroy(ApiAppConfiguration.class);
                }
                this.apiConfigloaded = true;
                this.apiConfigurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)this.apiAppConfiguration);
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to find api configuration in DB..." + ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private void initApiAuthConf(ApiConf apiConf) {
        this.log.debug("Initializing Api App Configuration From DB.... apiConf:{}", (Object)apiConf);
        if (apiConf == null) {
            throw new ConfigurationException("Failed to load Api App Configuration From DB " + apiConf);
        }
        this.log.info("ApiAppConfigurationFromDb = ....");
        if (apiConf.getDynamicConf() != null) {
            this.apiAppConfiguration = apiConf.getDynamicConf();
        }
        this.apiLoadedRevision = apiConf.getRevision();
        this.log.debug("*** ConfigurationFactory::loadApiAppConfigurationFromDb() - apiAppConfiguration:{}, apiLoadedRevision:{} ", (Object)this.apiAppConfiguration, (Object)this.apiLoadedRevision);
        this.setApiConfigurationProperties();
    }

    private void setApiConfigurationProperties() {
        this.log.info("setApiConfigurationProperties");
        if (this.apiAppConfiguration == null) {
            throw new ConfigurationException("Failed to load Configuration properties " + this.apiAppConfiguration);
        }
        this.log.debug("*** ConfigurationFactory::setApiConfigurationProperties() - this.apiAppConfiguration:{}", (Object)this.apiAppConfiguration);
        this.apiApprovedIssuer = this.apiAppConfiguration.getApiApprovedIssuer();
        this.apiProtectionType = this.apiAppConfiguration.getApiProtectionType();
        this.apiClientId = this.apiAppConfiguration.getApiClientId();
        this.apiClientPassword = this.apiAppConfiguration.getApiClientPassword();
        this.configOauthEnabled = this.apiAppConfiguration.isConfigOauthEnabled();
        if (this.apiAppConfiguration.getCorsConfigurationFilters() != null && !this.apiAppConfiguration.getCorsConfigurationFilters().isEmpty()) {
            this.corsConfigurationFilter = this.apiAppConfiguration.getCorsConfigurationFilters().stream().filter(x -> "CorsFilter".equals(x.getFilterName())).findAny().orElse(null);
        }
        this.log.debug("Properties set, this.apiApprovedIssuer:{}, , this.apiProtectionType:{}, this.apiClientId :{}, this.apiClientPassword:{}, this.corsConfigurationFilter:{}, this.configOauthEnabled:{} ", new Object[]{this.apiApprovedIssuer, this.apiProtectionType, this.apiClientId, this.apiClientPassword, this.corsConfigurationFilter, this.configOauthEnabled});
        CorsConfiguration corsConfiguration = this.getCorsConfiguration();
        this.log.debug("CorsConfiguration Produced :{} ", (Object)corsConfiguration);
        this.getCorsConfigurationFilters();
    }

    private <T> T loadConfigurationFromDb(String dn, T obj, String ... returnAttributes) {
        this.log.debug("loadConfigurationFromDb dn:{}, clazz:{}, returnAttributes:{}", new Object[]{dn, obj, returnAttributes});
        PersistenceEntryManager persistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        try {
            return (T)persistenceEntryManager.find((Object)dn, obj.getClass(), returnAttributes);
        }
        catch (BasePersistenceException ex) {
            this.log.error(ex.getMessage());
            return null;
        }
    }

    private void initAuthConf(Conf conf) {
        this.initAuthConfiguration(conf);
        this.authLoadedRevision = conf.getRevision();
    }

    private void initAuthConfiguration(Conf conf) {
        if (conf.getDynamic() != null) {
            this.appConfiguration = conf.getDynamic();
            this.log.trace("Auth Config - appConfiguration: {}", (Object)this.appConfiguration);
        }
        if (conf.getStatics() != null) {
            this.staticConf = conf.getStatics();
        }
        if (conf.getWebKeys() != null) {
            this.jwks = conf.getWebKeys();
        }
        if (conf.getErrors() != null) {
            this.errorResponseFactory = new ErrorResponseFactory(conf.getErrors(), conf.getDynamic());
        }
    }

    private boolean isAuthRevisionIncreased() {
        Conf persistenceConf = this.loadConfigurationFromDb(this.getConfigurationDn("jansAuth_ConfigurationEntryDN"), new Conf(), "jansRevision");
        if (persistenceConf == null) {
            return false;
        }
        this.log.debug("Auth Config - DB revision: {}, server revision: {}", (Object)persistenceConf.getRevision(), (Object)this.authLoadedRevision);
        return persistenceConf.getRevision() > this.authLoadedRevision;
    }

    private boolean isApiRevisionIncreased() {
        ApiConf apiConf = this.loadConfigurationFromDb(this.getConfigurationDn(CONFIGAPI_CONFIGURATION_ENTRY), new ApiConf(), "jansRevision");
        if (apiConf == null) {
            return false;
        }
        this.log.debug("Api Config - DB revision: {}, server revision: {}", (Object)apiConf.getRevision(), (Object)this.apiLoadedRevision);
        return apiConf.getRevision() > this.apiLoadedRevision;
    }

    private void loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath);
            this.cryptoConfigurationSalt = cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            }
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    public Properties getDecryptedConnectionProperties() throws OxIntializationException {
        FileConfiguration persistenceConfig = this.persistenceConfiguration.getConfiguration();
        Properties connectionProperties = persistenceConfig.getProperties();
        if (connectionProperties == null || connectionProperties.isEmpty()) {
            return connectionProperties;
        }
        return PropertiesDecrypter.decryptAllProperties((StringEncrypter)this.getStringEncrypter(), (Properties)connectionProperties);
    }

    private void installSecurityProvider() {
        try {
            SecurityProviderUtility.installBCProvider();
        }
        catch (Exception ex) {
            this.log.error("Failed to install BC provider properly", (Throwable)ex);
        }
    }

    public boolean reloadAuthConfFromLdap() {
        this.log.debug("Reload auth configuration TimerEvent");
        if (!this.isAuthRevisionIncreased()) {
            return false;
        }
        return this.loadAuthConfigFromDb();
    }

    public boolean reloadApiConfFromLdap() {
        this.log.debug("Reload api configuration TimerEvent");
        if (!this.isApiRevisionIncreased()) {
            return false;
        }
        return this.loadApiConfigFromDb();
    }

    public void destroy(Class<? extends Configuration> clazz) {
        Instance confInstance = this.configurationInstance.select(clazz, new Annotation[0]);
        this.configurationInstance.destroy((Object)((Configuration)confInstance.get()));
    }

    public void initTimer() {
        this.log.debug("Initializing Configuration Timer");
        int delay = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new ConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled ConfigurationEvent configurationEvent) {
        long lastModified;
        this.log.debug("Config reload configuration TimerEvent - baseConfigurationFileLastModifiedTime:{}", (Object)this.baseConfigurationFileLastModifiedTime);
        File baseConf = new File(BASE_PROPERTIES_FILE);
        if (baseConf.exists() && (lastModified = baseConf.lastModified()) > this.baseConfigurationFileLastModifiedTime) {
            this.loadBaseConfiguration();
            this.event.select(new Annotation[]{BaseConfigurationReload.Literal.INSTANCE}).fire((Object)BASE_CONFIGURATION_RELOAD_EVENT_TYPE);
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadAuthConfFromLdap();
            this.reloadApiConfFromLdap();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while reloading application configuration", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }
}

