/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.interceptor;

import io.jans.configapi.core.interceptor.RequestAuditInterceptor;
import io.jans.configapi.core.rest.BaseResource;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.model.configuration.AuditLogConf;
import io.jans.configapi.model.configuration.ObjectDetails;
import io.jans.configapi.util.AuthUtil;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Interceptor
@RequestAuditInterceptor
@Priority(value=2000)
public class AuditLogInterceptor {
    private static final Logger LOG = LogManager.getLogger(AuditLogInterceptor.class);
    private static final Logger AUDIT_LOG = LogManager.getLogger((String)"audit");
    @Inject
    AuthUtil authUtil;
    @Inject
    ApiAppConfiguration apiAppConfiguration;

    @AroundInvoke
    public Object aroundReadFrom(InvocationContext context) throws Exception {
        try {
            if (this.apiAppConfiguration.isDisableAuditLogger()) {
                AUDIT_LOG.error("Audit is disabled by disableAuditLogger config.");
                return context.proceed();
            }
            HttpServletRequest request = ((BaseResource)context.getTarget()).getHttpRequest();
            HttpHeaders httpHeaders = ((BaseResource)context.getTarget()).getHttpHeaders();
            UriInfo uriInfo = ((BaseResource)context.getTarget()).getUriInfo();
            AuditLogConf auditLogConf = this.getAuditLogConf();
            String method = request.getMethod();
            LOG.trace(" method:{}, ignoreMethod(method, auditLogConf):{}, ignoreAnnotation(method, auditLogConf):{}", (Object)method, (Object)this.ignoreHttpMethod(method, auditLogConf), (Object)this.ignoreAnnotation(method, auditLogConf));
            if (auditLogConf.isEnabled() && !this.ignoreHttpMethod(method, auditLogConf)) {
                String client = httpHeaders.getHeaderString("jans-client");
                String userInum = httpHeaders.getHeaderString("User-inum");
                AUDIT_LOG.error("User:{} {} {} using client:{}", (Object)userInum, (Object)this.getAction(method), (Object)this.getResource(uriInfo.getPath()), (Object)client);
                if (auditLogConf.isLogData()) {
                    this.processRequest(context, auditLogConf);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Not able to log audit details due to error:{}", (Throwable)ex);
        }
        return context.proceed();
    }

    private void processRequest(InvocationContext context, AuditLogConf auditLogConf) {
        LOG.info("Process Audit Log Interceptor - context:{}, auditLogConf:{}", (Object)context, (Object)auditLogConf);
        Object[] ctxParameters = context.getParameters();
        Method method = context.getMethod();
        int paramCount = method.getParameterCount();
        Parameter[] parameters = method.getParameters();
        Class<?>[] clazzArray = method.getParameterTypes();
        LOG.trace("Processing  Data -  paramCount:{} , parameters:{}, clazzArray:{} ", (Object)paramCount, (Object)parameters, clazzArray);
        HttpServletRequest request = ((BaseResource)context.getTarget()).getHttpRequest();
        this.getRequestObject(request);
        if (clazzArray != null && clazzArray.length > 0) {
            for (int i = 0; i < clazzArray.length; ++i) {
                Class<?> clazz = clazzArray[i];
                String propertyName = parameters[i].getName();
                String propertyValue = parameters[i].toString();
                LOG.trace("propertyName:{}, propertyValue:{}, clazz:{} , clazz.isPrimitive():{} ", (Object)propertyName, (Object)propertyValue, clazz, (Object)clazz.isPrimitive());
                Object obj = ctxParameters[i];
                if (obj == null || obj.toString().toUpperCase().contains("PASSWORD") && obj.toString().toUpperCase().contains("SECRET")) continue;
                LOG.trace("ignoreObject(propertyName, obj, auditLogConf):{} ", (Object)this.ignoreObject(propertyName, obj, auditLogConf));
                AUDIT_LOG.error("{}:{}", (Object)propertyName, obj);
            }
        }
    }

    private AuditLogConf getAuditLogConf() {
        return this.authUtil.getAuditLogConf();
    }

    private boolean ignoreHttpMethod(String method, AuditLogConf auditLogConf) {
        LOG.debug("Checking if method to be ignored - method:{}, auditLogConf:{}", (Object)method, (Object)auditLogConf);
        if (StringUtils.isBlank((CharSequence)method) || auditLogConf == null || auditLogConf.getIgnoreHttpMethod() == null || auditLogConf.getIgnoreHttpMethod().isEmpty()) {
            return false;
        }
        return auditLogConf.getIgnoreHttpMethod().contains(method);
    }

    private boolean ignoreAnnotation(String resourceMethod, AuditLogConf auditLogConf) {
        LOG.trace("Checking if resource method to be ignored - resourceMethod:{}, auditLogConf:{}", (Object)resourceMethod, (Object)auditLogConf);
        if (StringUtils.isBlank((CharSequence)resourceMethod) || auditLogConf == null || auditLogConf.getIgnoreAnnotation() == null || auditLogConf.getIgnoreAnnotation().isEmpty()) {
            return false;
        }
        return auditLogConf.getIgnoreAnnotation().contains(resourceMethod);
    }

    private boolean ignoreObject(String objectName, Object objectValue, AuditLogConf auditLogConf) {
        LOG.trace("Checking if object to be ignored - objectName:{}, objectValue:{}, auditLogConf:{}", (Object)objectName, objectValue, (Object)auditLogConf);
        if (StringUtils.isBlank((CharSequence)objectName) || auditLogConf == null || auditLogConf.getIgnoreObjectMapping() == null || auditLogConf.getIgnoreObjectMapping().isEmpty()) {
            return false;
        }
        ObjectDetails objectDetails = auditLogConf.getIgnoreObjectMapping().stream().filter(e -> e != null && e.getName() != null && e.getName().equalsIgnoreCase(objectName)).findFirst().orElse(null);
        if (objectDetails == null) {
            return false;
        }
        LOG.trace("objectName:{}, objectValue:{}, objectDetails:{}, objectDetails.getText():{}, objectDetails.getText().contains(objectValue.toString()):{}", (Object)objectName, objectValue, (Object)objectDetails, (Object)objectDetails.getText(), (Object)objectDetails.getText().contains(objectValue.toString()));
        if (objectName.equalsIgnoreCase(objectDetails.getName())) {
            if (objectDetails.getText() == null || objectDetails.getText().isEmpty()) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)objectValue.toString()) && objectDetails.getText() != null && objectDetails.getText().contains(objectValue.toString())) {
                return true;
            }
        }
        return false;
    }

    private String getAction(String method) {
        String action = null;
        if (StringUtils.isNotBlank((CharSequence)method)) {
            switch (method) {
                case "POST": {
                    action = "added";
                    break;
                }
                case "PUT": 
                case "PATCH": {
                    action = "changed";
                    break;
                }
                case "DELETE": {
                    action = "deleted";
                    break;
                }
                default: {
                    action = "fetched";
                }
            }
        }
        return action;
    }

    private String getResource(String path) {
        LOG.trace(" path:{} ", (Object)path);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            path = path.replace("/", "-");
        }
        return path;
    }

    public HttpServletRequest getRequestObject(HttpServletRequest request) {
        if (request == null) {
            return request;
        }
        try {
            ServletInputStream inputStream = request.getInputStream();
            LOG.debug("inputStream.available():{}", (Object)inputStream.available());
            if (inputStream.available() > 0) {
                byte[] requestEntity = inputStream.readAllBytes();
                StringBuilder stringBuilder = new StringBuilder(new String(requestEntity)).append("\n");
                LOG.debug((CharSequence)stringBuilder);
            }
        }
        catch (Exception ex) {
            LOG.error(" Error while reading data - ", (Throwable)ex);
        }
        return request;
    }
}

