/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.interceptor;

import io.jans.configapi.core.interceptor.RequestInterceptor;
import io.jans.configapi.core.util.DataUtil;
import io.jans.configapi.model.configuration.DataFormatConversionConf;
import io.jans.configapi.service.auth.AttributeService;
import io.jans.configapi.util.AuthUtil;
import io.jans.model.JansAttribute;
import io.jans.model.attribute.AttributeDataType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.model.AttributeData;
import io.jans.orm.reflect.property.Getter;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.reflect.property.Setter;
import io.jans.orm.reflect.util.ReflectHelper;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@RequestInterceptor
@Priority(value=2000)
public class RequestReaderInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RequestReaderInterceptor.class);
    @Context
    UriInfo info;
    @Context
    HttpServletRequest request;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    AuthUtil authUtil;
    @Inject
    AttributeService attributeService;
    @Inject
    PersistenceEntryManager persistenceEntryManager;

    @AroundInvoke
    public Object aroundReadFrom(InvocationContext context) throws Exception {
        logger.debug(" Request Interceptor info:{}, request:{}, httpHeaders:{}, resourceInfo:{}, persistenceEntryManager:{}, getDataFormatConversionConf():{}, isDataFormatConversionEnaled():{}, isIgnoreMethod(context):{}", new Object[]{this.info, this.request, this.httpHeaders, this.resourceInfo, this.persistenceEntryManager, this.getDataFormatConversionConf(), this.isDataFormatConversionEnaled(), this.isIgnoreMethod(context)});
        try {
            if (this.isDataFormatConversionEnaled() && !this.isIgnoreMethod(context)) {
                logger.debug("=======================  DataType Conversion Start ============================");
                this.processRequest(context);
                logger.debug("=======================  DataType Conversion End ============================");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("Exception while data conversion:{}", (Object)ex.getMessage());
        }
        return context.proceed();
    }

    private void processRequest(InvocationContext context) {
        logger.debug(" Process Request Data -  context:{} , context.getClass():{}, context.getContextData():{}, context.getMethod():{} , context.getParameters():{} , context.getTarget():{} ", new Object[]{context, context.getClass(), context.getContextData(), context.getMethod(), context.getParameters(), context.getTarget()});
        Object[] ctxParameters = context.getParameters();
        logger.debug(" Request  Parameters -  ctxParameters:{} ", ctxParameters);
        Method method = context.getMethod();
        int paramCount = method.getParameterCount();
        Parameter[] parameters = method.getParameters();
        Class<?>[] clazzArray = method.getParameterTypes();
        logger.debug("Parameter  Data -  paramCount:{} , parameters:{}, clazzArray:{} ", new Object[]{paramCount, parameters, clazzArray});
        if (clazzArray != null && clazzArray.length > 0) {
            for (int i = 0; i < clazzArray.length; ++i) {
                Class<?> clazz = clazzArray[i];
                String propertyName = parameters[i].getName();
                logger.debug("propertyName:{}, clazz:{} , clazz.isPrimitive():{} ", new Object[]{propertyName, clazz, clazz.isPrimitive()});
                Object obj = ctxParameters[i];
                if (clazz.isPrimitive() || obj == null) continue;
                this.processCustomAttributes(obj);
                logger.debug("Request object post processing -  propertyName:{}, obj:{} ", (Object)propertyName, obj);
            }
        }
    }

    private <T> void processCustomAttributes(T obj) {
        logger.debug("Object for custom attribute obj:{}", obj);
        Class<?> entryClass = obj.getClass();
        List propertiesAnnotations = this.persistenceEntryManager.getEntryPropertyAnnotations(entryClass);
        logger.debug("propertiesAnnotations:{}", (Object)propertiesAnnotations);
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            try {
                String propertyName = propertiesAnnotation.getPropertyName();
                Annotation ldapAttribute = ReflectHelper.getAnnotationByType((List)propertiesAnnotation.getAnnotations(), AttributesList.class);
                logger.debug("Custom attributes - ldapAttribute:{}", (Object)ldapAttribute);
                if (ldapAttribute == null) continue;
                List listAttributes = this.persistenceEntryManager.getAttributeDataListFromCustomAttributesList(obj, (AttributesList)ldapAttribute, propertyName);
                logger.debug("Custom AttributesList before conversion listAttributes:{}", (Object)listAttributes);
                this.processAttributeData(obj, propertyName, ldapAttribute, listAttributes);
                logger.debug("Custom AttributesList after conversion listAttributes:{}", (Object)listAttributes);
            }
            catch (Exception ex) {
                logger.error("Error while processing Custom Attributes", (Throwable)ex);
            }
        }
    }

    private List<AttributeData> processAttributeData(Object obj, String propertyName, Annotation ldapAttribute, List<AttributeData> listAttributes) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        logger.debug("Attribute Data for processing obj:{}, propertyName:{}, ldapAttribute:{}, listAttributes:{}", new Object[]{obj, propertyName, ldapAttribute, listAttributes});
        if (listAttributes != null && !listAttributes.isEmpty()) {
            for (AttributeData attData : listAttributes) {
                logger.debug("AttributeData - attData:{}", (Object)attData);
                JansAttribute jansAttribute = this.attributeService.getByLdapName(attData.getName());
                logger.debug("AttributeData details - attData.getName():{}, attData.getValue():{},jansAttribute:{}", new Object[]{attData.getName(), attData.getValue(), jansAttribute});
                if (attData.getValue() == null || jansAttribute == null) continue;
                AttributeDataType attributeDataType = jansAttribute.getDataType();
                logger.debug("AttributeDataType - attData.getName():{}, attributeDataType:{}, AttributeDataType.DATE.getValue():{}", new Object[]{attData.getName(), attributeDataType, AttributeDataType.DATE.getValue()});
                if (!AttributeDataType.DATE.getValue().equalsIgnoreCase(attributeDataType.getValue())) continue;
                logger.debug(" Calling decodeTime() - attData.getValue():{}", attData.getValue());
                AttributeData attributeData = this.decodeTime(attData);
                listAttributes.remove(attData);
                listAttributes.add(attributeData);
            }
            logger.debug("Getting updated custom attribute list for propertyName:{} , listAttributes:{} ", (Object)propertyName, listAttributes);
            List data = this.persistenceEntryManager.getCustomAttributesListFromAttributeDataList(obj, (AttributesList)ldapAttribute, propertyName, listAttributes);
            logger.debug("updated custom attribute data:{}", (Object)data);
            logger.debug("Setting the custom attribute in request object propertyName:{}, data:{} ", (Object)propertyName, (Object)data);
            this.setObjectData(obj, propertyName, data);
            logger.debug("After setting the custom attribute in request object propertyName:{}, data:{} ", (Object)propertyName, (Object)data);
        }
        return listAttributes;
    }

    private AttributeData decodeTime(AttributeData attributeData) {
        logger.debug("Date data to decode attributeData:{}", (Object)attributeData);
        AttributeData atrData = attributeData;
        if (atrData == null || atrData.getValue() == null) {
            return atrData;
        }
        Object attValue = atrData.getValue();
        if (attValue != null) {
            Date date = this.authUtil.parseStringToDateObj(attValue.toString());
            logger.debug(" Date data to decode date:{}", (Object)date);
            if (date != null) {
                date = this.persistenceEntryManager.decodeTime(null, date.toString());
                logger.debug(" Set decoded date atrData.getName():{}, date:{}", (Object)atrData.getName(), (Object)date);
                atrData = new AttributeData(atrData.getName(), (Object)date);
                atrData.setMultiValued(attributeData.getMultiValued());
            }
        }
        return atrData;
    }

    private void setObjectData(Object obj, String propertyName, Object propertyValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        logger.debug("Data to set new value - obj:{}, propertyName:{}, propertyValue:{}", new Object[]{obj, propertyName, propertyValue});
        Setter setterMethod = DataUtil.getSetterMethod(obj.getClass(), (String)propertyName);
        propertyValue = setterMethod.getMethod().invoke(obj, propertyValue);
        logger.debug("After setterMethod invoked key:{}, propertyValue:{} ", (Object)propertyName, propertyValue);
        Getter getterMethod = DataUtil.getGetterMethod(obj.getClass(), (String)propertyName);
        propertyValue = getterMethod.get(obj);
        logger.debug("Verify new value key:{}, propertyValue:{} ", (Object)propertyName, propertyValue);
    }

    private DataFormatConversionConf getDataFormatConversionConf() {
        logger.debug("authUtil.getDataFormatConversionConf():{}", (Object)this.authUtil.getDataFormatConversionConf());
        return this.authUtil.getDataFormatConversionConf();
    }

    private boolean isDataFormatConversionEnaled() {
        DataFormatConversionConf dataFormatConversionConf = this.getDataFormatConversionConf();
        if (dataFormatConversionConf == null) {
            return false;
        }
        logger.debug("dataFormatConversionConf:{}, dataFormatConversionConf.isEnabled():{}", (Object)dataFormatConversionConf, (Object)dataFormatConversionConf.isEnabled());
        return dataFormatConversionConf.isEnabled();
    }

    private boolean isIgnoreMethod(InvocationContext context) {
        logger.debug("Checking if method to be ignored");
        if (context.getMethod().getAnnotations() == null || context.getMethod().getAnnotations().length <= 0) {
            return false;
        }
        for (int i = 0; i < context.getMethod().getAnnotations().length; ++i) {
            DataFormatConversionConf dataFormatConversionConf = this.getDataFormatConversionConf();
            if (dataFormatConversionConf == null) {
                return false;
            }
            logger.debug("====== Verifying  - dataFormatConversionConf:{}, context.getMethod().getAnnotations()[i]:{} ", (Object)dataFormatConversionConf, (Object)context.getMethod().getAnnotations()[i]);
            if (context.getMethod().getAnnotations()[i] == null || dataFormatConversionConf.getIgnoreHttpMethod() == null || !dataFormatConversionConf.getIgnoreHttpMethod().contains(context.getMethod().getAnnotations()[i].toString())) continue;
            return true;
        }
        return false;
    }
}

