/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.ads.model.Deployment;
import io.jans.config.GluuConfiguration;
import io.jans.configapi.core.model.ApiError;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.rest.model.AuthenticationMethod;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AgamaDeploymentsService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.configapi.service.auth.LdapConfigurationService;
import io.jans.model.custom.script.model.CustomScript;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.jans.orm.model.PagedResult;
import io.jans.service.custom.CustomScriptService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/acrs")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AcrsResource
extends ConfigBaseResource {
    private static final String AGAMA_PREFIX = "agama_";
    private static final String AGAMA_PREFIX_SEPERATOR = "_";
    @Inject
    Logger log;
    @Inject
    private ApiAppConfiguration appConfiguration;
    @Inject
    ConfigurationService configurationService;
    @Inject
    CustomScriptService customScriptService;
    @Inject
    AgamaDeploymentsService agamaDeploymentsService;
    @Inject
    LdapConfigurationService ldapConfigurationService;

    @Operation(summary="Gets default authentication method.", description="Gets default authentication method.", operationId="get-acrs", tags={"Default Authentication Method"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/acrs.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/acrs.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/acrs.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationMethod.class), examples={@ExampleObject(name="Response example", value="example/acr/acr.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/acrs.readonly"}, groupScopes={"https://jans.io/oauth/config/acrs.write"}, superScopes={"https://jans.io/oauth/config/acrs.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getDefaultAuthenticationMethod() {
        GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
        AuthenticationMethod authenticationMethod = new AuthenticationMethod();
        authenticationMethod.setDefaultAcr(gluuConfiguration.getAuthenticationMode());
        return Response.ok((Object)authenticationMethod).build();
    }

    @Operation(summary="Updates default authentication method.", description="Updates default authentication method.", operationId="put-acrs", tags={"Default Authentication Method"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/acrs.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/acrs.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationMethod.class), examples={@ExampleObject(name="Request json example", value="example/acr/acr.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationMethod.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="BadRequestException"))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="Unauthorized"))}), @ApiResponse(responseCode="500", description="InternalServerError", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiError.class, description="InternalServerError"))})})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/acrs.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/acrs.admin", "https://jans.io/oauth/config/write-all"})
    public Response updateDefaultAuthenticationMethod(@NotNull AuthenticationMethod authenticationMethod) {
        this.log.info("ACRS details to  update - authenticationMethod:{}", (Object)authenticationMethod);
        if (authenticationMethod == null || StringUtils.isBlank((CharSequence)authenticationMethod.getDefaultAcr())) {
            AcrsResource.throwBadRequestException((String)"Default authentication method should not be null or empty !");
        }
        if (authenticationMethod != null && StringUtils.isNotBlank((CharSequence)authenticationMethod.getDefaultAcr())) {
            this.validateAuthenticationMethod(authenticationMethod.getDefaultAcr());
            GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
            gluuConfiguration.setAuthenticationMode(authenticationMethod.getDefaultAcr());
            this.configurationService.merge(gluuConfiguration);
        }
        return Response.ok((Object)authenticationMethod).build();
    }

    private void validateAuthenticationMethod(String authenticationMode) {
        this.log.debug("authenticationMethod:{}, appConfiguration.isAcrValidationEnabled():{}", (Object)authenticationMode, (Object)this.appConfiguration.isAcrValidationEnabled());
        boolean isAcrValid = this.isAcrValid(authenticationMode);
        this.log.debug("isAcrValid:{}", (Object)isAcrValid);
        if (this.appConfiguration.isAcrValidationEnabled() && !isAcrValid) {
            AcrsResource.throwBadRequestException((String)"INVALID_ACR", (String)String.format("Authentication script {%s} is not valid/active", authenticationMode));
        }
    }

    private boolean isAcrValid(String authenticationMode) {
        GluuLdapConfiguration ldap;
        Optional<GluuLdapConfiguration> matchingLdapConfiguration;
        boolean isValid = false;
        this.log.info(" Validate ACR being set - authenticationMethod:{}, appConfiguration.getAcrExclusionList():{}", (Object)authenticationMode, (Object)this.appConfiguration.getAcrExclusionList());
        if (this.appConfiguration.getAcrExclusionList() != null && this.appConfiguration.getAcrExclusionList().contains(authenticationMode)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)authenticationMode) && authenticationMode.startsWith(AGAMA_PREFIX)) {
            this.log.debug(" Agama authenticationMethod provided.");
            return this.isValidAgamaDeployment(authenticationMode);
        }
        List<GluuLdapConfiguration> ldapConfigurations = this.ldapConfigurationService.findLdapConfigurations();
        this.log.debug(" ldapConfigurations:{}", ldapConfigurations);
        if (ldapConfigurations != null && !ldapConfigurations.isEmpty() && (matchingLdapConfiguration = ldapConfigurations.stream().filter(d -> d.getConfigId().equals(authenticationMode)).findFirst()).isPresent() && (ldap = matchingLdapConfiguration.get()) != null) {
            return true;
        }
        CustomScript script = this.customScriptService.getScriptByDisplayName(authenticationMode);
        this.log.debug(" CustomScript:{}", (Object)script);
        if (script != null && script.isEnabled()) {
            this.log.debug(" script:{}, script.isEnabled():{}", (Object)script, (Object)script.isEnabled());
            return true;
        }
        this.log.debug(" isValid:{}", (Object)isValid);
        return isValid;
    }

    public boolean isValidAgamaDeployment(String authenticationMode) {
        boolean isValid = false;
        this.log.info(" Validate Agama ACR - authenticationMode:{},", (Object)authenticationMode);
        if (StringUtils.isBlank((CharSequence)authenticationMode)) {
            return isValid;
        }
        PagedResult<Deployment> deploymentPagedResult = this.agamaDeploymentsService.list(0, 0, this.getMaxCount());
        this.log.info(" Agama Deployments - deploymentPagedResult:{},", deploymentPagedResult);
        if (deploymentPagedResult != null && deploymentPagedResult.getEntries() != null && !deploymentPagedResult.getEntries().isEmpty()) {
            List agamaDeploymentList = deploymentPagedResult.getEntries();
            this.log.debug(" agamaDeploymentList:{},", (Object)agamaDeploymentList);
            Set<String> keys = this.getDirectLaunchFlows(agamaDeploymentList);
            this.log.info("Final DirectLaunchFlows - keys:{}, authenticationMode:{}, authenticationMode.indexOf(AGAMA_PREFIX_SEPERATOR):{} , authenticationMode.indexOf(AGAMA_PREFIX_SEPERATOR)+1:{}", new Object[]{keys, authenticationMode, authenticationMode.indexOf(AGAMA_PREFIX_SEPERATOR), authenticationMode.indexOf(AGAMA_PREFIX_SEPERATOR) + 1});
            String agamaAcr = authenticationMode;
            if (authenticationMode.indexOf(AGAMA_PREFIX_SEPERATOR) > 0) {
                agamaAcr = authenticationMode.substring(authenticationMode.indexOf(AGAMA_PREFIX_SEPERATOR) + 1);
            }
            this.log.info(" agamaAcr:{},", (Object)agamaAcr);
            if (!keys.isEmpty() && keys.contains(agamaAcr)) {
                this.log.debug(" keys.contains(agamaAcr):{},", (Object)keys.contains(agamaAcr));
                isValid = true;
            }
        }
        this.log.info(" isValidAgamaDeployment - isValid:{}", (Object)isValid);
        return isValid;
    }

    private Set<String> getDirectLaunchFlows(List<Deployment> agamaDeploymentList) {
        this.log.info(" agamaDeploymentList:{}", agamaDeploymentList);
        HashSet<String> keys = new HashSet<String>();
        ArrayList noDirectLaunchFlows = new ArrayList();
        if (agamaDeploymentList == null || agamaDeploymentList.isEmpty()) {
            return keys;
        }
        for (Deployment deployment : agamaDeploymentList) {
            this.log.info("Agama deployment:{}, deployment.getId():{},", (Object)deployment, (Object)deployment.getId());
            if (deployment.getDetails() == null || deployment.getDetails().getFlowsError() == null) continue;
            keys.addAll(deployment.getDetails().getFlowsError().keySet());
            this.log.info("\n Agama flow keys:{},", keys);
            if (deployment.getDetails().getProjectMetadata() == null || deployment.getDetails().getProjectMetadata().getNoDirectLaunchFlows() == null) continue;
            noDirectLaunchFlows.addAll(deployment.getDetails().getProjectMetadata().getNoDirectLaunchFlows());
        }
        this.log.info("\n All deployed agama keys:{}, noDirectLaunchFlows:{}", keys, noDirectLaunchFlows);
        if (!keys.isEmpty() && !noDirectLaunchFlows.isEmpty()) {
            keys.removeAll(noDirectLaunchFlows);
        }
        this.log.info("Final agama main flow keys:{}", keys);
        return keys;
    }
}

