/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AgamaRepoService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/agama-repo")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AgamaRepoResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    private ApiAppConfiguration appConfiguration;
    @Inject
    ConfigurationService configurationService;
    @Inject
    AgamaRepoService agamaRepoService;

    @Operation(summary="Gets all agama repositories.", description="Gets all agama repositories.", operationId="get-agama-repositories", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama-repo.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama-repo.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Agama repositories", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class), examples={@ExampleObject(name="Response json example", value="example/agama/agama-repo-get.json")})}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama-repo.readonly"}, groupScopes={"https://jans.io/oauth/config/agama-repo.write"}, superScopes={"https://jans.io/oauth/config/agama.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Produces(value={"application/json"})
    public Response getAllAgamaRepositories() {
        return Response.ok((Object)this.agamaRepoService.getAllAgamaRepositories()).build();
    }

    @Operation(summary="Download agama project.", description="Download agama project.", operationId="get-agama-project", tags={"Agama"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama-repo.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama-repo.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Agama project", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class, format="binary"))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama-repo.readonly"}, groupScopes={"https://jans.io/oauth/config/agama-repo.write"}, superScopes={"https://jans.io/oauth/config/agama.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Produces(value={"text/plain"})
    @Path(value="/download")
    public Response getAgamaProject(@Parameter(description="Agama project download Link") @QueryParam(value="downloadLink") String downloadLink) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" Agama Project File downloadLink :{}", (Object)Util.escapeLog((Object)downloadLink));
        }
        return Response.ok((Object)this.agamaRepoService.getAgamaProject(downloadLink)).build();
    }
}

