/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.agama.dsl.Transpiler;
import io.jans.agama.dsl.TranspilerException;
import io.jans.agama.dsl.error.SyntaxException;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/agama")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AgamaResource
extends ConfigBaseResource {
    @Operation(summary="Determine if the text passed is valid Agama code", description="Determine if the text passed is valid Agama code", operationId="agama-syntax-check", tags={"Agama - Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/agama.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Agama Syntax Check message", content={@Content(mediaType="application/json", schema=@Schema(implementation=Exception.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @Consumes(value={"text/plain"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/agama.readonly"}, groupScopes={"https://jans.io/oauth/config/agama.write"}, superScopes={"https://jans.io/oauth/config/agama.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/syntax-check/{qname}")
    public Response doSyntaxCheck(@Parameter(description="Agama Flow name") @PathParam(value="qname") String qname, String source) {
        Throwable e = null;
        try {
            Transpiler.runSyntaxCheck((String)qname, (String)source);
            e = new TranspilerException("");
        }
        catch (TranspilerException | SyntaxException te) {
            this.logger.info("Syntax check failed");
            e = te;
        }
        e.setStackTrace(new StackTraceElement[0]);
        return Response.ok().entity((Object)e).build();
    }
}

