/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.configapi.core.model.ClientAuth;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ClientAuthService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Set;

@Path(value="/clients/authorizations")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ApplicationScoped
public class ClientAuthResource
extends ConfigBaseResource {
    @Inject
    ClientAuthService clientAuthService;

    @Operation(summary="Gets list of client authorization", description="Gets list of client authorizations", operationId="get-client-authorization", tags={"Client Authorization"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/client/authorizations.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/client/authorizations.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(schema=@Schema(implementation=ClientAuth.class), examples={@ExampleObject(name="Response json example", value="example/client-auth/client-auth-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/client/authorizations.readonly"}, groupScopes={}, superScopes={"https://jans.io/oauth/client/authorizations.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="{userId}")
    public Response getClientAuthorization(@Parameter(description="User identifier") @PathParam(value="userId") @NotNull String userId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Client Authorization serach param - userId:{}", (Object)Util.escapeLog((Object)userId));
        }
        Map<Client, Set<Scope>> clientAuths = this.clientAuthService.getUserAuthorizations(userId);
        this.logger.info("Client serach param - clientAuths:{}", clientAuths);
        ClientAuth clientAuth = new ClientAuth();
        clientAuth.setClientAuths(clientAuths);
        return Response.ok((Object)clientAuth).build();
    }

    @Operation(summary="Revoke client authorization", description="Revoke client authorizations", operationId="delete-client-authorization", tags={"Client Authorization"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/client/authorizations.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/client/authorizations.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/delete-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/client/authorizations.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/client/authorizations.admin", "https://jans.io/oauth/config/delete-all"})
    @Path(value="{userId}/{clientId}/{username}")
    public Response deleteClientAuthorization(@Parameter(description="User identifier") @PathParam(value="userId") @NotNull String userId, @Parameter(description="Client identifier") @PathParam(value="clientId") @NotNull String clientId, @Parameter(description="User name") @PathParam(value="username") @NotNull String userName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ClientAuthorization to be deleted for - userId:{}, clientId:{}, userName:{}", new Object[]{Util.escapeLog((Object)userId), Util.escapeLog((Object)clientId), Util.escapeLog((Object)userName)});
        }
        this.clientAuthService.removeClientAuthorizations(userId, clientId, userName);
        this.logger.info("ClientAuthorizations removed!!!");
        return Response.noContent().build();
    }
}

