/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.model.configuration.ApiAppConfiguration;
import io.jans.configapi.model.configuration.ApiConf;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.conf.ConfigApiService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/api-config")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConfigApiResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    ConfigApiService configApiService;

    @Operation(summary="Gets config-api configuration properties.", description="Gets config-api configuration properties.", operationId="get-config-api-properties", tags={"Configuration \u2013 Config API"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/properties.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/properties.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/properties.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiAppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/properties.readonly"}, groupScopes={"https://jans.io/oauth/config/properties.write"}, superScopes={"https://jans.io/oauth/config/properties.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getAppConfiguration() {
        ApiAppConfiguration appConfiguration = this.configApiService.find();
        this.log.debug("Config API Configuration:{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }

    @Operation(summary="Partially modifies config-api configuration properties.", description="Partially modifies config-api Configuration properties.", operationId="patch-config-api-properties", tags={"Configuration \u2013 Config API"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/properties.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/properties.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/config/config-api-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiAppConfiguration.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/properties.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/properties.admin", "https://jans.io/oauth/config/write-all"})
    public Response patchAppConfigurationProperty(@NotNull String jsonPatchString) throws JsonPatchException, IOException {
        this.log.debug("Config API - jsonPatchString:{} ", (Object)jsonPatchString);
        ApiConf conf = this.configApiService.findApiConf();
        ApiAppConfiguration appConfiguration = (ApiAppConfiguration)Jackson.applyPatch((String)jsonPatchString, (Object)conf.getDynamicConf());
        conf.setDynamicConf(appConfiguration);
        this.configApiService.merge(conf);
        appConfiguration = this.configApiService.find();
        this.log.debug("Config-api post patch - appConfiguration:{}", (Object)appConfiguration);
        return Response.ok((Object)appConfiguration).build();
    }
}

