/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.common.service.common.ConfigurationService;
import io.jans.config.GluuConfiguration;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.model.SmtpConfiguration;
import io.jans.model.SmtpTest;
import io.jans.service.EncryptionService;
import io.jans.service.MailService;
import io.jans.util.security.StringEncrypter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="/config/smtp")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConfigSmtpResource
extends ConfigBaseResource {
    private static final String SMTP_CONFIGURATION = "smtpConfiguration";
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private MailService mailService;

    @Operation(summary="Returns SMTP server configuration", description="Returns SMTP server configuration", operationId="get-config-smtp", tags={"Configuration \u2013 SMTP"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SmtpConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/smtp/smtp-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/smtp.readonly"}, groupScopes={"https://jans.io/oauth/config/smtp.write"}, superScopes={"https://jans.io/oauth/config/smtp.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getSmtpServerConfiguration() throws StringEncrypter.EncryptionException {
        SmtpConfiguration smtpConfiguration = this.configurationService.getConfiguration().getSmtpConfiguration();
        this.log.info("smtpConfiguration:{} from DB", (Object)smtpConfiguration);
        this.decryptPassword(smtpConfiguration);
        this.log.info("smtpConfiguration:{} fetched", (Object)smtpConfiguration);
        return Response.ok((Object)smtpConfiguration).build();
    }

    @Operation(summary="Adds SMTP server configuration", description="Adds SMTP server configuration", operationId="post-config-smtp", tags={"Configuration \u2013 SMTP"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="SmtpConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=SmtpConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/auth/smtp/smtp.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=SmtpConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/smtp/smtp-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/smtp.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/smtp.admin", "https://jans.io/oauth/config/write-all"})
    public Response setupSmtpConfiguration(@Valid SmtpConfiguration smtpConfiguration) throws StringEncrypter.EncryptionException {
        this.log.debug("smtpConfiguration:{}", (Object)smtpConfiguration);
        this.encryptPassword(smtpConfiguration);
        GluuConfiguration configurationUpdate = this.configurationService.getConfiguration();
        this.log.debug("configurationUpdate:{}", (Object)configurationUpdate);
        configurationUpdate.setSmtpConfiguration(smtpConfiguration);
        this.configurationService.updateConfiguration(configurationUpdate);
        smtpConfiguration = this.configurationService.getConfiguration().getSmtpConfiguration();
        this.decryptPassword(smtpConfiguration);
        this.log.debug("After creeation smtpConfiguration:{}", (Object)smtpConfiguration);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)smtpConfiguration).build();
    }

    @Operation(summary="Updates SMTP server configuration", description="Updates SMTP server configuration", operationId="put-config-smtp", tags={"Configuration \u2013 SMTP"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="SmtpConfiguration object", content={@Content(mediaType="application/json", schema=@Schema(implementation=SmtpConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/auth/smtp/smtp.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=SmtpConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/smtp/smtp-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/smtp.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/smtp.admin", "https://jans.io/oauth/config/write-all"})
    public Response updateSmtpConfiguration(@Valid SmtpConfiguration smtpConfiguration) throws StringEncrypter.EncryptionException {
        this.log.debug("smtpConfiguration:{}", (Object)smtpConfiguration);
        this.encryptPassword(smtpConfiguration);
        GluuConfiguration configurationUpdate = this.configurationService.getConfiguration();
        this.log.debug("configurationUpdate:{}", (Object)configurationUpdate);
        configurationUpdate.setSmtpConfiguration(smtpConfiguration);
        this.configurationService.updateConfiguration(configurationUpdate);
        smtpConfiguration = this.configurationService.getConfiguration().getSmtpConfiguration();
        this.decryptPassword(smtpConfiguration);
        this.log.debug("After update smtpConfiguration:{}", (Object)smtpConfiguration);
        return Response.ok((Object)smtpConfiguration).build();
    }

    @Operation(summary="Signing Test SMTP server configuration", description="Signing Test SMTP server configuration", operationId="test-config-smtp", tags={"Configuration \u2013 SMTP"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="SmtpTest object", content={@Content(mediaType="application/json", schema=@Schema(implementation=SmtpTest.class), examples={@ExampleObject(name="Request json example", value="example/auth/smtp/smtp_test.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(name="status", type="boolean", description="boolean value true if successful"))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @Path(value="/test")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/smtp.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/smtp.admin", "https://jans.io/oauth/config/write-all"})
    public Response testSmtpConfiguration(@Valid SmtpTest smtpTest) throws StringEncrypter.EncryptionException {
        this.log.debug("smtpTest:{}", (Object)smtpTest);
        SmtpConfiguration smtpConfiguration = this.configurationService.getConfiguration().getSmtpConfiguration();
        smtpConfiguration.setSmtpAuthenticationAccountPasswordDecrypted(this.encryptionService.decrypt(smtpConfiguration.getSmtpAuthenticationAccountPassword()));
        smtpConfiguration.setKeyStorePasswordDecrypted(this.encryptionService.decrypt(smtpConfiguration.getKeyStorePassword()));
        boolean status = false;
        if (smtpTest.getSign()) {
            this.log.debug("smtpTest: trying to send signed email");
            status = this.mailService.sendMailSigned(smtpConfiguration.getFromEmailAddress(), smtpConfiguration.getFromName(), smtpConfiguration.getFromEmailAddress(), null, smtpTest.getSubject(), smtpTest.getMessage(), smtpTest.getMessage());
        } else {
            this.log.debug("smtpTest: trying to send non-signed email");
            status = this.mailService.sendMail(smtpConfiguration.getFromEmailAddress(), smtpConfiguration.getFromName(), smtpConfiguration.getFromEmailAddress(), null, smtpTest.getSubject(), smtpTest.getMessage(), smtpTest.getMessage());
        }
        this.log.info("smtpConfiguration test status:{}", (Object)status);
        return Response.ok((Object)status).build();
    }

    @Operation(summary="Deletes SMTP server configuration", description="Deletes SMTP server configuration", operationId="delete-config-smtp", tags={"Configuration \u2013 SMTP"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/smtp.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/delete-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/config/smtp.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/smtp.admin", "https://jans.io/oauth/config/delete-all"})
    public Response removeSmtpConfiguration() {
        GluuConfiguration configurationUpdate = this.configurationService.getConfiguration();
        configurationUpdate.setSmtpConfiguration(new SmtpConfiguration());
        this.configurationService.updateConfiguration(configurationUpdate);
        return Response.noContent().build();
    }

    private SmtpConfiguration encryptPassword(SmtpConfiguration smtpConfiguration) throws StringEncrypter.EncryptionException {
        if (smtpConfiguration == null) {
            return smtpConfiguration;
        }
        String password = smtpConfiguration.getSmtpAuthenticationAccountPassword();
        if (password != null && !password.isEmpty()) {
            try {
                this.encryptionService.decrypt(password);
            }
            catch (Exception ex) {
                this.log.error("Exception while decryption of smtpConfiguration password hence will encrypt it!!!");
                smtpConfiguration.setSmtpAuthenticationAccountPassword(this.encryptionService.encrypt(password));
            }
        }
        if ((password = smtpConfiguration.getKeyStorePassword()) != null && !password.isEmpty()) {
            try {
                this.encryptionService.decrypt(password);
            }
            catch (Exception ex) {
                this.log.error("Exception while decryption of smtpConfiguration password hence will encrypt it!!!");
                smtpConfiguration.setKeyStorePassword(this.encryptionService.encrypt(password));
            }
        }
        return smtpConfiguration;
    }

    private SmtpConfiguration decryptPassword(SmtpConfiguration smtpConfiguration) throws StringEncrypter.EncryptionException {
        if (smtpConfiguration != null) {
            String password = smtpConfiguration.getSmtpAuthenticationAccountPassword();
            if (password != null && !password.isEmpty()) {
                smtpConfiguration.setSmtpAuthenticationAccountPasswordDecrypted(this.encryptionService.decrypt(password));
            }
            if ((password = smtpConfiguration.getKeyStorePassword()) != null && !password.isEmpty()) {
                smtpConfiguration.setKeyStorePasswordDecrypted(this.encryptionService.decrypt(password));
            }
        } else {
            smtpConfiguration = new SmtpConfiguration();
        }
        return smtpConfiguration;
    }
}

