/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.model.util.Util;
import io.jans.config.GluuConfiguration;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ConfigurationService;
import io.jans.model.ScriptLocationType;
import io.jans.model.SearchRequest;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.model.CustomScript;
import io.jans.orm.model.PagedResult;
import io.jans.service.custom.CustomScriptService;
import io.jans.util.StringHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

@Path(value="/config/scripts")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomScriptResource
extends ConfigBaseResource {
    private static final String CUSTOM_FILE_SCRIPT_DEFAULT_LOCATION = "/opt/jans/jetty/jans-auth/custom/script/";
    private static final String CUSTOM_SCRIPT = "custom script";
    private static final String PATH_SEPARATOR = "/";
    @Inject
    CustomScriptService customScriptService;
    @Inject
    ConfigurationService configurationService;

    @Operation(summary="Gets a list of custom scripts", description="Gets a list of custom scripts", operationId="get-config-scripts", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.readonly"}, groupScopes={"https://jans.io/oauth/config/scripts.write"}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getAllCustomScripts(@Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="adminCanEdit=true,dataType=string")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Search Custom Script filters with limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.customScriptService.baseDn(), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, CustomScript.class);
        return Response.ok(this.doSearch(searchReq, null)).build();
    }

    @Operation(summary="Fetch custom script by name", description="Fetch custom script by name", operationId="get-custom-script-by-name", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="CustomScript", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScript.class), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-by-name.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/name/{name}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.readonly"}, groupScopes={"https://jans.io/oauth/config/scripts.write"}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getCustomScriptByName(@Parameter(description="Script name") @PathParam(value="name") @NotNull String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Custom Script to be fetched based on type - name:{} ", (Object)Util.escapeLog((Object)name));
        }
        CustomScript customScript = this.customScriptService.getScriptByDisplayName(name);
        CustomScriptResource.checkResourceNotNull((Object)customScript, (String)CUSTOM_SCRIPT);
        this.logger.debug("Custom Script Fetched based on name:{}, customScript:{}", (Object)name, (Object)customScript);
        return Response.ok((Object)customScript).build();
    }

    @Operation(summary="Gets list of scripts by type", description="Gets list of scripts by type", operationId="get-config-scripts-by-type", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-by-type.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/type/{type}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.readonly"}, groupScopes={"https://jans.io/oauth/config/scripts.write"}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getCustomScriptsByTypePattern(@Parameter(description="Script type") @PathParam(value="type") @NotNull String type, @Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="adminCanEdit=true,dataType=string")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Custom Script to be fetched based on type - type:{}, limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)type), Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.customScriptService.baseDn(), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, CustomScript.class);
        return Response.ok(this.doSearch(searchReq, CustomScriptType.getByValue((String)type.toLowerCase()))).build();
    }

    @Operation(summary="Gets a script by Inum", description="Gets a script by Inum", operationId="get-config-scripts-by-inum", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScript.class), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-by-id.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/inum/{inum}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.readonly"}, groupScopes={"https://jans.io/oauth/config/scripts.write"}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getCustomScriptByInum(@Parameter(description="Script identifier") @PathParam(value="inum") @NotNull String inum) {
        CustomScript script;
        block3: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Custom Script to be fetched - inum:{} ", (Object)Util.escapeLog((Object)inum));
            }
            script = null;
            try {
                script = this.customScriptService.getScriptByInum(inum);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!ex.getMessage().contains("Failed to find entry")) break block3;
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        this.logger.debug("Custom Script fetched by inum :{}", (Object)script);
        return Response.ok((Object)script).build();
    }

    @Operation(summary="Adds a new custom script", description="Adds a new custom script", operationId="post-config-scripts", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="CustomScript object", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScript.class), examples={@ExampleObject(name="Request json example", value="example/auth/scripts/scripts.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScript.class), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-response.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/write-all"})
    public Response createScript(@Valid CustomScript customScript, @Parameter(description="Boolean flag to indicate if script template is to be added. If CustomScript request object has script populated then script template will not be added.") @DefaultValue(value="false") @QueryParam(value="addScriptTemplate") boolean addScriptTemplate) {
        this.logger.info("Custom Script to create - customScript:{}, addScriptTemplate:{}", (Object)customScript, (Object)addScriptTemplate);
        Objects.requireNonNull(customScript, "Attempt to create null custom script");
        String inum = customScript.getInum();
        if (StringHelper.isEmpty((String)inum)) {
            inum = UUID.randomUUID().toString();
        }
        this.logger.info("Custom Script to create - StringUtils.isBlank(customScript.getScript()):{}, addScriptTemplate:{}", (Object)StringUtils.isBlank((CharSequence)customScript.getScript()), (Object)addScriptTemplate);
        if (StringUtils.isBlank((CharSequence)customScript.getScript()) && !addScriptTemplate) {
            this.logger.info("\n Default Script Template is not added!!!");
            customScript.setScript("");
        }
        this.validateScriptLocationType(customScript);
        this.updateRevision(customScript, null);
        customScript.setDn(this.customScriptService.buildDn(inum));
        customScript.setInum(inum);
        this.customScriptService.add(customScript);
        this.logger.debug("Custom Script added {}", (Object)customScript);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)customScript).build();
    }

    @Operation(summary="Updates a custom script", description="Updates a custom script", operationId="put-config-scripts", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="CustomScript object", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScript.class), examples={@ExampleObject(name="Request json example", value="example/auth/scripts/scripts.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScript.class), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-response.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/write-all"})
    public Response updateScript(@Valid @NotNull CustomScript customScript) {
        this.logger.debug("Custom Script to update - customScript:{}", (Object)customScript);
        CustomScript existingScript = this.customScriptService.getScriptByInum(customScript.getInum());
        CustomScriptResource.checkResourceNotNull((Object)existingScript, (String)CUSTOM_SCRIPT);
        customScript.setInum(existingScript.getInum());
        this.updateRevision(customScript, existingScript);
        this.logger.debug("Custom Script to be updated {}", (Object)customScript);
        this.customScriptService.update(customScript);
        this.logger.debug("Check if script is enabled:{}", (Object)existingScript.isEnabled());
        if (!existingScript.isEnabled()) {
            this.updateAuthenticationMethod(existingScript);
        }
        return Response.ok((Object)customScript).build();
    }

    @Operation(summary="Deletes a custom script", description="Deletes a custom script", operationId="delete-config-scripts-by-inum", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/delete-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="{inum}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/delete-all"})
    public Response deleteScript(@Parameter(description="Script identifier") @PathParam(value="inum") @NotNull String inum) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Custom Script Resource to delete - inum:{}", (Object)Util.escapeLog((Object)inum));
            }
            CustomScript existingScript = this.customScriptService.getScriptByInum(inum);
            this.customScriptService.remove(existingScript);
            if (existingScript != null) {
                this.updateAuthenticationMethod(existingScript);
            }
            return Response.noContent().build();
        }
        catch (Exception ex) {
            this.logger.info("Error deleting script by inum " + inum, (Throwable)ex);
            throw new NotFoundException(CustomScriptResource.getNotFoundError((String)CUSTOM_SCRIPT));
        }
    }

    @Operation(summary="Patches a custom script", description="Patches a custom script", operationId="patch-config-scripts-by-inum", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="JsonPatch object", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/auth/scripts/scripts-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScript.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/write-all"})
    @Path(value="{inum}")
    public Response patchScript(@Parameter(description="Script identifier") @PathParam(value="inum") @NotNull String inum, @NotNull String pathString) throws JsonPatchException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Custom Script Resource to patch - inum:{} , pathString:{}", (Object)Util.escapeLog((Object)inum), (Object)Util.escapeLog((Object)pathString));
        }
        CustomScript existingScript = this.customScriptService.getScriptByInum(inum);
        CustomScriptResource.checkResourceNotNull((Object)existingScript, (String)CUSTOM_SCRIPT);
        existingScript = (CustomScript)Jackson.applyPatch((String)pathString, (Object)existingScript);
        this.updateRevision(existingScript, existingScript);
        this.customScriptService.update(existingScript);
        existingScript = this.customScriptService.getScriptByInum(inum);
        if (!existingScript.isEnabled()) {
            this.updateAuthenticationMethod(existingScript);
        }
        this.logger.debug(" Custom Script Resource after patch - existingScript:{}", (Object)existingScript);
        return Response.ok((Object)existingScript).build();
    }

    @Operation(summary="Fetch custom script types", description="Fetch custom script types", operationId="get-custom-script-type", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CustomScriptType.class)), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-types.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/types")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.readonly"}, groupScopes={"https://jans.io/oauth/config/scripts.write"}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getCustomScriptTypes() {
        this.logger.info("Fetch type of custom script ");
        List<CustomScriptType> customScriptTypes = Arrays.asList(CustomScriptType.values());
        this.logger.info("Custom scripts type fetched customScriptTypes :{}", customScriptTypes);
        return Response.ok(customScriptTypes).build();
    }

    @Operation(summary="Fetch custom script types", description="Fetch custom script types", operationId="get-custom-script-types", tags={"Custom Scripts"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scripts.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)), examples={@ExampleObject(name="Response json example", value="example/auth/scripts/scripts-types.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Path(value="/script-types")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scripts.readonly"}, groupScopes={"https://jans.io/oauth/config/scripts.write"}, superScopes={"https://jans.io/oauth/config/scripts.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getCustomScriptTypesDetails() {
        this.logger.info("Fetch type of custom script ");
        HashSet customScripts = new HashSet();
        List customScriptList = this.customScriptService.findAllCustomScripts(null);
        this.logger.info("Custom Scripts fetched :{}", (Object)customScriptList);
        if (customScriptList != null && !customScriptList.isEmpty()) {
            customScriptList.forEach(item -> customScripts.add(item.getScriptType().getValue()));
            this.logger.debug("Custom Scripts fetched :{}", (Object)customScriptList);
        }
        this.logger.info("Custom scripts type fetched customScripts :{}", customScripts);
        return Response.ok(customScripts).build();
    }

    private PagedResult<CustomScript> doSearch(SearchRequest searchReq, CustomScriptType type) {
        this.logger.debug("CustomScript search request params -  searchReq:{}, type:{}", (Object)searchReq, (Object)type);
        PagedResult pagedResult = this.customScriptService.searchScripts(searchReq, type);
        this.logger.debug("PagedResult  - pagedResult:{}", (Object)pagedResult);
        if (pagedResult != null) {
            this.logger.debug("CustomScripts fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
        }
        this.logger.debug("CustomScript pagedResult:{} ", (Object)pagedResult);
        return pagedResult;
    }

    private void validateScriptLocationType(CustomScript customScript) {
        this.logger.info("validate ScriptLocationType - customScript:{}", (Object)customScript);
        if (customScript == null || customScript.getLocationType() == null) {
            return;
        }
        this.logger.trace("validate customScript.getLocationType().getValue():{}", (Object)customScript.getLocationType().getValue());
        if (ScriptLocationType.LDAP.getValue().equalsIgnoreCase(customScript.getLocationType().getValue())) {
            CustomScriptResource.throwBadRequestException((String)("Invalid value for 'location_type' in request is 'ldap' which is deprecated. Use '" + ScriptLocationType.DB.getValue() + "' instead."));
        }
    }

    private CustomScript updateRevision(CustomScript customScript, CustomScript existingScript) {
        this.logger.info("Update script revision - customScript:{}, existingScript:{}", (Object)customScript, (Object)existingScript);
        if (customScript == null) {
            return customScript;
        }
        this.logger.trace("validate customScript.getRevision():{}", (Object)customScript.getRevision());
        if (existingScript == null) {
            customScript.setRevision(1L);
            return customScript;
        }
        this.logger.trace("validate customScript.getRevision():{}, existingScript.getRevision():{}", (Object)customScript.getRevision(), (Object)existingScript.getRevision());
        if (customScript.getRevision() <= 0L && existingScript.getRevision() <= 0L) {
            customScript.setRevision(1L);
        } else {
            customScript.setRevision(existingScript.getRevision() + 1L);
        }
        this.logger.debug("script revision after update - customScript.getRevision():{}", (Object)customScript.getRevision());
        return customScript;
    }

    private void updateAuthenticationMethod(CustomScript customScript) {
        this.logger.debug("Check for AuthenticationMethod customScript:{}", (Object)customScript);
        String defaultAcr = this.getAuthenticationMethod();
        this.logger.debug("Current defaultAcr:{}", (Object)defaultAcr);
        if (customScript == null || StringUtils.isBlank((CharSequence)defaultAcr) || !defaultAcr.equalsIgnoreCase(customScript.getName())) {
            return;
        }
        String scriptName = customScript.getName();
        this.logger.debug("scriptName:{}", (Object)scriptName);
        if (defaultAcr.equalsIgnoreCase(scriptName) && !customScript.isEnabled()) {
            this.logger.debug(String.format("\n\n Removing defaultAcr as the script{%s} is disabled ", scriptName));
            this.removeAuthenticationMethod();
            defaultAcr = this.getAuthenticationMethod();
            this.logger.debug("defaultAcr:{}", (Object)defaultAcr);
        }
    }

    private String getAuthenticationMethod() {
        GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
        return gluuConfiguration.getAuthenticationMode();
    }

    private void removeAuthenticationMethod() {
        GluuConfiguration gluuConfiguration = this.configurationService.findGluuConfiguration();
        gluuConfiguration.setAuthenticationMode(null);
        this.configurationService.merge(gluuConfiguration);
    }
}

