/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.fasterxml.jackson.databind.JsonNode;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.AuthService;
import io.jans.configapi.service.auth.ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/jans-auth-server/health")
public class HealthCheckResource
extends ConfigBaseResource {
    private static final String HEALTH_CHECK_URL = "/jans-auth/sys/health-check";
    @Inject
    ConfigurationService configurationService;
    @Inject
    AuthService authService;

    @Operation(summary="Returns auth server health status", description="Returns auth server health status", operationId="get-auth-server-health", tags={"Auth Server Health - Check"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class), examples={@ExampleObject(name="Response json example", value="example/auth/health/health.json")})}), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @Produces(value={"application/json"})
    public Response getHealthCheckStatus() {
        String url = this.getIssuer() + HEALTH_CHECK_URL;
        JsonNode jsonNode = this.authService.getHealthCheckResponse(url);
        this.logger.debug("StatResource::getUserStatistics() - jsonNode:{} ", (Object)jsonNode);
        return Response.ok((Object)jsonNode).build();
    }

    private String getIssuer() {
        return this.configurationService.find().getIssuer();
    }
}

