/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.model.config.Conf;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;

@Path(value="/config/jwks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class JwksResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    ConfigurationService configurationService;

    @Operation(summary="Gets list of JSON Web Key (JWK) used by server", description="Gets list of JSON Web Key (JWK) used by server", operationId="get-config-jwks", tags={"Configuration \u2013 JWK - JSON Web Key (JWK)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebKeysConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/jwks/web-keys-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jwks.readonly"}, groupScopes={"https://jans.io/oauth/config/jwks.write"}, superScopes={"https://jans.io/oauth/config/jwks.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response get() {
        String json = this.configurationService.findConf().getWebKeys().toString();
        this.log.debug("JWKS json :{}", (Object)json);
        return Response.ok((Object)json).build();
    }

    @Operation(summary="Replaces JSON Web Keys", description="Replaces JSON Web Keys", operationId="put-config-jwks", tags={"Configuration \u2013 JWK - JSON Web Key (JWK)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="JSON Web Keys object", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebKeysConfiguration.class), examples={@ExampleObject(name="Request json example", value="example/auth/jwks/web-keys-all.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebKeysConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/jwks/web-keys-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jwks.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/jwks.admin", "https://jans.io/oauth/config/write-all"})
    public Response put(WebKeysConfiguration webkeys) {
        this.log.debug("JWKS details to be updated - webkeys:{}", (Object)webkeys);
        Conf conf = this.configurationService.findConf();
        conf.setWebKeys(webkeys);
        this.configurationService.merge(conf);
        String json = this.configurationService.findConf().getWebKeys().toString();
        return Response.ok((Object)json).build();
    }

    @Operation(summary="Patches JSON Web Keys", description="Patches JSON Web Keys", operationId="patch-config-jwks", tags={"Configuration \u2013 JWK - JSON Web Key (JWK)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="JsonPatch object", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/auth/jwks/web-keys-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebKeysConfiguration.class), examples={@ExampleObject(name="Response json example", value="example/auth/jwks/web-keys-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jwks.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/jwks.admin", "https://jans.io/oauth/config/write-all"})
    public Response patch(String requestString) throws JsonPatchException, IOException {
        this.log.debug("JWKS details to be patched - requestString:{}", (Object)requestString);
        Conf conf = this.configurationService.findConf();
        WebKeysConfiguration webKeys = conf.getWebKeys();
        webKeys = (WebKeysConfiguration)Jackson.applyPatch((String)requestString, (Object)webKeys);
        conf.setWebKeys(webKeys);
        this.configurationService.merge(conf);
        String json = this.configurationService.findConf().getWebKeys().toString();
        return Response.ok((Object)json).build();
    }

    @Operation(summary="Configuration \u2013 JWK - JSON Web Key (JWK)", description="Configuration \u2013 JWK - JSON Web Key (JWK)", operationId="post-config-jwks-key", tags={"Configuration \u2013 JWK - JSON Web Key (JWK)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="JSONWebKey object", content={@Content(mediaType="application/json", schema=@Schema(implementation=JSONWebKey.class), examples={@ExampleObject(name="Request json example", value="example/auth/jwks/jwks-post.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=JSONWebKey.class), examples={@ExampleObject(name="Response json example", value="example/auth/jwks/jwks-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="406", description="Not Acceptable"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jwks.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/jwks.admin", "https://jans.io/oauth/config/write-all"})
    @Path(value="/key")
    public Response getKeyById(@NotNull JSONWebKey jwk) {
        this.log.debug("Add a new Key to the JWKS:{}", (Object)jwk);
        Conf conf = this.configurationService.findConf();
        WebKeysConfiguration webkeys = this.configurationService.findConf().getWebKeys();
        this.log.debug("WebKeysConfiguration before addding new key:{} ", (Object)webkeys);
        if (this.getJSONWebKey(webkeys, jwk.getKid()) != null) {
            throw new NotAcceptableException(JwksResource.getNotAcceptableException((String)("JWK with same kid - '" + jwk.getKid() + "' already exists!")));
        }
        webkeys.getKeys().add(jwk);
        conf.setWebKeys(webkeys);
        this.configurationService.merge(conf);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)jwk).build();
    }

    @Operation(summary="Get a JSON Web Key based on kid", description="Get a JSON Web Key based on kid", operationId="get-jwk-by-kid", tags={"Configuration \u2013 JWK - JSON Web Key (JWK)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JSONWebKey.class), examples={@ExampleObject(name="Response json example", value="example/auth/jwks/jwks-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jwks.readonly"}, groupScopes={"https://jans.io/oauth/config/jwks.write"}, superScopes={"https://jans.io/oauth/config/jwks.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="/{kid}")
    public Response getKeyById(@Parameter(description="The unique identifier for the key") @PathParam(value="kid") @NotNull String kid) {
        this.log.debug("Fetch JWK details by kid:{}", (Object)kid);
        WebKeysConfiguration webkeys = this.configurationService.findConf().getWebKeys();
        this.log.debug("WebKeysConfiguration before addding new key:{}", (Object)webkeys);
        JSONWebKey jwk = this.getJSONWebKey(webkeys, kid);
        return Response.ok((Object)jwk).build();
    }

    @Operation(summary="Patch a specific JSON Web Key based on kid", description="Patch a specific JSON Web Key based on kid", operationId="patch-config-jwk-kid", tags={"Configuration \u2013 JWK - JSON Web Key (JWK)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="JsonPatch object", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/auth/jwks/jwks-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=JSONWebKey.class), examples={@ExampleObject(name="Response json example", value="example/auth/jwks/jwks-patch-response.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jwks.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/jwks.admin", "https://jans.io/oauth/config/write-all"})
    @Path(value="/{kid}")
    public Response patch(@Parameter(description="The unique identifier for the key") @PathParam(value="kid") @NotNull String kid, @NotNull String requestString) throws JsonPatchException, IOException {
        this.log.debug("JWKS details to be patched for kid:{}, requestString:{}", (Object)kid, (Object)requestString);
        Conf conf = this.configurationService.findConf();
        WebKeysConfiguration webkeys = this.configurationService.findConf().getWebKeys();
        JSONWebKey jwk = this.getJSONWebKey(webkeys, kid);
        if (jwk == null) {
            throw new NotFoundException(JwksResource.getNotFoundError((String)("JWK with kid - '" + kid + "' does not exist!")));
        }
        jwk = (JSONWebKey)Jackson.applyPatch((String)requestString, (Object)jwk);
        this.log.debug("JWKS details patched - jwk:{}", (Object)jwk);
        conf.getWebKeys().getKeys().removeIf(x -> x.getKid() != null && x.getKid().equals(kid));
        this.log.debug("WebKeysConfiguration after removing old key:{}", (Object)conf.getWebKeys().getKeys());
        conf.getWebKeys().getKeys().add(jwk);
        this.configurationService.merge(conf);
        return Response.ok((Object)jwk).build();
    }

    @Operation(summary="Delete a JSON Web Key based on kid", description="Delete a JSON Web Key based on kid", operationId="delete-config-jwk-kid", tags={"Configuration \u2013 JWK - JSON Web Key (JWK)"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/jwks.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="406", description="Not Acceptable"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @ProtectedApi(scopes={"https://jans.io/oauth/config/jwks.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/jwks.admin", "https://jans.io/oauth/config/write-all"})
    @Path(value="/{kid}")
    public Response deleteKey(@Parameter(description="The unique identifier for the key") @PathParam(value="kid") @NotNull String kid) {
        this.log.debug("Key to be to be deleted - kid:{}", (Object)kid);
        Conf conf = this.configurationService.findConf();
        WebKeysConfiguration webkeys = this.configurationService.findConf().getWebKeys();
        JSONWebKey jwk = this.getJSONWebKey(webkeys, kid);
        if (jwk == null) {
            throw new NotFoundException(JwksResource.getNotFoundError((String)("JWK with kid - '" + kid + "' does not exist!")));
        }
        conf.getWebKeys().getKeys().removeIf(x -> x.getKid() != null && x.getKid().equals(kid));
        this.configurationService.merge(conf);
        return Response.noContent().build();
    }

    private JSONWebKey getJSONWebKey(WebKeysConfiguration webkeys, String kid) {
        if (kid != null && webkeys.getKeys() != null && !webkeys.getKeys().isEmpty()) {
            return webkeys.getKeys().stream().filter(x -> x.getKid() != null && x.getKid().equals(kid)).findAny().orElse(null);
        }
        return null;
    }
}

