/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import io.jans.as.model.config.Conf;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.rest.model.Logging;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/logging")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LoggingResource
extends ConfigBaseResource {
    @Inject
    Logger log;
    @Inject
    ConfigurationService configurationService;

    @Operation(summary="Returns Jans Authorization Server logging settings", description="Returns Jans Authorization Server logging settings", operationId="get-config-logging", tags={"Configuration \u2013 Logging"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/logging.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/logging.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/logging.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Logging.class), examples={@ExampleObject(name="Response json example", value="example/logging/logging.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/logging.readonly"}, groupScopes={"https://jans.io/oauth/config/logging.write"}, superScopes={"https://jans.io/oauth/config/logging.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getLogging() {
        return Response.ok((Object)this.getLoggingConfiguration()).build();
    }

    @Operation(summary="Updates Jans Authorization Server logging settings", description="Updates Jans Authorization Server logging settings", operationId="put-config-logging", tags={"Configuration \u2013 Logging"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/logging.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/logging.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="Logging object", content={@Content(mediaType="application/json", schema=@Schema(implementation=Logging.class), examples={@ExampleObject(name="Request json example", value="example/logging/logging.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Logging.class), examples={@ExampleObject(name="Response json example", value="example/logging/logging.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/logging.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/logging.admin", "https://jans.io/oauth/config/write-all"})
    public Response updateLogConf(@Valid Logging logging) {
        this.log.debug("LOGGING configuration to be updated -logging:{}", (Object)logging);
        Conf conf = this.configurationService.findConf();
        if (!StringUtils.isBlank((CharSequence)logging.getLoggingLevel())) {
            conf.getDynamic().setLoggingLevel(logging.getLoggingLevel());
        }
        if (!StringUtils.isBlank((CharSequence)logging.getLoggingLayout())) {
            conf.getDynamic().setLoggingLayout(logging.getLoggingLayout());
        }
        conf.getDynamic().setHttpLoggingEnabled(Boolean.valueOf(logging.isHttpLoggingEnabled()));
        conf.getDynamic().setDisableJdkLogger(Boolean.valueOf(logging.isDisableJdkLogger()));
        conf.getDynamic().setEnabledOAuthAuditLogging(Boolean.valueOf(logging.isEnabledOAuthAuditLogging()));
        if (!StringUtils.isBlank((CharSequence)logging.getExternalLoggerConfiguration())) {
            conf.getDynamic().setExternalLoggerConfiguration(logging.getExternalLoggerConfiguration());
        }
        conf.getDynamic().setHttpLoggingExcludePaths(logging.getHttpLoggingExcludePaths());
        this.configurationService.merge(conf);
        logging = this.getLoggingConfiguration();
        return Response.ok((Object)logging).build();
    }

    private Logging getLoggingConfiguration() {
        Logging logging = new Logging();
        AppConfiguration appConfiguration = this.configurationService.find();
        logging.setLoggingLevel(appConfiguration.getLoggingLevel());
        logging.setLoggingLayout(appConfiguration.getLoggingLayout());
        logging.setHttpLoggingEnabled(appConfiguration.getHttpLoggingEnabled().booleanValue());
        logging.setDisableJdkLogger(appConfiguration.getDisableJdkLogger().booleanValue());
        if (appConfiguration.getEnabledOAuthAuditLogging() == null) {
            logging.setEnabledOAuthAuditLogging(false);
        } else {
            logging.setEnabledOAuthAuditLogging(appConfiguration.getEnabledOAuthAuditLogging().booleanValue());
        }
        logging.setExternalLoggerConfiguration(appConfiguration.getExternalLoggerConfiguration());
        logging.setHttpLoggingExcludePaths(appConfiguration.getHttpLoggingExcludePaths());
        return logging;
    }
}

