/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.persistence.model.GluuOrganization;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.OrganizationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;

@Path(value="/org")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class OrganizationResource
extends ConfigBaseResource {
    @Inject
    OrganizationService organizationService;

    @Operation(summary="Retrieves organization configuration", description="Retrieves organization configuration", operationId="get-organization-config", tags={"Organization Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/organization.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/organization.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/organization.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuOrganization.class), examples={@ExampleObject(name="Response json example", value="example/org/org.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/organization.readonly"}, groupScopes={"https://jans.io/oauth/config/organization.write"}, superScopes={"https://jans.io/oauth/config/organization.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getOrganization() {
        return Response.ok((Object)this.organizationService.getOrganization()).build();
    }

    @Operation(summary="Patch organization configuration", description="Patch organization configuration", operationId="patch-organization-config", tags={"Organization Configuration"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/organization.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/organization.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing JsonPatch request.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/org/org-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=GluuOrganization.class), examples={@ExampleObject(name="Response json example", value="example/org/org-patch-response.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/organization.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/organization.admin", "https://jans.io/oauth/config/write-all"})
    public Response patchOrganization(@NotNull String pathString) throws JsonPatchException, IOException {
        this.logger.trace("Organization patch request - pathString:{} ", (Object)pathString);
        GluuOrganization organization = this.organizationService.getOrganization();
        try {
            organization = (GluuOrganization)Jackson.applyPatch((String)pathString, (Object)organization);
            this.organizationService.updateOrganization(organization);
        }
        catch (Exception ex) {
            this.logger.error("Error while patching Organization details", (Throwable)ex);
            OrganizationResource.throwInternalServerException((Throwable)ex);
        }
        return Response.ok((Object)this.organizationService.getOrganization()).build();
    }
}

