/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.rest.resource.auth;

import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.configapi.core.rest.ProtectedApi;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.rest.model.CustomScope;
import io.jans.configapi.rest.resource.auth.ConfigBaseResource;
import io.jans.configapi.service.auth.ScopeService;
import io.jans.model.SearchRequest;
import io.jans.orm.model.PagedResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;

@Path(value="/scopes")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ScopesResource
extends ConfigBaseResource {
    private static final String SCOPE = "scope";
    @Inject
    Logger log;
    @Inject
    ScopeService scopeService;

    @Operation(summary="Gets list of Scopes", description="Gets list of Scopes", operationId="get-oauth-scopes", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=PagedResult.class), examples={@ExampleObject(name="Response json example", value="example/scopes/scopes-all.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.readonly"}, groupScopes={"https://jans.io/oauth/config/scopes.write"}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    public Response getScopes(@Parameter(description="Scope type") @DefaultValue(value="") @QueryParam(value="type") String type, @Parameter(description="Search size - max size of the results to return") @DefaultValue(value="50") @QueryParam(value="limit") int limit, @Parameter(description="Search pattern") @DefaultValue(value="") @QueryParam(value="pattern") String pattern, @Parameter(description="The 1-based index of the first query result") @DefaultValue(value="0") @QueryParam(value="startIndex") int startIndex, @Parameter(description="Attribute whose value will be used to order the returned response") @DefaultValue(value="inum") @QueryParam(value="sortBy") String sortBy, @Parameter(description="Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"") @DefaultValue(value="ascending") @QueryParam(value="sortOrder") String sortOrder, @Parameter(description="Boolean fag to indicate if clients associated with the scope are to be returned") @DefaultValue(value="false") @QueryParam(value="withAssociatedClients") boolean withAssociatedClients, @Parameter(description="Field and value pair for seraching", examples={@ExampleObject(name="Field value example", value="scopeType=spontaneous,defaultScope=true")}) @DefaultValue(value="") @QueryParam(value="fieldValuePair") String fieldValuePair) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SCOPES to be fetched based on type:{}, limit:{}, pattern:{}, startIndex:{}, sortBy:{}, sortOrder:{}, withAssociatedClients:{}, fieldValuePair:{}", new Object[]{Util.escapeLog((Object)type), Util.escapeLog((Object)limit), Util.escapeLog((Object)pattern), Util.escapeLog((Object)startIndex), Util.escapeLog((Object)sortBy), Util.escapeLog((Object)sortOrder), Util.escapeLog((Object)withAssociatedClients), Util.escapeLog((Object)fieldValuePair)});
        }
        SearchRequest searchReq = this.createSearchRequest(this.scopeService.getDnForScope(null), pattern, sortBy, sortOrder, startIndex, limit, null, null, this.getMaxCount(), fieldValuePair, CustomScope.class);
        return Response.ok(this.doSearch(searchReq, type, withAssociatedClients)).build();
    }

    @Operation(summary="Get Scope by Inum", description="Get Scope by Inum", operationId="get-oauth-scopes-by-inum", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=CustomScope.class), examples={@ExampleObject(name="Response json example", value="example/scopes/scopes-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.readonly"}, groupScopes={"https://jans.io/oauth/config/scopes.write"}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="{inum}")
    public Response getScopeById(@Parameter(description="Scope identifier") @NotNull @PathParam(value="inum") String inum, @DefaultValue(value="false") @QueryParam(value="withAssociatedClients") boolean withAssociatedClients) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SCOPES to be fetched by inum:{}", (Object)inum);
        }
        CustomScope scope = this.scopeService.getScopeByInum(inum, withAssociatedClients);
        ScopesResource.checkResourceNotNull((Object)scope, (String)SCOPE);
        return Response.ok((Object)scope).build();
    }

    @Operation(summary="Get Scope by creatorId", description="Get Scope by creatorId", operationId="get-scope-by-creator", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CustomScope.class)), examples={@ExampleObject(name="Response json example", value="example/scopes/scopes-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.readonly"}, groupScopes={"https://jans.io/oauth/config/scopes.write"}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="creator/{creatorId}")
    public Response getScopeByClientId(@Parameter(description="Id of the scope creator. If creator is client then client_id if user then user_id") @NotNull @PathParam(value="creatorId") String creatorId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SCOPES to be fetched by creatorId:{}", (Object)creatorId);
        }
        SearchRequest searchReq = new SearchRequest();
        searchReq.setFilterAttributeName(Arrays.asList("creatorId"));
        searchReq.setFilter(creatorId);
        List<CustomScope> scopes = this.scopeService.searchScope(searchReq);
        return Response.ok(scopes).build();
    }

    @Operation(summary="Get Scope by type", description="Get Scope by type", operationId="get-scope-by-type", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.readonly"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/read-all"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CustomScope.class)), examples={@ExampleObject(name="Response json example", value="example/scopes/scopes-get.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @GET
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.readonly"}, groupScopes={"https://jans.io/oauth/config/scopes.write"}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/read-all", "https://jans.io/oauth/config/write-all"})
    @Path(value="type/{type}")
    public Response getScopeByType(@Parameter(description="Type of the scope") @NotNull @PathParam(value="type") String type) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SCOPES to be fetched by type:{}", (Object)type);
        }
        SearchRequest searchReq = new SearchRequest();
        searchReq.setFilterAttributeName(Arrays.asList("jansScopeTyp"));
        searchReq.setFilter(type);
        List<CustomScope> scopes = this.scopeService.searchScope(searchReq);
        return Response.ok(scopes).build();
    }

    @Operation(summary="Create Scope", description="Create Scope", operationId="post-oauth-scopes", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="Scope object", content={@Content(mediaType="application/json", schema=@Schema(implementation=Scope.class), examples={@ExampleObject(name="Request json example", value="example/scopes/scopes-post.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=Scope.class), examples={@ExampleObject(name="Response json example", value="example/scopes/scopes.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @POST
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/write-all"})
    public Response createOpenidScope(@Valid Scope scope) {
        this.log.debug("SCOPE to be added - scope:{}", (Object)scope);
        ScopesResource.checkNotNull((String)scope.getId(), (String)"id");
        if (scope.getDisplayName() == null) {
            scope.setDisplayName(scope.getId());
        }
        String inum = UUID.randomUUID().toString();
        scope.setInum(inum);
        scope.setDn(this.scopeService.getDnForScope(inum));
        if (scope.getScopeType() == null) {
            scope.setScopeType(ScopeType.OAUTH);
        }
        this.scopeService.addScope(scope);
        CustomScope result = this.scopeService.getScopeByInum(inum);
        this.log.debug("Id of newly added is {}", (Object)result.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    @Operation(summary="Update Scope", description="Update Scope", operationId="put-oauth-scopes", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="Scope object", content={@Content(mediaType="application/json", schema=@Schema(implementation=Scope.class), examples={@ExampleObject(name="Request json example", value="example/scopes/scopes.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Scope.class), examples={@ExampleObject(name="Response json example", value="example/scopes/scopes.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PUT
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/write-all"})
    public Response updateScope(@Valid Scope scope) {
        this.log.debug("SCOPE to be updated - scop:{}", (Object)scope.getId());
        String inum = scope.getInum();
        ScopesResource.checkNotNull((String)inum, (String)SCOPE);
        CustomScope existingScope = this.scopeService.getScopeByInum(inum);
        ScopesResource.checkResourceNotNull((Object)existingScope, (String)SCOPE);
        if (scope.getScopeType() == null) {
            scope.setScopeType(ScopeType.OAUTH);
        }
        scope.setInum(existingScope.getInum());
        scope.setBaseDn(this.scopeService.getDnForScope(inum));
        this.scopeService.updateScope(scope);
        CustomScope result = this.scopeService.getScopeByInum(inum);
        this.log.debug("Updated scope:{}", (Object)result.getId());
        return Response.ok((Object)result).build();
    }

    @Operation(summary="Patch Scope", description="Patch Scope", operationId="patch-oauth-scopes-by-id", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.write"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/write-all"})})
    @RequestBody(description="String representing patch-document.", content={@Content(mediaType="application/json-patch+json", array=@ArraySchema(schema=@Schema(implementation=JsonPatch.class)), examples={@ExampleObject(name="Request json example", value="example/scopes/scopes-patch.json")})})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok", content={@Content(mediaType="application/json", schema=@Schema(implementation=Scope.class), examples={@ExampleObject(name="Response json example", value="example/scopes/scopes.json")})}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @PATCH
    @Consumes(value={"application/json-patch+json"})
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.write"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/write-all"})
    @Path(value="{inum}")
    public Response patchScope(@Parameter(description="Scope identifier") @PathParam(value="inum") @NotNull String inum, @NotNull String pathString) throws JsonPatchException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SCOPES patch details - inum:{}, pathString:{}", (Object)inum, (Object)pathString);
        }
        CustomScope existingScope = this.scopeService.getScopeByInum(inum);
        ScopesResource.checkResourceNotNull((Object)existingScope, (String)SCOPE);
        existingScope = (Scope)Jackson.applyPatch((String)pathString, (Object)existingScope);
        this.scopeService.updateScope((Scope)existingScope);
        existingScope = this.scopeService.getScopeByInum(inum);
        this.log.debug("patched scope:{}", (Object)existingScope.getId());
        return Response.ok((Object)existingScope).build();
    }

    @Operation(summary="Delete Scope", description="Delete Scope", operationId="delete-oauth-scopes-by-inum", tags={"OAuth - Scopes"}, security={@SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.delete"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/scopes.admin"}), @SecurityRequirement(name="oauth2", scopes={"https://jans.io/oauth/config/delete-all"})})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="500", description="InternalServerError")})
    @DELETE
    @Path(value="{inum}")
    @ProtectedApi(scopes={"https://jans.io/oauth/config/scopes.delete"}, groupScopes={}, superScopes={"https://jans.io/oauth/config/scopes.admin", "https://jans.io/oauth/config/delete-all"})
    public Response deleteScope(@Parameter(description="Scope identifier") @PathParam(value="inum") @NotNull String inum) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SCOPES to be deleted - inum:{}", (Object)inum);
        }
        CustomScope scope = this.scopeService.getScopeByInum(inum);
        ScopesResource.checkResourceNotNull((Object)scope, (String)SCOPE);
        this.scopeService.removeScope((Scope)scope);
        this.log.debug("SCOPE is deleted");
        return Response.noContent().build();
    }

    private PagedResult<CustomScope> doSearch(SearchRequest searchReq, String type, boolean withAssociatedClients) {
        if (this.log.isDebugEnabled()) {
            this.logger.debug("CustomScope search params - searchReq:{}, type:{}, withAssociatedClients:{} ", new Object[]{searchReq, type, withAssociatedClients});
        }
        PagedResult<CustomScope> pagedResult = this.scopeService.getScopeResult(searchReq, type, withAssociatedClients);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("PagedResult  - pagedResult:{}", pagedResult);
        }
        if (pagedResult != null) {
            this.logger.debug("Scope fetched  - pagedResult.getTotalEntriesCount():{}, pagedResult.getEntriesCount():{}, pagedResult.getEntries():{}", new Object[]{pagedResult.getTotalEntriesCount(), pagedResult.getEntriesCount(), pagedResult.getEntries()});
        }
        this.logger.debug("Scope  - pagedResult:{}", pagedResult);
        return pagedResult;
    }
}

