/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.security.api;

import com.google.common.base.Preconditions;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.ScopeType;
import io.jans.configapi.configuration.ConfigurationFactory;
import io.jans.configapi.core.protect.Condition;
import io.jans.configapi.core.protect.RsResource;
import io.jans.configapi.core.protect.RsResourceList;
import io.jans.configapi.core.protect.Scope;
import io.jans.configapi.core.util.Jackson;
import io.jans.configapi.core.util.ProtectionScopeType;
import io.jans.configapi.security.api.ApiProtectionCache;
import io.jans.configapi.service.auth.ClientService;
import io.jans.configapi.service.auth.ScopeService;
import io.jans.orm.exception.EntryPersistenceException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ApiProtectionService {
    public static final String PROTECTION_CONFIGURATION_FILE_NAME = "config-api-rs-protect.json";
    @Inject
    Logger log;
    @Inject
    ScopeService scopeService;
    @Inject
    ClientService clientService;
    @Inject
    ConfigurationFactory configurationFactory;
    Collection<RsResource> rsResourceList;

    public Collection<RsResource> getResourceList() {
        return this.rsResourceList;
    }

    public void verifyResources(String apiProtectionType, String clientId) throws IOException {
        this.log.debug("ApiProtectionService::verifyResources() - apiProtectionType:{}, clientId:{}, configurationFactory:{} ", new Object[]{apiProtectionType, clientId, this.configurationFactory});
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = loader.getResourceAsStream(PROTECTION_CONFIGURATION_FILE_NAME);
        RsResourceList resourceList = (RsResourceList)Jackson.createJsonMapper().readValue(inputStream, RsResourceList.class);
        this.rsResourceList = resourceList.getResources();
        this.log.debug("verifyResources() - rsResourceList{} ", this.rsResourceList);
        Preconditions.checkNotNull(this.rsResourceList, (Object)"Config Api Resource list cannot be null !!!");
        this.createScopeIfNeeded(apiProtectionType);
        this.log.trace(" *** ApiProtectionService:::verifyResources() -  getAllResources:{}, getScopes():{}, getGroupScopes():{}, getSuperScopes():{}, getAllTypesOfScopes():{}", new Object[]{ApiProtectionCache.getAllResources(), ApiProtectionCache.getScopes(), ApiProtectionCache.getGroupScopes(), ApiProtectionCache.getSuperScopes(), ApiProtectionCache.getAllTypesOfScopes()});
        this.updateScopeForClientIfNeeded(clientId);
    }

    private void createScopeIfNeeded(String apiProtectionType) {
        this.log.debug("ApiProtectionService:::createScopeIfNeeded() - apiProtectionType:{}", (Object)apiProtectionType);
        ArrayList scopeList = new ArrayList();
        for (RsResource rsResource : this.rsResourceList) {
            for (Condition condition : rsResource.getConditions()) {
                List superScopes;
                List groupScopes;
                String resourceName = condition.getHttpMethods() + ":::" + rsResource.getPath();
                this.log.debug("ApiProtectionService:::createScopeIfNeeded() - resourceName:{}, condition.getScopes():{}, condition.getGroupScopes():{}, condition.getSuperScopes():{}", new Object[]{resourceName, condition.getScopes(), condition.getGroupScopes(), condition.getSuperScopes()});
                List rsScopes = condition.getScopes();
                if (rsScopes != null && !rsScopes.isEmpty()) {
                    this.processScope(resourceName, ProtectionScopeType.SCOPE, rsScopes);
                }
                if ((groupScopes = condition.getGroupScopes()) != null && !groupScopes.isEmpty()) {
                    this.processScope(resourceName, ProtectionScopeType.GROUP, groupScopes);
                }
                if ((superScopes = condition.getSuperScopes()) != null && !superScopes.isEmpty()) {
                    this.processScope(resourceName, ProtectionScopeType.SUPER, superScopes);
                }
                this.log.debug("ApiProtectionService:::createScopeIfNeeded() - resourceName:{}, scopeList:{}", (Object)resourceName, scopeList);
            }
        }
    }

    private void processScope(String resourceName, ProtectionScopeType protectionScopeType, List<Scope> scopeList) {
        this.log.debug("ApiProtectionService:::processScope() - resourceName:{}, protectionScopeType:{}, scopeList:{}", new Object[]{resourceName, protectionScopeType, scopeList});
        if (scopeList == null || scopeList.isEmpty()) {
            return;
        }
        for (Scope rsScope : scopeList) {
            String inum = rsScope.getInum();
            String scopeName = rsScope.getName();
            this.log.debug("ApiProtectionService:::processScope() - resourceName:{}, inum:{}, scopeName:{}", new Object[]{resourceName, inum, scopeName});
            if (StringUtils.isBlank((CharSequence)inum) || StringUtils.isBlank((CharSequence)scopeName)) {
                return;
            }
            List<io.jans.as.persistence.model.Scope> scopes = this.validateScope(resourceName, protectionScopeType, rsScope);
            ApiProtectionCache.putResourceScopeByType(resourceName, protectionScopeType, scopes);
        }
    }

    private List<io.jans.as.persistence.model.Scope> validateScope(String resourceName, ProtectionScopeType protectionScopeType, Scope rsScope) {
        this.log.debug("Verify Scope in DB - protectionScopeType:{}, rsScope:{} ", (Object)protectionScopeType, (Object)rsScope);
        HashSet<io.jans.as.persistence.model.Scope> scopeList = new HashSet<io.jans.as.persistence.model.Scope>();
        io.jans.as.persistence.model.Scope scope = this.scopeService.getScope(rsScope.getInum());
        this.log.debug("Scopes from DB - {}'", (Object)scope);
        if (scope != null) {
            this.log.debug("Scope from DB is not null scope.getInum():{}, scope.getId():{}", (Object)scope.getInum(), (Object)scope.getId());
            scopeList.add(scope);
        }
        ScopeType scopeType = ScopeType.OAUTH;
        this.log.debug("Scope details - scope:{}, rsScope.getName():{}, exclusiveAuthScopes:{}, isConfigApiScope(scopeName):{} '", new Object[]{scope, rsScope.getName(), this.configurationFactory.getApiAppConfiguration().getExclusiveAuthScopes(), this.isConfigApiScope(rsScope.getName())});
        if (this.isConfigApiScope(rsScope.getName())) {
            scope = this.scopeService.getScope(rsScope.getInum());
            this.log.info("Re-verify ConfigApiScope rsScope.getName():{} with rsScope.getInum():{} in DB - scope:{} ", new Object[]{rsScope.getName(), rsScope.getInum(), scope});
            if (scope == null) {
                this.log.info("Scope - '{}' does not exist, hence creating it.", (Object)scope);
                scope = new io.jans.as.persistence.model.Scope();
                String inum = rsScope.getInum();
                scope.setId(rsScope.getName());
                scope.setDisplayName(rsScope.getName());
                scope.setInum(inum);
                scope.setDn(this.scopeService.getDnForScope(inum));
                scope.setScopeType(scopeType);
                this.addScope(scope);
            } else {
                this.log.info("Scope - '{}' already exists, hence updating it.", (Object)rsScope.getName());
                scope.setId(rsScope.getName());
                scope.setScopeType(scopeType);
                this.scopeService.updateScope(scope);
            }
        }
        if (scope != null) {
            scopeList.add(scope);
            ApiProtectionCache.addScope(resourceName, protectionScopeType, scope);
        }
        return scopeList.stream().collect(Collectors.toList());
    }

    private boolean isConfigApiScope(String scopeName) {
        return this.configurationFactory.getApiAppConfiguration().getExclusiveAuthScopes() == null || !this.configurationFactory.getApiAppConfiguration().getExclusiveAuthScopes().contains(scopeName);
    }

    private void updateScopeForClientIfNeeded(String clientId) {
        this.log.debug(" Internal clientId:{} ", (Object)clientId);
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return;
        }
        try {
            Client client = this.clientService.getClientByInum(clientId);
            this.log.debug("updateScopeForClientIfNeeded() - Verify client:{} ", (Object)client);
            if (client != null) {
                this.log.info("updateScopeForClientIfNeeded() - 1 - client.getClientSecret():{} ", (Object)client.getClientSecret());
                List<String> scopes = this.getScopeWithDn(this.getAllScopes());
                this.log.debug("updateScopeForClientIfNeeded() - All scopes:{}", scopes);
                if (client.getScopes() != null) {
                    List<String> existingScopes = Arrays.asList(client.getScopes());
                    this.log.debug("updateScopeForClientIfNeeded() - Clients existing scopes:{} ", existingScopes);
                    if (scopes == null) {
                        scopes = new ArrayList<String>();
                    }
                    scopes.addAll(existingScopes);
                }
                List<String> distinctScopes = scopes == null ? Collections.emptyList() : scopes.stream().distinct().collect(Collectors.toList());
                this.log.debug("updateScopeForClientIfNeeded() - Distinct scopes to add:{} ", distinctScopes);
                String[] scopeArray = this.getAllScopesArray(distinctScopes);
                this.log.debug("All Scope to assign to client:{}", Arrays.asList(scopeArray));
                client.setScopes(scopeArray);
                this.clientService.updateClient(client);
            }
            client = this.clientService.getClientByInum(clientId);
            this.log.debug(" Verify scopes post assignment, clientId:{}, scopes:{}", (Object)clientId, Arrays.asList(client.getScopes()));
            this.log.info("updateScopeForClientIfNeeded() - 2 - client.getClientSecret():{} ", (Object)client.getClientSecret());
        }
        catch (Exception ex) {
            this.log.error("Error while searching internal client", (Throwable)ex);
        }
    }

    private List<String> getAllScopes() {
        ArrayList<String> scopes = new ArrayList<String>();
        Map<String, io.jans.as.persistence.model.Scope> scopeMap = ApiProtectionCache.getAllTypesOfScopes();
        Set<String> keys = scopeMap.keySet();
        this.log.debug(" All Scopes scopeMap:{}, keys:{}", scopeMap, keys);
        for (String id : keys) {
            io.jans.as.persistence.model.Scope scope = scopeMap.get(id);
            this.log.trace(" All Scopes scopeMap:{}, keys:{}", scopeMap, keys);
            scopes.add(scope.getInum());
        }
        this.log.debug(" All Scopes being returned scopes:{}", scopes);
        return scopes;
    }

    private String[] getAllScopesArray(List<String> scopes) {
        String[] scopeArray = null;
        if (scopes != null && !scopes.isEmpty()) {
            scopeArray = new String[scopes.size()];
            for (int i = 0; i < scopes.size(); ++i) {
                scopeArray[i] = scopes.get(i);
            }
        }
        return scopeArray;
    }

    private List<String> getScopeWithDn(List<String> scopes) {
        ArrayList<String> scopeList = null;
        if (scopes != null && !scopes.isEmpty()) {
            scopeList = new ArrayList<String>();
            for (String id : scopes) {
                scopeList.add(this.scopeService.getDnForScope(id));
            }
        }
        return scopeList;
    }

    private void addScope(io.jans.as.persistence.model.Scope scope) {
        try {
            this.scopeService.addScope(scope);
        }
        catch (EntryPersistenceException ex) {
            this.log.error("Error while adding scope:{} is:{}", (Object)scope, (Object)ex);
        }
    }
}

