/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.agama.model.Flow;
import io.jans.agama.model.FlowMetadata;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.util.DataUtil;
import io.jans.configapi.model.configuration.AgamaConfiguration;
import io.jans.configapi.util.AuthUtil;
import io.jans.model.SearchRequest;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.reflect.property.Getter;
import io.jans.orm.search.filter.Filter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class AgamaFlowService
implements Serializable {
    private static final long serialVersionUID = 7912416439116338984L;
    private static final String AGAMA_BASE = "ou=agama,o=jans";
    public static final String AGAMA_FLOWS_BASE = "ou=flows,ou=agama,o=jans";
    @Inject
    private transient Logger logger;
    @Inject
    transient AuthUtil authUtil;
    @Inject
    transient DataUtil dataUtil;
    @Inject
    private transient PersistenceEntryManager persistenceEntryManager;

    public List<Flow> searchAgamaFlows(String pattern, int sizeLimit) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Search Agama Flow with pattern:{}, sizeLimit:{} ", (Object)Util.escapeLog((Object)pattern), (Object)Util.escapeLog((Object)sizeLimit));
        }
        String[] targetArray = new String[]{pattern};
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{Filter.createSubstringFilter((String)"agFlowQname", null, (String[])targetArray, null), Filter.createSubstringFilter((String)"agFlowMeta", null, (String[])targetArray, null)});
        this.logger.debug("Agama Flows with matching searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(this.getAgamaFlowDn(null), Flow.class, searchFilter, sizeLimit);
    }

    public List<Flow> searchAgamaFlows(String pattern, int sizeLimit, boolean enabled) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Search Agama Flow with pattern:{}, sizeLimit:{}, enabled:{} ", new Object[]{Util.escapeLog((Object)pattern), Util.escapeLog((Object)sizeLimit), Util.escapeLog((Object)enabled)});
        }
        String[] targetArray = new String[]{pattern};
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{Filter.createSubstringFilter((String)"agFlowQname", null, (String[])targetArray, null), Filter.createSubstringFilter((String)"agFlowMeta", null, (String[])targetArray, null), Filter.createEqualityFilter((String)"jansEnabled", (Object)enabled)});
        this.logger.debug("Agama Flows with searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findEntries(this.getAgamaFlowDn(null), Flow.class, searchFilter, sizeLimit);
    }

    public PagedResult<Flow> searchFlows(SearchRequest searchRequest) {
        this.logger.debug("Search Agama Flow with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getFilter())) {
            String[] targetArray = new String[]{searchRequest.getFilter()};
            searchFilter = Filter.createSubstringFilter((String)"agFlowQname", null, (String[])targetArray, null);
        }
        this.logger.debug("Searching Agama Flow with searchFilter:{}", searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getAgamaFlowDn(null), Flow.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public List<Flow> getAllAgamaFlows(int sizeLimit) {
        return this.persistenceEntryManager.findEntries(this.getAgamaFlowDn(null), Flow.class, null, sizeLimit);
    }

    public List<Flow> getAllFlows() {
        return this.persistenceEntryManager.findEntries(this.getAgamaFlowDn(null), Flow.class, null);
    }

    public Flow getFlowByName(String flowName) {
        return this.getFlowByDn(this.getAgamaFlowDn(flowName));
    }

    public Flow getFlowByDn(String dn) {
        try {
            return (Flow)this.persistenceEntryManager.find(Flow.class, (Object)dn);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    public void addAgamaFlow(Flow flow) {
        this.logger.debug("Added Agama Flow:{}", (Object)flow);
        flow.setBaseDn(this.getAgamaFlowDn(flow.getQname()));
        this.persistenceEntryManager.persist((Object)flow);
    }

    public void updateFlow(Flow flow) {
        this.logger.debug("Update Agama Flow:{}", (Object)flow);
        this.persistenceEntryManager.merge((Object)flow);
    }

    public void removeAgamaFlow(String flowName) {
        this.logger.debug("Remove Agama Flow:{}", (Object)flowName);
        this.persistenceEntryManager.removeRecursively(this.getAgamaFlowDn(flowName), Flow.class);
    }

    public String getAgamaFlowDn(String flowName) {
        this.logger.debug("Agama flowName:{}", (Object)flowName);
        if (StringUtils.isBlank((CharSequence)flowName)) {
            return AGAMA_FLOWS_BASE;
        }
        return String.format("%s=%s,%s", "agFlowQname", flowName, AGAMA_FLOWS_BASE);
    }

    public AgamaConfiguration getAgamaConfiguration() {
        return this.authUtil.getAgamaConfiguration();
    }

    public String validateFlowFields(Flow flow, boolean checkNonMandatoryFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.validateFlowFields(flow, this.getAgamaConfiguration().getMandatoryAttributes(), this.getAgamaConfiguration().getOptionalAttributes(), checkNonMandatoryFields);
    }

    public String validateFlowFields(Flow flow, List<String> mandatoryAttributes, List<String> optionalAttributes, boolean checkNonMandatoryFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.logger.debug("Validate Flow Fields flow - flow:{}, mandatoryAttributes:{} , optionalAttributes:{}, checkNonMandatoryFields:{}", new Object[]{flow, mandatoryAttributes, optionalAttributes, checkNonMandatoryFields});
        StringBuilder errorMsg = new StringBuilder();
        if (mandatoryAttributes == null || mandatoryAttributes.isEmpty()) {
            return errorMsg.toString();
        }
        Map objectPropertyMap = DataUtil.getFieldTypeMap(flow.getClass());
        this.logger.debug("Flow class objectPropertyMap:{} ", (Object)objectPropertyMap);
        if (objectPropertyMap == null || objectPropertyMap.isEmpty()) {
            return errorMsg.toString();
        }
        Set keys = objectPropertyMap.keySet();
        this.logger.debug("Flow class fields:{} ", keys);
        String attributeValue = null;
        for (String attribute : mandatoryAttributes) {
            this.logger.debug("Flow class objectPropertyMap:{} contains attribute:{} ? :{} ", new Object[]{objectPropertyMap, attribute, keys.contains(attribute)});
            if (keys.contains(attribute)) {
                this.logger.debug("Checking value of attribute:{}", (Object)attribute);
                attributeValue = BeanUtils.getProperty((Object)flow, (String)attribute);
                this.logger.debug("Flow attribute:{} - attributeValue:{} ", (Object)attribute, (Object)attributeValue);
            }
            this.logger.debug("Flow attribute value attribute:{} - attributeValue:{} - datatype:{} ", new Object[]{attribute, attributeValue, objectPropertyMap.get(attribute)});
            if (attributeValue != null) continue;
            errorMsg.append(attribute).append(",");
        }
        this.logger.debug("Checking mandatory errorMsg:{} ", (Object)errorMsg);
        if (errorMsg.length() > 0) {
            errorMsg.insert(0, "Required fields missing -> (");
            errorMsg.replace(errorMsg.lastIndexOf(","), errorMsg.length(), "");
            errorMsg.append("). ");
        }
        if (checkNonMandatoryFields) {
            String valiateNonMandatoryFieldsMsg = this.validateNonMandatoryFields(flow, mandatoryAttributes, optionalAttributes);
            this.logger.debug("Checking mandatory valiateNonMandatoryFieldsMsg:{} ", (Object)valiateNonMandatoryFieldsMsg);
            if (StringUtils.isNotBlank((CharSequence)valiateNonMandatoryFieldsMsg)) {
                errorMsg.append(valiateNonMandatoryFieldsMsg);
            }
        }
        this.logger.debug("Returning missingAttributes:{} ", (Object)errorMsg);
        return errorMsg.toString();
    }

    public String validateNonMandatoryFields(Flow flow, List<String> mandatoryAttributes, List<String> optionalAttributes) {
        this.logger.debug("Validate Flow for Non Mandatory Fields - flow:{}, mandatoryAttributes:{}, optionalAttributes:{}", new Object[]{flow, mandatoryAttributes, optionalAttributes});
        StringBuilder unwantedAttributes = new StringBuilder();
        Map objectPropertyMap = DataUtil.getFieldTypeMap(flow.getClass());
        this.logger.debug("Flow class objectPropertyMap:{} ", (Object)objectPropertyMap);
        if (objectPropertyMap == null || objectPropertyMap.isEmpty()) {
            return unwantedAttributes.toString();
        }
        Set keys = objectPropertyMap.keySet();
        this.logger.debug("Flow class fields:{} ", keys);
        keys.removeAll(mandatoryAttributes);
        this.logger.debug("After removing mandatoryAttributes:{}, keys:{} ", mandatoryAttributes, keys);
        keys.removeAll(optionalAttributes);
        this.logger.debug("After removing optionalAttributes:{}, keys:{} ", optionalAttributes, keys);
        Object attributeValue = null;
        String attributeClass = null;
        for (String key : keys) {
            this.logger.debug("Checking value of non-mandatory attribute:{}", (Object)key);
            Getter getter = DataUtil.getGetterMethod(Flow.class, (String)key);
            Class dataType = getter.getReturnType();
            attributeValue = getter.get((Object)flow);
            this.logger.debug("Flow attribute key:{}, getter:{}, dataType:{}, attributeValue:{}", new Object[]{key, getter, dataType, attributeValue});
            if (attributeValue == null) continue;
            attributeClass = attributeValue.getClass().toString();
            this.logger.debug(" Flow attribute data - key:{} - attributeValue:{}, attributeClass:{}, dataType:{}", new Object[]{key, attributeValue, attributeClass, dataType});
            this.logger.trace("Non Mandatory attribute check result - key:{} - attributeValue:{}, dataType:{}, !isStringDataPresent(dataType, attributeValue):{}, !isIntegerDataPresent(dataType, attributeValue):{}, !isFlowMetadataPresent(dataType, attributeValue):{}", new Object[]{key, attributeValue, dataType, !this.isStringDataPresent(dataType, attributeValue), !this.isIntegerDataPresent(dataType, attributeValue), !this.isFlowMetadataPresent(dataType, attributeValue)});
            if (!this.isStringDataPresent(dataType, attributeValue) && !this.isIntegerDataPresent(dataType, attributeValue) && !this.isFlowMetadataPresent(dataType, attributeValue)) continue;
            unwantedAttributes.append(key).append(",");
        }
        this.logger.debug("Checking mandatory unwantedAttributes:{} ", (Object)unwantedAttributes);
        if (unwantedAttributes.length() > 0) {
            unwantedAttributes.insert(0, "Value of these fields should be null -> (");
            unwantedAttributes.replace(unwantedAttributes.lastIndexOf(","), unwantedAttributes.length(), "");
            unwantedAttributes.append(").");
        }
        this.logger.debug("Returning unwantedAttributes:{} ", (Object)unwantedAttributes);
        return unwantedAttributes.toString();
    }

    private boolean isStringDataPresent(Class<?> dataType, Object attributeValue) {
        this.logger.debug("Validate Flow String data - dataType:{}, attributeValue:{}", dataType, attributeValue);
        if (dataType == null || attributeValue == null) {
            return false;
        }
        return "java.lang.String".equalsIgnoreCase(dataType.getName()) && StringUtils.isNotEmpty((CharSequence)((CharSequence)String.class.cast(attributeValue)));
    }

    private boolean isIntegerDataPresent(Class<?> dataType, Object attributeValue) {
        this.logger.debug("Validate Flow Integer data - dataType:{}, attributeValue:{}", dataType, attributeValue);
        if (dataType == null || attributeValue == null) {
            return false;
        }
        return ("java.lang.Integer".equalsIgnoreCase(dataType.getName()) || "int".equalsIgnoreCase(dataType.getName())) && (Integer)Integer.class.cast(attributeValue) > 0;
    }

    private boolean isFlowMetadataPresent(Class<?> dataType, Object attributeValue) {
        this.logger.debug("Validate FlowMetadata data - dataType:{}, attributeValue:{}", dataType, attributeValue);
        if (dataType == null || attributeValue == null) {
            return false;
        }
        if ("io.jans.agama.model.FlowMetadata".equalsIgnoreCase(dataType.getName())) {
            FlowMetadata flowMetadata = (FlowMetadata)FlowMetadata.class.cast(attributeValue);
            if (flowMetadata == null) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)flowMetadata.getFuncName()) || StringUtils.isNotBlank((CharSequence)flowMetadata.getDisplayName()) || StringUtils.isNotBlank((CharSequence)flowMetadata.getAuthor()) || StringUtils.isNotBlank((CharSequence)flowMetadata.getDescription()) || flowMetadata.getInputs() != null || flowMetadata.getTimeout() != null && flowMetadata.getTimeout() > 0 || flowMetadata.getProperties() != null) {
                this.logger.debug("FlowMetadata is not null !!!");
                return true;
            }
        }
        return false;
    }
}

