/*
 * Decompiled with CFR 0.152.
 */
package io.jans.configapi.service.auth;

import io.jans.as.common.service.OrganizationService;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.util.Util;
import io.jans.configapi.core.util.DataUtil;
import io.jans.model.FieldFilterData;
import io.jans.model.SearchRequest;
import io.jans.model.token.TokenEntity;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class TokenService {
    @Inject
    private Logger logger;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private OrganizationService organizationService;
    @Inject
    StaticConfiguration staticConfiguration;

    public String getDnForTokenEntity(String tknCde) {
        String orgDn = this.organizationService.getDnForOrganization();
        if (StringHelper.isEmpty((String)tknCde)) {
            return String.format("ou=tokens,%s", orgDn);
        }
        return String.format("tknCde=%s,ou=tokens,%s", tknCde, orgDn);
    }

    public String getDnForUser(String userInum) {
        String peopleDn = this.staticConfiguration.getBaseDn().getPeople();
        if (StringHelper.isEmpty((String)userInum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", userInum, peopleDn);
    }

    public TokenEntity getTokenEntityByCode(String tknCde) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Get token - tknCde():{}", (Object)Util.escapeLog((Object)tknCde));
        }
        TokenEntity tokenEntity = null;
        try {
            tokenEntity = (TokenEntity)this.persistenceEntryManager.find(TokenEntity.class, (Object)this.getDnForTokenEntity(tknCde));
        }
        catch (Exception ex) {
            this.logger.error("Failed to get Token identified by tknCde:{" + tknCde + "}", (Throwable)ex);
            return tokenEntity;
        }
        return tokenEntity;
    }

    public PagedResult<TokenEntity> searchToken(SearchRequest searchRequest) {
        this.logger.info("Search Token with searchRequest:{}", (Object)searchRequest);
        Filter searchFilter = null;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (searchRequest.getFilterAssertionValue() != null && !searchRequest.getFilterAssertionValue().isEmpty()) {
            this.logger.trace("Search Token searchRequest.getFilterAssertionValue() :{}", (Object)searchRequest.getFilterAssertionValue());
            for (String assertionValue : searchRequest.getFilterAssertionValue()) {
                this.logger.info("Session Search with assertionValue:{}", (Object)assertionValue);
                if (StringUtils.isNotBlank((CharSequence)assertionValue)) {
                    String[] targetArray = new String[]{assertionValue};
                    Filter grantIdFilter = Filter.createSubstringFilter((String)"grtId", null, (String[])targetArray, null);
                    Filter userIdFilter = Filter.createSubstringFilter((String)"usrId", null, (String[])targetArray, null);
                    Filter userDnFilter = Filter.createSubstringFilter((String)"jansUsrDN", null, (String[])targetArray, null);
                    Filter clientIdFilter = Filter.createSubstringFilter((String)"clnId", null, (String[])targetArray, null);
                    Filter scopeFilter = Filter.createSubstringFilter((String)"scp", null, (String[])targetArray, null);
                    Filter tokenTypeFilter = Filter.createSubstringFilter((String)"tknTyp", null, (String[])targetArray, null);
                    Filter grantTypeFilter = Filter.createSubstringFilter((String)"grtTyp", null, (String[])targetArray, null);
                    Filter inumFilter = Filter.createSubstringFilter((String)"jansId", null, (String[])targetArray, null);
                    filters.add(Filter.createORFilter((Filter[])new Filter[]{grantIdFilter, userIdFilter, userDnFilter, clientIdFilter, scopeFilter, tokenTypeFilter, grantTypeFilter, inumFilter}));
                }
                searchFilter = Filter.createORFilter(filters);
            }
            this.logger.trace("Search Token searchFilter :{}", searchFilter);
        }
        this.logger.debug("Token pattern searchFilter:{}", searchFilter);
        List fieldValueFilters = new ArrayList();
        if (searchRequest.getFieldFilterData() != null && !searchRequest.getFieldFilterData().isEmpty()) {
            List<FieldFilterData> fieldFilterDataList = this.modifyFilter(searchRequest.getFieldFilterData());
            fieldValueFilters = DataUtil.createFilter(fieldFilterDataList, (String)this.getDnForTokenEntity(null), (PersistenceEntryManager)this.persistenceEntryManager);
        }
        searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter(filters), Filter.createANDFilter(fieldValueFilters)});
        this.logger.info("Token final searchFilter:{}", (Object)searchFilter);
        return this.persistenceEntryManager.findPagedEntries(this.getDnForTokenEntity(null), TokenEntity.class, searchFilter, null, searchRequest.getSortBy(), SortOrder.getByValue((String)searchRequest.getSortOrder()), searchRequest.getStartIndex().intValue(), searchRequest.getCount().intValue(), searchRequest.getMaxCount());
    }

    public List<TokenEntity> getTokenEntityBySessionDn(String sessionDn, String[] tokenTypeList) {
        this.logger.info("Get Token for a sessionDn:{}, tokenTypeList:{}", (Object)sessionDn, (Object)tokenTypeList);
        List tokens = null;
        if (StringUtils.isEmpty((CharSequence)sessionDn)) {
            return tokens;
        }
        Filter ssnIdFilter = Filter.createEqualityFilter((String)"ssnId", (Object)sessionDn);
        Filter searchFilter = Filter.createANDFilter((Filter[])new Filter[]{ssnIdFilter});
        if (tokenTypeList != null && tokenTypeList.length > 0) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createANDFilter((Filter[])new Filter[]{ssnIdFilter}), Filter.createSubstringFilter((String)"tknTyp", null, (String[])tokenTypeList, null)});
        }
        this.logger.info("Fileter for token sessionDn:{}, tokenTypeList:{} is:{}", new Object[]{sessionDn, tokenTypeList, searchFilter});
        tokens = this.persistenceEntryManager.findEntries(this.getDnForTokenEntity(null), TokenEntity.class, searchFilter);
        this.logger.debug("Token for session sessionDn:{} are tokens:{}", (Object)sessionDn, (Object)tokens);
        return tokens;
    }

    public void revokeTokenEntity(String tknCde) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" Revoke token - tknCde:{}", (Object)Util.escapeLog((Object)tknCde));
        }
        TokenEntity tokenEntity = this.getTokenEntityByCode(tknCde);
        this.logger.debug("Token to be revoked identified by tknCde:{} is:{}", (Object)tokenEntity, (Object)tknCde);
        if (tokenEntity == null) {
            throw new NotFoundException("Could not find Token identified by - " + tknCde);
        }
        this.persistenceEntryManager.removeRecursively(tokenEntity.getDn(), TokenEntity.class);
    }

    private List<FieldFilterData> modifyFilter(List<FieldFilterData> fieldFilterDataList) {
        this.logger.debug("modify filter - fieldFilterDataList:{}", fieldFilterDataList);
        if (fieldFilterDataList == null || fieldFilterDataList.isEmpty()) {
            return fieldFilterDataList;
        }
        for (FieldFilterData fieldFilterData : fieldFilterDataList) {
            String field;
            if (fieldFilterData == null || !StringUtils.isNotBlank((CharSequence)fieldFilterData.getField()) || !"jansUsrDN".equalsIgnoreCase(field = fieldFilterData.getField())) continue;
            fieldFilterData.setValue(this.getDnForUser(fieldFilterData.getValue()));
        }
        return fieldFilterDataList;
    }
}

